"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends7 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var antStatusProcessing = new _cssinjs.Keyframes('antStatusProcessing', {
  '0%': {
    transform: 'scale(0.8)',
    opacity: 0.5
  },
  '100%': {
    transform: 'scale(2.4)',
    opacity: 0
  }
});
var antZoomBadgeIn = new _cssinjs.Keyframes('antZoomBadgeIn', {
  '0%': {
    transform: 'scale(0) translate(50%, -50%)',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1) translate(50%, -50%)'
  }
});
var antZoomBadgeOut = new _cssinjs.Keyframes('antZoomBadgeOut', {
  '0%': {
    transform: 'scale(1) translate(50%, -50%)'
  },
  '100%': {
    transform: 'scale(0) translate(50%, -50%)',
    opacity: 0
  }
});
var antNoWrapperZoomBadgeIn = new _cssinjs.Keyframes('antNoWrapperZoomBadgeIn', {
  '0%': {
    transform: 'scale(0)',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)'
  }
});
var antNoWrapperZoomBadgeOut = new _cssinjs.Keyframes('antNoWrapperZoomBadgeOut', {
  '0%': {
    transform: 'scale(1)'
  },
  '100%': {
    transform: 'scale(0)',
    opacity: 0
  }
});
var antBadgeLoadingCircle = new _cssinjs.Keyframes('antBadgeLoadingCircle', {
  '0%': {
    transformOrigin: '50%'
  },
  '100%': {
    transform: 'translate(50%, -50%) rotate(360deg)',
    transformOrigin: '50%'
  }
});
var genSharedBadgeStyle = function genSharedBadgeStyle(token) {
  var _extends2, _$concat, _$concat3, _extends4, _extends5, _extends6, _ref5;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    antCls = token.antCls,
    badgeFontHeight = token.badgeFontHeight,
    badgeShadowSize = token.badgeShadowSize,
    badgeHeightSm = token.badgeHeightSm,
    motionDurationSlow = token.motionDurationSlow,
    badgeStatusSize = token.badgeStatusSize,
    marginXS = token.marginXS,
    badgeRibbonOffset = token.badgeRibbonOffset;
  var numberPrefixCls = "".concat(antCls, "-scroll-number");
  var ribbonPrefixCls = "".concat(antCls, "-ribbon");
  var ribbonWrapperPrefixCls = "".concat(antCls, "-ribbon-wrapper");
  var statusPreset = (0, _style.genPresetColor)(token, function (colorKey, _ref) {
    var darkColor = _ref.darkColor;
    return (0, _defineProperty2.default)({}, "".concat(componentCls, "-status-").concat(colorKey), {
      background: darkColor
    });
  });
  var statusRibbonPreset = (0, _style.genPresetColor)(token, function (colorKey, _ref3) {
    var darkColor = _ref3.darkColor;
    return (0, _defineProperty2.default)({}, "&".concat(ribbonPrefixCls, "-color-").concat(colorKey), {
      background: darkColor,
      color: darkColor
    });
  });
  return _ref5 = {}, (0, _defineProperty2.default)(_ref5, componentCls, (0, _extends7.default)((0, _extends7.default)({}, (0, _style.resetComponent)(token)), (_extends4 = {
    position: 'relative',
    display: 'inline-block',
    width: 'fit-content',
    lineHeight: 1
  }, (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-count"), {
    zIndex: token.badgeZIndex,
    minWidth: token.badgeHeight,
    height: token.badgeHeight,
    color: token.badgeTextColor,
    fontWeight: token.badgeFontWeight,
    fontSize: token.badgeFontSize,
    lineHeight: "".concat(token.badgeHeight, "px"),
    whiteSpace: 'nowrap',
    textAlign: 'center',
    background: token.badgeColor,
    borderRadius: token.badgeHeight / 2,
    boxShadow: "0 0 0 ".concat(badgeShadowSize, "px ").concat(token.badgeShadowColor),
    transition: "background ".concat(token.motionDurationMid),
    a: {
      color: token.badgeTextColor
    },
    'a:hover': {
      color: token.badgeTextColor
    },
    'a:hover &': {
      background: token.badgeColorHover
    }
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-count-sm"), {
    minWidth: badgeHeightSm,
    height: badgeHeightSm,
    fontSize: token.badgeFontSizeSm,
    lineHeight: "".concat(badgeHeightSm, "px"),
    borderRadius: badgeHeightSm / 2
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-multiple-words"), {
    padding: "0 ".concat(token.paddingXS, "px")
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-dot"), {
    zIndex: token.badgeZIndex,
    width: token.badgeDotSize,
    minWidth: token.badgeDotSize,
    height: token.badgeDotSize,
    background: token.badgeColor,
    borderRadius: '100%',
    boxShadow: "0 0 0 ".concat(badgeShadowSize, "px ").concat(token.badgeShadowColor)
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-dot").concat(numberPrefixCls), {
    transition: "background ".concat(motionDurationSlow)
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-count, ").concat(componentCls, "-dot, ").concat(numberPrefixCls, "-custom-component"), (0, _defineProperty2.default)({
    position: 'absolute',
    top: 0,
    insetInlineEnd: 0,
    transform: 'translate(50%, -50%)',
    transformOrigin: '100% 0%'
  }, "".concat(iconCls, "-spin"), {
    animationName: antBadgeLoadingCircle,
    animationDuration: token.motionDurationMid,
    animationIterationCount: 'infinite',
    animationTimingFunction: 'linear'
  })), (0, _defineProperty2.default)(_extends4, "&".concat(componentCls, "-status"), (0, _extends7.default)((0, _extends7.default)((_extends2 = {
    lineHeight: 'inherit',
    verticalAlign: 'baseline'
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-dot"), {
    position: 'relative',
    top: -1,
    display: 'inline-block',
    width: badgeStatusSize,
    height: badgeStatusSize,
    verticalAlign: 'middle',
    borderRadius: '50%'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-success"), {
    backgroundColor: token.colorSuccess
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-processing"), {
    position: 'relative',
    color: token.colorPrimary,
    backgroundColor: token.colorPrimary,
    '&::after': {
      position: 'absolute',
      top: 0,
      insetInlineStart: 0,
      width: '100%',
      height: '100%',
      borderWidth: badgeShadowSize,
      borderStyle: 'solid',
      borderColor: 'inherit',
      borderRadius: '50%',
      animationName: antStatusProcessing,
      animationDuration: token.badgeProcessingDuration,
      animationIterationCount: 'infinite',
      animationTimingFunction: 'ease-in-out',
      content: '""'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-default"), {
    backgroundColor: token.colorTextPlaceholder
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-error"), {
    backgroundColor: token.colorError
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-status-warning"), {
    backgroundColor: token.colorWarning
  }), _extends2), statusPreset), (0, _defineProperty2.default)({}, "".concat(componentCls, "-status-text"), {
    marginInlineStart: marginXS,
    color: token.colorText,
    fontSize: token.fontSize
  }))), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-zoom-appear, ").concat(componentCls, "-zoom-enter"), {
    animationName: antZoomBadgeIn,
    animationDuration: token.motionDurationSlow,
    animationTimingFunction: token.motionEaseOutBack,
    animationFillMode: 'both'
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-zoom-leave"), {
    animationName: antZoomBadgeOut,
    animationDuration: token.motionDurationSlow,
    animationTimingFunction: token.motionEaseOutBack,
    animationFillMode: 'both'
  }), (0, _defineProperty2.default)(_extends4, "&".concat(componentCls, "-not-a-wrapper"), (_$concat = {}, (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-zoom-appear, ").concat(componentCls, "-zoom-enter"), {
    animationName: antNoWrapperZoomBadgeIn,
    animationDuration: token.motionDurationSlow,
    animationTimingFunction: token.motionEaseOutBack
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-zoom-leave"), {
    animationName: antNoWrapperZoomBadgeOut,
    animationDuration: token.motionDurationSlow,
    animationTimingFunction: token.motionEaseOutBack
  }), (0, _defineProperty2.default)(_$concat, "&:not(".concat(componentCls, "-status)"), {
    verticalAlign: 'middle'
  }), (0, _defineProperty2.default)(_$concat, "".concat(numberPrefixCls, "-custom-component, ").concat(componentCls, "-count"), {
    transform: 'none'
  }), (0, _defineProperty2.default)(_$concat, "".concat(numberPrefixCls, "-custom-component, ").concat(numberPrefixCls), {
    position: 'relative',
    top: 'auto',
    display: 'block',
    transformOrigin: '50% 50%'
  }), _$concat)), (0, _defineProperty2.default)(_extends4, "".concat(numberPrefixCls), (_$concat3 = {
    overflow: 'hidden'
  }, (0, _defineProperty2.default)(_$concat3, "".concat(numberPrefixCls, "-only"), (0, _defineProperty2.default)({
    position: 'relative',
    display: 'inline-block',
    height: token.badgeHeight,
    transition: "all ".concat(token.motionDurationSlow, " ").concat(token.motionEaseOutBack),
    WebkitTransformStyle: 'preserve-3d',
    WebkitBackfaceVisibility: 'hidden'
  }, "> p".concat(numberPrefixCls, "-only-unit"), {
    height: token.badgeHeight,
    margin: 0,
    WebkitTransformStyle: 'preserve-3d',
    WebkitBackfaceVisibility: 'hidden'
  })), (0, _defineProperty2.default)(_$concat3, "".concat(numberPrefixCls, "-symbol"), {
    verticalAlign: 'top'
  }), _$concat3)), (0, _defineProperty2.default)(_extends4, '&-rtl', (0, _defineProperty2.default)({
    direction: 'rtl'
  }, "".concat(componentCls, "-count, ").concat(componentCls, "-dot, ").concat(numberPrefixCls, "-custom-component"), {
    transform: 'translate(-50%, -50%)'
  })), _extends4))), (0, _defineProperty2.default)(_ref5, "".concat(ribbonWrapperPrefixCls), {
    position: 'relative'
  }), (0, _defineProperty2.default)(_ref5, "".concat(ribbonPrefixCls), (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({}, (0, _style.resetComponent)(token)), (_extends5 = {
    position: 'absolute',
    top: marginXS,
    height: badgeFontHeight,
    padding: "0 ".concat(token.paddingXS, "px"),
    color: token.colorPrimary,
    lineHeight: "".concat(badgeFontHeight, "px"),
    whiteSpace: 'nowrap',
    backgroundColor: token.colorPrimary,
    borderRadius: token.borderRadiusSM
  }, (0, _defineProperty2.default)(_extends5, "".concat(ribbonPrefixCls, "-text"), {
    color: token.colorTextLightSolid
  }), (0, _defineProperty2.default)(_extends5, "".concat(ribbonPrefixCls, "-corner"), {
    position: 'absolute',
    top: '100%',
    width: badgeRibbonOffset,
    height: badgeRibbonOffset,
    color: 'currentcolor',
    border: "".concat(badgeRibbonOffset / 2, "px solid"),
    transform: token.badgeRibbonCornerTransform,
    transformOrigin: 'top',
    filter: token.badgeRibbonCornerFilter
  }), _extends5)), statusRibbonPreset), (_extends6 = {}, (0, _defineProperty2.default)(_extends6, "&".concat(ribbonPrefixCls, "-placement-end"), (0, _defineProperty2.default)({
    insetInlineEnd: -badgeRibbonOffset,
    borderEndEndRadius: 0
  }, "".concat(ribbonPrefixCls, "-corner"), {
    insetInlineEnd: 0,
    borderInlineEndColor: 'transparent',
    borderBlockEndColor: 'transparent'
  })), (0, _defineProperty2.default)(_extends6, "&".concat(ribbonPrefixCls, "-placement-start"), (0, _defineProperty2.default)({
    insetInlineStart: -badgeRibbonOffset,
    borderEndStartRadius: 0
  }, "".concat(ribbonPrefixCls, "-corner"), {
    insetInlineStart: 0,
    borderBlockEndColor: 'transparent',
    borderInlineStartColor: 'transparent'
  })), (0, _defineProperty2.default)(_extends6, '&-rtl', {
    direction: 'rtl'
  }), _extends6))), _ref5;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Badge', function (token) {
  var fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    fontSizeSM = token.fontSizeSM,
    lineWidth = token.lineWidth,
    marginXS = token.marginXS,
    colorBorderBg = token.colorBorderBg;
  var badgeFontHeight = Math.round(fontSize * lineHeight);
  var badgeShadowSize = lineWidth;
  var badgeZIndex = 'auto';
  var badgeHeight = badgeFontHeight - 2 * badgeShadowSize;
  var badgeTextColor = token.colorBgContainer;
  var badgeFontWeight = 'normal';
  var badgeFontSize = fontSizeSM;
  var badgeColor = token.colorError;
  var badgeColorHover = token.colorErrorHover;
  var badgeHeightSm = fontSize;
  var badgeDotSize = fontSizeSM / 2;
  var badgeFontSizeSm = fontSizeSM;
  var badgeStatusSize = fontSizeSM / 2;
  var badgeToken = (0, _internal.mergeToken)(token, {
    badgeFontHeight: badgeFontHeight,
    badgeShadowSize: badgeShadowSize,
    badgeZIndex: badgeZIndex,
    badgeHeight: badgeHeight,
    badgeTextColor: badgeTextColor,
    badgeFontWeight: badgeFontWeight,
    badgeFontSize: badgeFontSize,
    badgeColor: badgeColor,
    badgeColorHover: badgeColorHover,
    badgeShadowColor: colorBorderBg,
    badgeHeightSm: badgeHeightSm,
    badgeDotSize: badgeDotSize,
    badgeFontSizeSm: badgeFontSizeSm,
    badgeStatusSize: badgeStatusSize,
    badgeProcessingDuration: '1.2s',
    badgeRibbonOffset: marginXS,
    // Follow token just by Design. Not related with token
    badgeRibbonCornerTransform: 'scaleY(0.75)',
    badgeRibbonCornerFilter: "brightness(75%)"
  });
  return [genSharedBadgeStyle(badgeToken)];
});
exports.default = _default;