"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.buttonGroupProps = exports.GroupSizeContext = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _propsUtil = require("../_util/props-util");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _internal = require("../theme/internal");
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _createContext = _interopRequireDefault(require("../_util/createContext"));
var buttonGroupProps = function buttonGroupProps() {
  return {
    prefixCls: String,
    size: {
      type: String
    }
  };
};
exports.buttonGroupProps = buttonGroupProps;
var GroupSizeContext = (0, _createContext.default)();
exports.GroupSizeContext = GroupSizeContext;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AButtonGroup',
  props: buttonGroupProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var _useConfigInject = (0, _useConfigInject2.default)('btn-group', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useToken = (0, _internal.useToken)(),
      _useToken2 = (0, _slicedToArray2.default)(_useToken, 3),
      hashId = _useToken2[2];
    GroupSizeContext.useProvide((0, _vue.reactive)({
      size: (0, _vue.computed)(function () {
        return props.size;
      })
    }));
    var classes = (0, _vue.computed)(function () {
      var _ref2;
      var size = props.size;
      var sizeCls = '';
      switch (size) {
        case 'large':
          sizeCls = 'lg';
          break;
        case 'small':
          sizeCls = 'sm';
          break;
        case 'middle':
        case undefined:
          break;
        default:
          // eslint-disable-next-line no-console
          (0, _devWarning.default)(!size, 'Button.Group', 'Invalid prop `size`.');
      }
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-").concat(sizeCls), sizeCls), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_ref2, hashId.value, true), _ref2;
    });
    return function () {
      var _a;
      return (0, _vue.createVNode)("div", {
        "class": classes.value
      }, [(0, _propsUtil.flattenChildren)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots))]);
    };
  }
});
exports.default = _default;