"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "buttonProps", {
  enumerable: true,
  get: function get() {
    return _buttonTypes.default;
  }
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _wave = _interopRequireDefault(require("../_util/wave"));
var _buttonTypes = _interopRequireDefault(require("./buttonTypes"));
var _propsUtil = require("../_util/props-util");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _LoadingIcon = _interopRequireDefault(require("./LoadingIcon"));
var _style = _interopRequireDefault(require("./style"));
var _buttonGroup = require("./button-group");
var _Compact = require("../space/Compact");
var rxTwoCNChar = /^[\u4e00-\u9fa5]{2}$/;
var isTwoCNChar = rxTwoCNChar.test.bind(rxTwoCNChar);
function isUnBorderedButtonType(type) {
  return type === 'text' || type === 'link';
}
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AButton',
  inheritAttrs: false,
  __ANT_BUTTON: true,
  props: (0, _propsUtil.initDefaultProps)((0, _buttonTypes.default)(), {
    type: 'default'
  }),
  slots: ['icon'],
  // emits: ['click', 'mousedown'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit,
      expose = _ref.expose;
    var _useConfigInject = (0, _useConfigInject2.default)('btn', props),
      prefixCls = _useConfigInject.prefixCls,
      autoInsertSpaceInButton = _useConfigInject.autoInsertSpaceInButton,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var groupSizeContext = _buttonGroup.GroupSizeContext.useInject();
    var buttonNodeRef = (0, _vue.shallowRef)(null);
    var delayTimeoutRef = (0, _vue.shallowRef)(undefined);
    var isNeedInserted = false;
    var innerLoading = (0, _vue.shallowRef)(false);
    var hasTwoCNChar = (0, _vue.shallowRef)(false);
    var autoInsertSpace = (0, _vue.computed)(function () {
      return autoInsertSpaceInButton.value !== false;
    });
    var _useCompactItemContex = (0, _Compact.useCompactItemContext)(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    // =============== Update Loading ===============
    var loadingOrDelay = (0, _vue.computed)(function () {
      return (0, _typeof2.default)(props.loading) === 'object' && props.loading.delay ? props.loading.delay || true : !!props.loading;
    });
    (0, _vue.watch)(loadingOrDelay, function (val) {
      clearTimeout(delayTimeoutRef.value);
      if (typeof loadingOrDelay.value === 'number') {
        delayTimeoutRef.value = setTimeout(function () {
          innerLoading.value = val;
        }, loadingOrDelay.value);
      } else {
        innerLoading.value = val;
      }
    }, {
      immediate: true
    });
    var classes = (0, _vue.computed)(function () {
      var _ref2;
      var type = props.type,
        _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'default' : _props$shape,
        ghost = props.ghost,
        block = props.block,
        danger = props.danger;
      var pre = prefixCls.value;
      var sizeClassNameMap = {
        large: 'lg',
        small: 'sm',
        middle: undefined
      };
      var sizeFullname = compactSize.value || (groupSizeContext === null || groupSizeContext === void 0 ? void 0 : groupSizeContext.size) || size.value;
      var sizeCls = sizeFullname ? sizeClassNameMap[sizeFullname] || '' : '';
      return [compactItemClassnames.value, (_ref2 = {}, (0, _defineProperty2.default)(_ref2, hashId.value, true), (0, _defineProperty2.default)(_ref2, "".concat(pre), true), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(shape), shape !== 'default' && shape), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(type), type), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(sizeCls), sizeCls), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-loading"), innerLoading.value), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-background-ghost"), ghost && !isUnBorderedButtonType(type)), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-two-chinese-chars"), hasTwoCNChar.value && autoInsertSpace.value), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-block"), block), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-dangerous"), !!danger), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _ref2)];
    });
    var fixTwoCNChar = function fixTwoCNChar() {
      // Fix for HOC usage like <FormatMessage />
      var node = buttonNodeRef.value;
      if (!node || autoInsertSpaceInButton.value === false) {
        return;
      }
      var buttonText = node.textContent;
      if (isNeedInserted && isTwoCNChar(buttonText)) {
        if (!hasTwoCNChar.value) {
          hasTwoCNChar.value = true;
        }
      } else if (hasTwoCNChar.value) {
        hasTwoCNChar.value = false;
      }
    };
    var handleClick = function handleClick(event) {
      // https://github.com/ant-design/ant-design/issues/30207
      if (innerLoading.value || props.disabled) {
        event.preventDefault();
        return;
      }
      emit('click', event);
    };
    var handleMousedown = function handleMousedown(event) {
      emit('mousedown', event);
    };
    var insertSpace = function insertSpace(child, needInserted) {
      var SPACE = needInserted ? ' ' : '';
      if (child.type === _vue.Text) {
        var text = child.children.trim();
        if (isTwoCNChar(text)) {
          text = text.split('').join(SPACE);
        }
        return (0, _vue.createVNode)("span", null, [text]);
      }
      return child;
    };
    (0, _vue.watchEffect)(function () {
      (0, _devWarning.default)(!(props.ghost && isUnBorderedButtonType(props.type)), 'Button', "`link` or `text` button can't be a `ghost` button.");
    });
    (0, _vue.onMounted)(fixTwoCNChar);
    (0, _vue.onUpdated)(fixTwoCNChar);
    (0, _vue.onBeforeUnmount)(function () {
      delayTimeoutRef.value && clearTimeout(delayTimeoutRef.value);
    });
    var focus = function focus() {
      var _a;
      (_a = buttonNodeRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = buttonNodeRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    return function () {
      var _a, _b;
      var _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_a = slots.icon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$icon;
      var children = (0, _propsUtil.flattenChildren)((_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots));
      isNeedInserted = children.length === 1 && !icon && !isUnBorderedButtonType(props.type);
      var type = props.type,
        htmlType = props.htmlType,
        disabled = props.disabled,
        href = props.href,
        title = props.title,
        target = props.target;
      var iconType = innerLoading.value ? 'loading' : icon;
      var buttonProps = (0, _extends2.default)((0, _extends2.default)({}, attrs), {
        title: title,
        disabled: disabled,
        class: [classes.value, attrs.class, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-icon-only"), children.length === 0 && !!iconType)],
        onClick: handleClick,
        onMousedown: handleMousedown
      });
      // https://github.com/vueComponent/ant-design-vue/issues/4930
      if (!disabled) {
        delete buttonProps.disabled;
      }
      var iconNode = icon && !innerLoading.value ? icon : (0, _vue.createVNode)(_LoadingIcon.default, {
        "existIcon": !!icon,
        "prefixCls": prefixCls.value,
        "loading": !!innerLoading.value
      }, null);
      var kids = children.map(function (child) {
        return insertSpace(child, isNeedInserted && autoInsertSpace.value);
      });
      if (href !== undefined) {
        return wrapSSR((0, _vue.createVNode)("a", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, buttonProps), {}, {
          "href": href,
          "target": target,
          "ref": buttonNodeRef
        }), [iconNode, kids]));
      }
      var buttonNode = (0, _vue.createVNode)("button", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, buttonProps), {}, {
        "ref": buttonNodeRef,
        "type": htmlType
      }), [iconNode, kids]);
      if (!isUnBorderedButtonType(type)) {
        var _buttonNode = function () {
          return buttonNode;
        }();
        buttonNode = (0, _vue.createVNode)(_wave.default, {
          "ref": "wave",
          "disabled": !!innerLoading.value
        }, {
          default: function _default() {
            return [_buttonNode];
          }
        });
      }
      return wrapSSR(buttonNode);
    };
  }
});
exports.default = _default2;