"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends7 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _internal = require("../../theme/internal");
var _group = _interopRequireDefault(require("./group"));
var _style = require("../../style");
var _compactItem = require("../../style/compact-item");
var _compactItemVertical = require("../../style/compact-item-vertical");
// ============================== Shared ==============================
var genSharedButtonStyle = function genSharedButtonStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls,
    iconCls = token.iconCls;
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls = {
    outline: 'none',
    position: 'relative',
    display: 'inline-block',
    fontWeight: 400,
    whiteSpace: 'nowrap',
    textAlign: 'center',
    backgroundImage: 'none',
    backgroundColor: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut),
    userSelect: 'none',
    touchAction: 'manipulation',
    lineHeight: token.lineHeight,
    color: token.colorText,
    '> span': {
      display: 'inline-block'
    }
  }, (0, _defineProperty2.default)(_componentCls, "> ".concat(iconCls, " + span, > span + ").concat(iconCls), {
    marginInlineStart: token.marginXS
  }), (0, _defineProperty2.default)(_componentCls, '> a', {
    color: 'currentColor'
  }), (0, _defineProperty2.default)(_componentCls, '&:not(:disabled)', (0, _extends7.default)({}, (0, _style.genFocusStyle)(token))), (0, _defineProperty2.default)(_componentCls, "&-icon-only".concat(componentCls, "-compact-item"), {
    flex: 'none'
  }), (0, _defineProperty2.default)(_componentCls, "&-compact-item".concat(componentCls, "-primary"), (0, _defineProperty2.default)({}, "&:not([disabled]) + ".concat(componentCls, "-compact-item").concat(componentCls, "-primary:not([disabled])"), {
    position: 'relative',
    '&:before': {
      position: 'absolute',
      top: -token.lineWidth,
      insetInlineStart: -token.lineWidth,
      display: 'inline-block',
      width: token.lineWidth,
      height: "calc(100% + ".concat(token.lineWidth * 2, "px)"),
      backgroundColor: token.colorPrimaryHover,
      content: '""'
    }
  })), (0, _defineProperty2.default)(_componentCls, '&-compact-vertical-item', (0, _defineProperty2.default)({}, "&".concat(componentCls, "-primary"), (0, _defineProperty2.default)({}, "&:not([disabled]) + ".concat(componentCls, "-compact-vertical-item").concat(componentCls, "-primary:not([disabled])"), {
    position: 'relative',
    '&:before': {
      position: 'absolute',
      top: -token.lineWidth,
      insetInlineStart: -token.lineWidth,
      display: 'inline-block',
      width: "calc(100% + ".concat(token.lineWidth * 2, "px)"),
      height: token.lineWidth,
      backgroundColor: token.colorPrimaryHover,
      content: '""'
    }
  }))), _componentCls));
};
var genHoverActiveButtonStyle = function genHoverActiveButtonStyle(hoverStyle, activeStyle) {
  return {
    '&:not(:disabled)': {
      '&:hover': hoverStyle,
      '&:active': activeStyle
    }
  };
};
// ============================== Shape ===============================
var genCircleButtonStyle = function genCircleButtonStyle(token) {
  return {
    minWidth: token.controlHeight,
    paddingInlineStart: 0,
    paddingInlineEnd: 0,
    borderRadius: '50%'
  };
};
var genRoundButtonStyle = function genRoundButtonStyle(token) {
  return {
    borderRadius: token.controlHeight,
    paddingInlineStart: token.controlHeight / 2,
    paddingInlineEnd: token.controlHeight / 2
  };
};
// =============================== Type ===============================
var genDisabledStyle = function genDisabledStyle(token) {
  return {
    cursor: 'not-allowed',
    borderColor: token.colorBorder,
    color: token.colorTextDisabled,
    backgroundColor: token.colorBgContainerDisabled,
    boxShadow: 'none'
  };
};
var genGhostButtonStyle = function genGhostButtonStyle(btnCls, textColor, borderColor, textColorDisabled, borderColorDisabled, hoverStyle, activeStyle) {
  return (0, _defineProperty2.default)({}, "&".concat(btnCls, "-background-ghost"), (0, _extends7.default)((0, _extends7.default)({
    color: textColor || undefined,
    backgroundColor: 'transparent',
    borderColor: borderColor || undefined,
    boxShadow: 'none'
  }, genHoverActiveButtonStyle((0, _extends7.default)({
    backgroundColor: 'transparent'
  }, hoverStyle), (0, _extends7.default)({
    backgroundColor: 'transparent'
  }, activeStyle))), {
    '&:disabled': {
      cursor: 'not-allowed',
      color: textColorDisabled || undefined,
      borderColor: borderColorDisabled || undefined
    }
  }));
};
var genSolidDisabledButtonStyle = function genSolidDisabledButtonStyle(token) {
  return {
    '&:disabled': (0, _extends7.default)({}, genDisabledStyle(token))
  };
};
var genSolidButtonStyle = function genSolidButtonStyle(token) {
  return (0, _extends7.default)({}, genSolidDisabledButtonStyle(token));
};
var genPureDisabledButtonStyle = function genPureDisabledButtonStyle(token) {
  return {
    '&:disabled': {
      cursor: 'not-allowed',
      color: token.colorTextDisabled
    }
  };
};
// Type: Default
var genDefaultButtonStyle = function genDefaultButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({}, genSolidButtonStyle(token)), {
    backgroundColor: token.colorBgContainer,
    borderColor: token.colorBorder,
    boxShadow: "0 ".concat(token.controlOutlineWidth, "px 0 ").concat(token.controlTmpOutline)
  }), genHoverActiveButtonStyle({
    color: token.colorPrimaryHover,
    borderColor: token.colorPrimaryHover
  }, {
    color: token.colorPrimaryActive,
    borderColor: token.colorPrimaryActive
  })), genGhostButtonStyle(token.componentCls, token.colorBgContainer, token.colorBgContainer, token.colorTextDisabled, token.colorBorder)), (0, _defineProperty2.default)({}, "&".concat(token.componentCls, "-dangerous"), (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({
    color: token.colorError,
    borderColor: token.colorError
  }, genHoverActiveButtonStyle({
    color: token.colorErrorHover,
    borderColor: token.colorErrorBorderHover
  }, {
    color: token.colorErrorActive,
    borderColor: token.colorErrorActive
  })), genGhostButtonStyle(token.componentCls, token.colorError, token.colorError, token.colorTextDisabled, token.colorBorder)), genSolidDisabledButtonStyle(token))));
};
// Type: Primary
var genPrimaryButtonStyle = function genPrimaryButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({}, genSolidButtonStyle(token)), {
    color: token.colorTextLightSolid,
    backgroundColor: token.colorPrimary,
    boxShadow: "0 ".concat(token.controlOutlineWidth, "px 0 ").concat(token.controlOutline)
  }), genHoverActiveButtonStyle({
    color: token.colorTextLightSolid,
    backgroundColor: token.colorPrimaryHover
  }, {
    color: token.colorTextLightSolid,
    backgroundColor: token.colorPrimaryActive
  })), genGhostButtonStyle(token.componentCls, token.colorPrimary, token.colorPrimary, token.colorTextDisabled, token.colorBorder, {
    color: token.colorPrimaryHover,
    borderColor: token.colorPrimaryHover
  }, {
    color: token.colorPrimaryActive,
    borderColor: token.colorPrimaryActive
  })), (0, _defineProperty2.default)({}, "&".concat(token.componentCls, "-dangerous"), (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({
    backgroundColor: token.colorError,
    boxShadow: "0 ".concat(token.controlOutlineWidth, "px 0 ").concat(token.colorErrorOutline)
  }, genHoverActiveButtonStyle({
    backgroundColor: token.colorErrorHover
  }, {
    backgroundColor: token.colorErrorActive
  })), genGhostButtonStyle(token.componentCls, token.colorError, token.colorError, token.colorTextDisabled, token.colorBorder, {
    color: token.colorErrorHover,
    borderColor: token.colorErrorHover
  }, {
    color: token.colorErrorActive,
    borderColor: token.colorErrorActive
  })), genSolidDisabledButtonStyle(token))));
};
// Type: Dashed
var genDashedButtonStyle = function genDashedButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)({}, genDefaultButtonStyle(token)), {
    borderStyle: 'dashed'
  });
};
// Type: Link
var genLinkButtonStyle = function genLinkButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({
    color: token.colorLink
  }, genHoverActiveButtonStyle({
    color: token.colorLinkHover
  }, {
    color: token.colorLinkActive
  })), genPureDisabledButtonStyle(token)), (0, _defineProperty2.default)({}, "&".concat(token.componentCls, "-dangerous"), (0, _extends7.default)((0, _extends7.default)({
    color: token.colorError
  }, genHoverActiveButtonStyle({
    color: token.colorErrorHover
  }, {
    color: token.colorErrorActive
  })), genPureDisabledButtonStyle(token))));
};
// Type: Text
var genTextButtonStyle = function genTextButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({}, genHoverActiveButtonStyle({
    color: token.colorText,
    backgroundColor: token.colorBgTextHover
  }, {
    color: token.colorText,
    backgroundColor: token.colorBgTextActive
  })), genPureDisabledButtonStyle(token)), (0, _defineProperty2.default)({}, "&".concat(token.componentCls, "-dangerous"), (0, _extends7.default)((0, _extends7.default)({
    color: token.colorError
  }, genPureDisabledButtonStyle(token)), genHoverActiveButtonStyle({
    color: token.colorErrorHover,
    backgroundColor: token.colorErrorBg
  }, {
    color: token.colorErrorHover,
    backgroundColor: token.colorErrorBg
  }))));
};
// Href and Disabled
var genDisabledButtonStyle = function genDisabledButtonStyle(token) {
  return (0, _extends7.default)((0, _extends7.default)({}, genDisabledStyle(token)), (0, _defineProperty2.default)({}, "&".concat(token.componentCls, ":hover"), (0, _extends7.default)({}, genDisabledStyle(token))));
};
var genTypeButtonStyle = function genTypeButtonStyle(token) {
  var _ref3;
  var componentCls = token.componentCls;
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-default"), genDefaultButtonStyle(token)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-primary"), genPrimaryButtonStyle(token)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-dashed"), genDashedButtonStyle(token)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-link"), genLinkButtonStyle(token)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-text"), genTextButtonStyle(token)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-disabled"), genDisabledButtonStyle(token)), _ref3;
};
// =============================== Size ===============================
var genSizeButtonStyle = function genSizeButtonStyle(token) {
  var _$concat2, _$concat$concat;
  var sizePrefixCls = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    controlHeight = token.controlHeight,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    lineWidth = token.lineWidth,
    borderRadius = token.borderRadius,
    buttonPaddingHorizontal = token.buttonPaddingHorizontal;
  var paddingVertical = Math.max(0, (controlHeight - fontSize * lineHeight) / 2 - lineWidth);
  var paddingHorizontal = buttonPaddingHorizontal - lineWidth;
  var iconOnlyCls = "".concat(componentCls, "-icon-only");
  return [// Size
  (0, _defineProperty2.default)({}, "".concat(componentCls).concat(sizePrefixCls), (_$concat$concat = {
    fontSize: fontSize,
    height: controlHeight,
    padding: "".concat(paddingVertical, "px ").concat(paddingHorizontal, "px"),
    borderRadius: borderRadius
  }, (0, _defineProperty2.default)(_$concat$concat, "&".concat(iconOnlyCls), (_$concat2 = {
    width: controlHeight,
    paddingInlineStart: 0,
    paddingInlineEnd: 0
  }, (0, _defineProperty2.default)(_$concat2, "&".concat(componentCls, "-round"), {
    width: 'auto'
  }), (0, _defineProperty2.default)(_$concat2, '> span', {
    transform: 'scale(1.143)' // 14px -> 16px
  }), _$concat2)), (0, _defineProperty2.default)(_$concat$concat, "&".concat(componentCls, "-loading"), {
    opacity: token.opacityLoading,
    cursor: 'default'
  }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-loading-icon"), {
    transition: "width ".concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut, ", opacity ").concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut)
  }), (0, _defineProperty2.default)(_$concat$concat, "&:not(".concat(iconOnlyCls, ") ").concat(componentCls, "-loading-icon > ").concat(iconCls), {
    marginInlineEnd: token.marginXS
  }), _$concat$concat)), // Shape - patch prefixCls again to override solid border radius style
  (0, _defineProperty2.default)({}, "".concat(componentCls).concat(componentCls, "-circle").concat(sizePrefixCls), genCircleButtonStyle(token)), (0, _defineProperty2.default)({}, "".concat(componentCls).concat(componentCls, "-round").concat(sizePrefixCls), genRoundButtonStyle(token))];
};
var genSizeBaseButtonStyle = function genSizeBaseButtonStyle(token) {
  return genSizeButtonStyle(token);
};
var genSizeSmallButtonStyle = function genSizeSmallButtonStyle(token) {
  var smallToken = (0, _internal.mergeToken)(token, {
    controlHeight: token.controlHeightSM,
    padding: token.paddingXS,
    buttonPaddingHorizontal: 8,
    borderRadius: token.borderRadiusSM
  });
  return genSizeButtonStyle(smallToken, "".concat(token.componentCls, "-sm"));
};
var genSizeLargeButtonStyle = function genSizeLargeButtonStyle(token) {
  var largeToken = (0, _internal.mergeToken)(token, {
    controlHeight: token.controlHeightLG,
    fontSize: token.fontSizeLG,
    borderRadius: token.borderRadiusLG
  });
  return genSizeButtonStyle(largeToken, "".concat(token.componentCls, "-lg"));
};
var genBlockButtonStyle = function genBlockButtonStyle(token) {
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, "&".concat(componentCls, "-block"), {
    width: '100%'
  }));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Button', function (token) {
  var controlTmpOutline = token.controlTmpOutline,
    paddingContentHorizontal = token.paddingContentHorizontal;
  var buttonToken = (0, _internal.mergeToken)(token, {
    colorOutlineDefault: controlTmpOutline,
    buttonPaddingHorizontal: paddingContentHorizontal
  });
  return [
  // Shared
  genSharedButtonStyle(buttonToken),
  // Size
  genSizeSmallButtonStyle(buttonToken), genSizeBaseButtonStyle(buttonToken), genSizeLargeButtonStyle(buttonToken),
  // Block
  genBlockButtonStyle(buttonToken),
  // Group (type, ghost, danger, disabled, loading)
  genTypeButtonStyle(buttonToken),
  // Button Group
  (0, _group.default)(buttonToken),
  // Space Compact
  (0, _compactItem.genCompactItemStyle)(token, {
    focus: false
  }), (0, _compactItemVertical.genCompactItemVerticalStyle)(token)];
});
exports.default = _default;