"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genCheckboxStyle = exports.default = void 0;
exports.getStyle = getStyle;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _style = require("../../style");
// ============================== Motion ==============================
var antCheckboxEffect = new _cssinjs.Keyframes('antCheckboxEffect', {
  '0%': {
    transform: 'scale(1)',
    opacity: 0.5
  },
  '100%': {
    transform: 'scale(1.6)',
    opacity: 0
  }
});
// ============================== Styles ==============================
var genCheckboxStyle = function genCheckboxStyle(token) {
  var _extends2, _extends3, _ref, _$concat$concat, _ref3, _$concat2, _$concat$con2, _ref4, _$concat3, _ref5;
  var checkboxCls = token.checkboxCls;
  var wrapperCls = "".concat(checkboxCls, "-wrapper");
  return [(_ref = {}, (0, _defineProperty2.default)(_ref, "".concat(checkboxCls, "-group"), (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), {
    display: 'inline-flex'
  })), (0, _defineProperty2.default)(_ref, wrapperCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    display: 'inline-flex',
    alignItems: 'baseline',
    cursor: 'pointer',
    // Fix checkbox & radio in flex align #30260
    '&:after': {
      display: 'inline-block',
      width: 0,
      overflow: 'hidden',
      content: "'\\a0'"
    }
  }, (0, _defineProperty2.default)(_extends2, "& + ".concat(wrapperCls), {
    marginInlineStart: token.marginXS
  }), (0, _defineProperty2.default)(_extends2, "&".concat(wrapperCls, "-in-form-item"), {
    'input[type="checkbox"]': {
      width: 14,
      height: 14 // FIXME: magic
    }
  }), _extends2))), (0, _defineProperty2.default)(_ref, checkboxCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    top: '0.2em',
    position: 'relative',
    whiteSpace: 'nowrap',
    lineHeight: 1,
    cursor: 'pointer'
  }, (0, _defineProperty2.default)(_extends3, "".concat(checkboxCls, "-input"), (0, _defineProperty2.default)({
    position: 'absolute',
    inset: 0,
    zIndex: 1,
    width: '100%',
    height: '100%',
    cursor: 'pointer',
    opacity: 0
  }, "&:focus-visible + ".concat(checkboxCls, "-inner"), (0, _extends4.default)({}, (0, _style.genFocusOutline)(token)))), (0, _defineProperty2.default)(_extends3, "".concat(checkboxCls, "-inner"), {
    boxSizing: 'border-box',
    position: 'relative',
    top: 0,
    insetInlineStart: 0,
    display: 'block',
    width: token.checkboxSize,
    height: token.checkboxSize,
    direction: 'ltr',
    backgroundColor: token.colorBgContainer,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadiusSM,
    borderCollapse: 'separate',
    transition: "all ".concat(token.motionDurationSlow),
    '&:after': {
      boxSizing: 'border-box',
      position: 'absolute',
      top: '50%',
      insetInlineStart: '21.5%',
      display: 'table',
      width: token.checkboxSize / 14 * 5,
      height: token.checkboxSize / 14 * 8,
      border: "".concat(token.lineWidthBold, "px solid ").concat(token.colorWhite),
      borderTop: 0,
      borderInlineStart: 0,
      transform: 'rotate(45deg) scale(0) translate(-50%,-50%)',
      opacity: 0,
      content: '""',
      transition: "all ".concat(token.motionDurationFast, " ").concat(token.motionEaseInBack, ", opacity ").concat(token.motionDurationFast)
    }
  }), (0, _defineProperty2.default)(_extends3, '& + span', {
    paddingInlineStart: token.paddingXS,
    paddingInlineEnd: token.paddingXS
  }), _extends3))), _ref), // ================= Indeterminate =================
  (0, _defineProperty2.default)({}, checkboxCls, {
    '&-indeterminate': (0, _defineProperty2.default)({}, "".concat(checkboxCls, "-inner"), {
      '&:after': {
        top: '50%',
        insetInlineStart: '50%',
        width: token.fontSizeLG / 2,
        height: token.fontSizeLG / 2,
        backgroundColor: token.colorPrimary,
        border: 0,
        transform: 'translate(-50%, -50%) scale(1)',
        opacity: 1,
        content: '""'
      }
    })
  }), (_ref3 = {}, (0, _defineProperty2.default)(_ref3, "".concat(wrapperCls, ":hover ").concat(checkboxCls, ":after"), {
    visibility: 'visible'
  }), (0, _defineProperty2.default)(_ref3, "\n        ".concat(wrapperCls, ":not(").concat(wrapperCls, "-disabled),\n        ").concat(checkboxCls, ":not(").concat(checkboxCls, "-disabled)\n      "), (0, _defineProperty2.default)({}, "&:hover ".concat(checkboxCls, "-inner"), {
    borderColor: token.colorPrimary
  })), (0, _defineProperty2.default)(_ref3, "".concat(wrapperCls, ":not(").concat(wrapperCls, "-disabled)"), (_$concat$concat = {}, (0, _defineProperty2.default)(_$concat$concat, "&:hover ".concat(checkboxCls, "-checked:not(").concat(checkboxCls, "-disabled) ").concat(checkboxCls, "-inner"), {
    backgroundColor: token.colorPrimaryHover,
    borderColor: 'transparent'
  }), (0, _defineProperty2.default)(_$concat$concat, "&:hover ".concat(checkboxCls, "-checked:not(").concat(checkboxCls, "-disabled):after"), {
    borderColor: token.colorPrimaryHover
  }), _$concat$concat)), _ref3), (_ref4 = {}, (0, _defineProperty2.default)(_ref4, "".concat(checkboxCls, "-checked"), (_$concat2 = {}, (0, _defineProperty2.default)(_$concat2, "".concat(checkboxCls, "-inner"), {
    backgroundColor: token.colorPrimary,
    borderColor: token.colorPrimary,
    '&:after': {
      opacity: 1,
      transform: 'rotate(45deg) scale(1) translate(-50%,-50%)',
      transition: "all ".concat(token.motionDurationMid, " ").concat(token.motionEaseOutBack, " ").concat(token.motionDurationFast)
    }
  }), (0, _defineProperty2.default)(_$concat2, '&:after', {
    position: 'absolute',
    top: 0,
    insetInlineStart: 0,
    width: '100%',
    height: '100%',
    borderRadius: token.borderRadiusSM,
    visibility: 'hidden',
    border: "".concat(token.lineWidthBold, "px solid ").concat(token.colorPrimary),
    animationName: antCheckboxEffect,
    animationDuration: token.motionDurationSlow,
    animationTimingFunction: 'ease-in-out',
    animationFillMode: 'backwards',
    content: '""',
    transition: "all ".concat(token.motionDurationSlow)
  }), _$concat2)), (0, _defineProperty2.default)(_ref4, "\n        ".concat(wrapperCls, "-checked:not(").concat(wrapperCls, "-disabled),\n        ").concat(checkboxCls, "-checked:not(").concat(checkboxCls, "-disabled)\n      "), (_$concat$con2 = {}, (0, _defineProperty2.default)(_$concat$con2, "&:hover ".concat(checkboxCls, "-inner"), {
    backgroundColor: token.colorPrimaryHover,
    borderColor: 'transparent'
  }), (0, _defineProperty2.default)(_$concat$con2, "&:hover ".concat(checkboxCls, ":after"), {
    borderColor: token.colorPrimaryHover
  }), _$concat$con2)), _ref4), (_ref5 = {}, (0, _defineProperty2.default)(_ref5, "".concat(wrapperCls, "-disabled"), {
    cursor: 'not-allowed'
  }), (0, _defineProperty2.default)(_ref5, "".concat(checkboxCls, "-disabled"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, "&, ".concat(checkboxCls, "-input"), {
    cursor: 'not-allowed',
    // Disabled for native input to enable Tooltip event handler
    // ref: https://github.com/ant-design/ant-design/issues/39822#issuecomment-1365075901
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_$concat3, "".concat(checkboxCls, "-inner"), {
    background: token.colorBgContainerDisabled,
    borderColor: token.colorBorder,
    '&:after': {
      borderColor: token.colorTextDisabled
    }
  }), (0, _defineProperty2.default)(_$concat3, '&:after', {
    display: 'none'
  }), (0, _defineProperty2.default)(_$concat3, '& + span', {
    color: token.colorTextDisabled
  }), (0, _defineProperty2.default)(_$concat3, "&".concat(checkboxCls, "-indeterminate ").concat(checkboxCls, "-inner::after"), {
    background: token.colorTextDisabled
  }), _$concat3)), _ref5)];
};
// ============================== Export ==============================
exports.genCheckboxStyle = genCheckboxStyle;
function getStyle(prefixCls, token) {
  var checkboxToken = (0, _internal.mergeToken)(token, {
    checkboxCls: ".".concat(prefixCls),
    checkboxSize: token.controlInteractiveSize
  });
  return [genCheckboxStyle(checkboxToken)];
}
var _default = (0, _internal.genComponentStyleHook)('Checkbox', function (token, _ref6) {
  var prefixCls = _ref6.prefixCls;
  return [getStyle(prefixCls, token)];
});
exports.default = _default;