"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var genBaseStyle = function genBaseStyle(token) {
  var _author, _$concat2, _componentCls;
  var componentCls = token.componentCls,
    commentBg = token.commentBg,
    commentPaddingBase = token.commentPaddingBase,
    commentNestIndent = token.commentNestIndent,
    commentFontSizeBase = token.commentFontSizeBase,
    commentFontSizeSm = token.commentFontSizeSm,
    commentAuthorNameColor = token.commentAuthorNameColor,
    commentAuthorTimeColor = token.commentAuthorTimeColor,
    commentActionColor = token.commentActionColor,
    commentActionHoverColor = token.commentActionHoverColor,
    commentActionsMarginBottom = token.commentActionsMarginBottom,
    commentActionsMarginTop = token.commentActionsMarginTop,
    commentContentDetailPMarginBottom = token.commentContentDetailPMarginBottom;
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls = {
    position: 'relative',
    backgroundColor: commentBg
  }, (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-inner"), {
    display: 'flex',
    padding: commentPaddingBase
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-avatar"), (0, _defineProperty2.default)({
    position: 'relative',
    flexShrink: 0,
    marginRight: token.marginSM,
    cursor: 'pointer'
  }, "img", {
    width: '32px',
    height: '32px',
    borderRadius: '50%'
  })), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-content"), (_$concat2 = {
    position: 'relative',
    flex: "1 1 auto",
    minWidth: "1px",
    fontSize: commentFontSizeBase,
    wordWrap: 'break-word'
  }, (0, _defineProperty2.default)(_$concat2, "&-author", (_author = {
    display: 'flex',
    flexWrap: 'wrap',
    justifyContent: 'flex-start',
    marginBottom: token.marginXXS,
    fontSize: commentFontSizeBase
  }, (0, _defineProperty2.default)(_author, "& > a,& > span", {
    paddingRight: token.paddingXS,
    fontSize: commentFontSizeSm,
    lineHeight: "18px"
  }), (0, _defineProperty2.default)(_author, "&-name", (0, _defineProperty2.default)({
    color: commentAuthorNameColor,
    fontSize: commentFontSizeBase,
    transition: "color ".concat(token.motionDurationSlow)
  }, "> *", (0, _defineProperty2.default)({
    color: commentAuthorNameColor
  }, "&:hover", {
    color: commentAuthorNameColor
  }))), (0, _defineProperty2.default)(_author, "&-time", {
    color: commentAuthorTimeColor,
    whiteSpace: 'nowrap',
    cursor: 'auto'
  }), _author)), (0, _defineProperty2.default)(_$concat2, "&-detail p", {
    marginBottom: commentContentDetailPMarginBottom,
    whiteSpace: 'pre-wrap'
  }), _$concat2)), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-actions"), (0, _defineProperty2.default)({
    marginTop: commentActionsMarginTop,
    marginBottom: commentActionsMarginBottom,
    paddingLeft: 0
  }, "> li", (0, _defineProperty2.default)({
    display: 'inline-block',
    color: commentActionColor
  }, "> span", (0, _defineProperty2.default)({
    marginRight: '10px',
    color: commentActionColor,
    fontSize: commentFontSizeSm,
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationSlow),
    userSelect: 'none'
  }, "&:hover", {
    color: commentActionHoverColor
  })))), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-nested"), {
    marginLeft: commentNestIndent
  }), (0, _defineProperty2.default)(_componentCls, '&-rtl', {
    direction: 'rtl'
  }), _componentCls));
};
var _default = (0, _internal.genComponentStyleHook)('Comment', function (token) {
  var commentToken = (0, _internal.mergeToken)(token, {
    commentBg: 'inherit',
    commentPaddingBase: "".concat(token.paddingMD, "px 0"),
    commentNestIndent: "44px",
    commentFontSizeBase: token.fontSize,
    commentFontSizeSm: token.fontSizeSM,
    commentAuthorNameColor: token.colorTextTertiary,
    commentAuthorTimeColor: token.colorTextPlaceholder,
    commentActionColor: token.colorTextTertiary,
    commentActionHoverColor: token.colorTextSecondary,
    commentActionsMarginBottom: 'inherit',
    commentActionsMarginTop: token.marginSM,
    commentContentDetailPMarginBottom: 'inherit'
  });
  return [genBaseStyle(commentToken)];
});
exports.default = _default;