"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProvideGlobalForm = exports.useInjectGlobalForm = exports.useConfigContextProvider = exports.useConfigContextInject = exports.defaultIconPrefixCls = exports.defaultConfigProvider = exports.configProviderProps = exports.configProviderKey = exports.GlobalFormContextKey = exports.GlobalConfigContextKey = void 0;
var _vue = require("vue");
var _type = require("../_util/type");
var defaultIconPrefixCls = 'anticon';
exports.defaultIconPrefixCls = defaultIconPrefixCls;
var GlobalFormContextKey = Symbol('GlobalFormContextKey');
exports.GlobalFormContextKey = GlobalFormContextKey;
var useProvideGlobalForm = function useProvideGlobalForm(state) {
  (0, _vue.provide)(GlobalFormContextKey, state);
};
exports.useProvideGlobalForm = useProvideGlobalForm;
var useInjectGlobalForm = function useInjectGlobalForm() {
  return (0, _vue.inject)(GlobalFormContextKey, {
    validateMessages: (0, _vue.computed)(function () {
      return undefined;
    })
  });
};
exports.useInjectGlobalForm = useInjectGlobalForm;
var GlobalConfigContextKey = Symbol('GlobalConfigContextKey');
exports.GlobalConfigContextKey = GlobalConfigContextKey;
var configProviderProps = function configProviderProps() {
  return {
    iconPrefixCls: String,
    getTargetContainer: {
      type: Function
    },
    getPopupContainer: {
      type: Function
    },
    prefixCls: String,
    getPrefixCls: {
      type: Function
    },
    renderEmpty: {
      type: Function
    },
    transformCellText: {
      type: Function
    },
    csp: (0, _type.objectType)(),
    input: (0, _type.objectType)(),
    autoInsertSpaceInButton: {
      type: Boolean,
      default: undefined
    },
    locale: (0, _type.objectType)(),
    pageHeader: (0, _type.objectType)(),
    componentSize: {
      type: String
    },
    componentDisabled: {
      type: Boolean,
      default: undefined
    },
    direction: {
      type: String
    },
    space: (0, _type.objectType)(),
    virtual: {
      type: Boolean,
      default: undefined
    },
    dropdownMatchSelectWidth: {
      type: [Number, Boolean],
      default: true
    },
    form: (0, _type.objectType)(),
    pagination: (0, _type.objectType)(),
    theme: (0, _type.objectType)(),
    select: (0, _type.objectType)()
  };
};
exports.configProviderProps = configProviderProps;
var configProviderKey = Symbol('configProvider');
exports.configProviderKey = configProviderKey;
var defaultConfigProvider = {
  getPrefixCls: function getPrefixCls(suffixCls, customizePrefixCls) {
    if (customizePrefixCls) return customizePrefixCls;
    return suffixCls ? "ant-".concat(suffixCls) : 'ant';
  },
  iconPrefixCls: (0, _vue.computed)(function () {
    return defaultIconPrefixCls;
  }),
  getPopupContainer: (0, _vue.computed)(function () {
    return function () {
      return document.body;
    };
  })
};
exports.defaultConfigProvider = defaultConfigProvider;
var useConfigContextInject = function useConfigContextInject() {
  return (0, _vue.inject)(configProviderKey, defaultConfigProvider);
};
exports.useConfigContextInject = useConfigContextInject;
var useConfigContextProvider = function useConfigContextProvider(props) {
  return (0, _vue.provide)(configProviderKey, props);
};
exports.useConfigContextProvider = useConfigContextProvider;