"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _vue = require("vue");
var _context = require("../context");
var _DisabledContext = require("../DisabledContext");
var _renderEmpty = require("../renderEmpty");
var _SizeContext = require("../SizeContext");
var _default = function _default(name, props) {
  var sizeContext = (0, _SizeContext.useInjectSize)();
  var disabledContext = (0, _DisabledContext.useInjectDisabled)();
  var configProvider = (0, _vue.inject)(_context.configProviderKey, (0, _extends2.default)((0, _extends2.default)({}, _context.defaultConfigProvider), {
    renderEmpty: function renderEmpty(name) {
      return (0, _vue.h)(_renderEmpty.DefaultRenderEmpty, {
        componentName: name
      });
    }
  }));
  var prefixCls = (0, _vue.computed)(function () {
    return configProvider.getPrefixCls(name, props.prefixCls);
  });
  var direction = (0, _vue.computed)(function () {
    var _a, _b;
    return (_a = props.direction) !== null && _a !== void 0 ? _a : (_b = configProvider.direction) === null || _b === void 0 ? void 0 : _b.value;
  });
  var iconPrefixCls = (0, _vue.computed)(function () {
    var _a;
    return (_a = props.iconPrefixCls) !== null && _a !== void 0 ? _a : configProvider.iconPrefixCls.value;
  });
  var rootPrefixCls = (0, _vue.computed)(function () {
    return configProvider.getPrefixCls();
  });
  var autoInsertSpaceInButton = (0, _vue.computed)(function () {
    var _a;
    return (_a = configProvider.autoInsertSpaceInButton) === null || _a === void 0 ? void 0 : _a.value;
  });
  var renderEmpty = configProvider.renderEmpty;
  var space = configProvider.space;
  var pageHeader = configProvider.pageHeader;
  var form = configProvider.form;
  var getTargetContainer = configProvider.getTargetContainer;
  var getPopupContainer = configProvider.getPopupContainer;
  var dropdownMatchSelectWidth = (0, _vue.computed)(function () {
    var _a, _b;
    return (_a = props.dropdownMatchSelectWidth) !== null && _a !== void 0 ? _a : (_b = configProvider.dropdownMatchSelectWidth) === null || _b === void 0 ? void 0 : _b.value;
  });
  var virtual = (0, _vue.computed)(function () {
    var _a;
    return (props.virtual === undefined ? ((_a = configProvider.virtual) === null || _a === void 0 ? void 0 : _a.value) !== false : props.virtual !== false) && dropdownMatchSelectWidth.value !== false;
  });
  var size = (0, _vue.computed)(function () {
    return props.size || sizeContext.value;
  });
  var autocomplete = (0, _vue.computed)(function () {
    var _a, _b, _c;
    return (_a = props.autocomplete) !== null && _a !== void 0 ? _a : (_c = (_b = configProvider.input) === null || _b === void 0 ? void 0 : _b.value) === null || _c === void 0 ? void 0 : _c.autocomplete;
  });
  var disabled = (0, _vue.computed)(function () {
    var _a;
    return (_a = props.disabled) !== null && _a !== void 0 ? _a : disabledContext.value;
  });
  var csp = (0, _vue.computed)(function () {
    var _a;
    return (_a = props.csp) !== null && _a !== void 0 ? _a : configProvider.csp;
  });
  return {
    configProvider: configProvider,
    prefixCls: prefixCls,
    direction: direction,
    size: size,
    getTargetContainer: getTargetContainer,
    getPopupContainer: getPopupContainer,
    space: space,
    pageHeader: pageHeader,
    form: form,
    autoInsertSpaceInButton: autoInsertSpaceInButton,
    renderEmpty: renderEmpty,
    virtual: virtual,
    dropdownMatchSelectWidth: dropdownMatchSelectWidth,
    rootPrefixCls: rootPrefixCls,
    getPrefixCls: configProvider.getPrefixCls,
    autocomplete: autocomplete,
    csp: csp,
    iconPrefixCls: iconPrefixCls,
    disabled: disabled,
    select: configProvider.select
  };
};
exports.default = _default;