"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
var genBorderedStyle = function genBorderedStyle(token) {
  var _$concat3;
  var componentCls = token.componentCls,
    descriptionsSmallPadding = token.descriptionsSmallPadding,
    descriptionsDefaultPadding = token.descriptionsDefaultPadding,
    descriptionsMiddlePadding = token.descriptionsMiddlePadding,
    descriptionsBg = token.descriptionsBg;
  return (0, _defineProperty2.default)({}, "&".concat(componentCls, "-bordered"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-view"), {
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    '> table': {
      tableLayout: 'auto',
      borderCollapse: 'collapse'
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item-label, ").concat(componentCls, "-item-content"), {
    padding: descriptionsDefaultPadding,
    borderInlineEnd: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    '&:last-child': {
      borderInlineEnd: 'none'
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item-label"), {
    backgroundColor: descriptionsBg,
    '&::after': {
      display: 'none'
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-row"), {
    borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    '&:last-child': {
      borderBottom: 'none'
    }
  }), (0, _defineProperty2.default)(_$concat3, "&".concat(componentCls, "-middle"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-label, ").concat(componentCls, "-item-content"), {
    padding: descriptionsMiddlePadding
  })), (0, _defineProperty2.default)(_$concat3, "&".concat(componentCls, "-small"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-label, ").concat(componentCls, "-item-content"), {
    padding: descriptionsSmallPadding
  })), _$concat3));
};
var genDescriptionStyles = function genDescriptionStyles(token) {
  var _container, _extends2;
  var componentCls = token.componentCls,
    descriptionsExtraColor = token.descriptionsExtraColor,
    descriptionItemPaddingBottom = token.descriptionItemPaddingBottom,
    descriptionsItemLabelColonMarginRight = token.descriptionsItemLabelColonMarginRight,
    descriptionsItemLabelColonMarginLeft = token.descriptionsItemLabelColonMarginLeft,
    descriptionsTitleMarginBottom = token.descriptionsTitleMarginBottom;
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends3.default)((0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), genBorderedStyle(token)), (_extends2 = {}, (0, _defineProperty2.default)(_extends2, "&-rtl", {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-header"), {
    display: 'flex',
    alignItems: 'center',
    marginBottom: descriptionsTitleMarginBottom
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-title"), (0, _extends3.default)((0, _extends3.default)({}, _style.textEllipsis), {
    flex: 'auto',
    color: token.colorText,
    fontWeight: token.fontWeightStrong,
    fontSize: token.fontSizeLG,
    lineHeight: token.lineHeightLG
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-extra"), {
    marginInlineStart: 'auto',
    color: descriptionsExtraColor,
    fontSize: token.fontSize
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-view"), {
    width: '100%',
    borderRadius: token.borderRadiusLG,
    table: {
      width: '100%',
      tableLayout: 'fixed'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-row"), {
    '> th, > td': {
      paddingBottom: descriptionItemPaddingBottom
    },
    '&:last-child': {
      borderBottom: 'none'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item-label"), (0, _defineProperty2.default)({
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    textAlign: "start",
    '&::after': {
      content: '":"',
      position: 'relative',
      top: -0.5,
      marginInline: "".concat(descriptionsItemLabelColonMarginLeft, "px ").concat(descriptionsItemLabelColonMarginRight, "px")
    }
  }, "&".concat(componentCls, "-item-no-colon::after"), {
    content: '""'
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item-no-label"), {
    '&::after': {
      margin: 0,
      content: '""'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item-content"), {
    display: 'table-cell',
    flex: 1,
    color: token.colorText,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    wordBreak: 'break-word',
    overflowWrap: 'break-word'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item"), {
    paddingBottom: 0,
    verticalAlign: 'top',
    '&-container': (_container = {
      display: 'flex'
    }, (0, _defineProperty2.default)(_container, "".concat(componentCls, "-item-label"), {
      display: 'inline-flex',
      alignItems: 'baseline'
    }), (0, _defineProperty2.default)(_container, "".concat(componentCls, "-item-content"), {
      display: 'inline-flex',
      alignItems: 'baseline'
    }), _container)
  }), (0, _defineProperty2.default)(_extends2, '&-middle', (0, _defineProperty2.default)({}, "".concat(componentCls, "-row"), {
    '> th, > td': {
      paddingBottom: token.paddingSM
    }
  })), (0, _defineProperty2.default)(_extends2, '&-small', (0, _defineProperty2.default)({}, "".concat(componentCls, "-row"), {
    '> th, > td': {
      paddingBottom: token.paddingXS
    }
  })), _extends2)));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Descriptions', function (token) {
  var descriptionsBg = token.colorFillAlter;
  var descriptionsTitleMarginBottom = token.fontSizeSM * token.lineHeightSM;
  var descriptionsExtraColor = token.colorText;
  var descriptionsSmallPadding = "".concat(token.paddingXS, "px ").concat(token.padding, "px");
  var descriptionsDefaultPadding = "".concat(token.padding, "px ").concat(token.paddingLG, "px");
  var descriptionsMiddlePadding = "".concat(token.paddingSM, "px ").concat(token.paddingLG, "px");
  var descriptionItemPaddingBottom = token.padding;
  var descriptionsItemLabelColonMarginRight = token.marginXS;
  var descriptionsItemLabelColonMarginLeft = token.marginXXS / 2;
  var descriptionToken = (0, _internal.mergeToken)(token, {
    descriptionsBg: descriptionsBg,
    descriptionsTitleMarginBottom: descriptionsTitleMarginBottom,
    descriptionsExtraColor: descriptionsExtraColor,
    descriptionItemPaddingBottom: descriptionItemPaddingBottom,
    descriptionsSmallPadding: descriptionsSmallPadding,
    descriptionsDefaultPadding: descriptionsDefaultPadding,
    descriptionsMiddlePadding: descriptionsMiddlePadding,
    descriptionsItemLabelColonMarginRight: descriptionsItemLabelColonMarginRight,
    descriptionsItemLabelColonMarginLeft: descriptionsItemLabelColonMarginLeft
  });
  return [genDescriptionStyles(descriptionToken)];
});
exports.default = _default;