"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.drawerProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _propsUtil = require("../_util/props-util");
var _classNames = _interopRequireDefault(require("../_util/classNames"));
var _vcDrawer = _interopRequireDefault(require("../vc-drawer"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _type = require("../_util/type");
var _omit = _interopRequireDefault(require("../_util/omit"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _style = _interopRequireDefault(require("./style"));
var _Compact = require("../space/Compact");
var _isNumeric = _interopRequireDefault(require("../_util/isNumeric"));
var _transition = require("../_util/transition");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var PlacementTypes = ['top', 'right', 'bottom', 'left'];
var SizeTypes = ['default', 'large'];
var defaultPushState = {
  distance: 180
};
var drawerProps = function drawerProps() {
  return {
    autofocus: {
      type: Boolean,
      default: undefined
    },
    closable: {
      type: Boolean,
      default: undefined
    },
    closeIcon: _vueTypes.default.any,
    destroyOnClose: {
      type: Boolean,
      default: undefined
    },
    forceRender: {
      type: Boolean,
      default: undefined
    },
    getContainer: {
      type: [String, Function, Boolean, Object],
      default: undefined
    },
    maskClosable: {
      type: Boolean,
      default: undefined
    },
    mask: {
      type: Boolean,
      default: undefined
    },
    maskStyle: (0, _type.objectType)(),
    rootClassName: String,
    rootStyle: (0, _type.objectType)(),
    size: {
      type: String
    },
    drawerStyle: (0, _type.objectType)(),
    headerStyle: (0, _type.objectType)(),
    bodyStyle: (0, _type.objectType)(),
    contentWrapperStyle: {
      type: Object,
      default: undefined
    },
    title: _vueTypes.default.any,
    /** @deprecated Please use `open` instead */
    visible: {
      type: Boolean,
      default: undefined
    },
    open: {
      type: Boolean,
      default: undefined
    },
    width: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number]),
    height: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number]),
    zIndex: Number,
    prefixCls: String,
    push: _vueTypes.default.oneOfType([_vueTypes.default.looseBool, {
      type: Object
    }]),
    placement: _vueTypes.default.oneOf(PlacementTypes),
    keyboard: {
      type: Boolean,
      default: undefined
    },
    extra: _vueTypes.default.any,
    footer: _vueTypes.default.any,
    footerStyle: (0, _type.objectType)(),
    level: _vueTypes.default.any,
    levelMove: {
      type: [Number, Array, Function]
    },
    handle: _vueTypes.default.any,
    /** @deprecated Use `@afterVisibleChange` instead */
    afterVisibleChange: Function,
    /** @deprecated Please use `@afterOpenChange` instead */
    onAfterVisibleChange: Function,
    onAfterOpenChange: Function,
    /** @deprecated Please use `onUpdate:open` instead */
    'onUpdate:visible': Function,
    'onUpdate:open': Function,
    onClose: Function
  };
};
exports.drawerProps = drawerProps;
var Drawer = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ADrawer',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(drawerProps(), {
    closable: true,
    placement: 'right',
    maskClosable: true,
    mask: true,
    level: null,
    keyboard: true,
    push: defaultPushState
  }),
  slots: ['closeIcon', 'title', 'extra', 'footer', 'handle'],
  // emits: ['update:visible', 'close', 'afterVisibleChange'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var sPush = (0, _vue.shallowRef)(false);
    var destroyClose = (0, _vue.shallowRef)(false);
    var vcDrawer = (0, _vue.shallowRef)(null);
    var load = (0, _vue.shallowRef)(false);
    var visible = (0, _vue.shallowRef)(false);
    var mergedOpen = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.open) !== null && _a !== void 0 ? _a : props.visible;
    });
    (0, _vue.watch)(mergedOpen, function () {
      if (mergedOpen.value) {
        load.value = true;
      } else {
        visible.value = false;
      }
    }, {
      immediate: true
    });
    (0, _vue.watch)([mergedOpen, load], function () {
      if (mergedOpen.value && load.value) {
        visible.value = true;
      }
    }, {
      immediate: true
    });
    var parentDrawerOpts = (0, _vue.inject)('parentDrawerOpts', null);
    var _useConfigInject = (0, _useConfigInject2.default)('drawer', props),
      prefixCls = _useConfigInject.prefixCls,
      getPopupContainer = _useConfigInject.getPopupContainer,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getContainer = (0, _vue.computed)(function () {
      return (
        // 有可能为 false，所以不能直接判断
        props.getContainer === undefined && (getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value) ? function () {
          return getPopupContainer.value(document.body);
        } : props.getContainer
      );
    });
    (0, _devWarning.default)(!props.afterVisibleChange, 'Drawer', '`afterVisibleChange` prop is deprecated, please use `@afterVisibleChange` event instead');
    // ========================== Warning ===========================
    if (process.env.NODE_ENV !== 'production') {
      [['visible', 'open'], ['onUpdate:visible', 'onUpdate:open'], ['onAfterVisibleChange', 'onAfterOpenChange']].forEach(function (_ref2) {
        var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        (0, _devWarning.default)(!props[deprecatedName], 'Drawer', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var setPush = function setPush() {
      sPush.value = true;
    };
    var setPull = function setPull() {
      sPush.value = false;
      (0, _vue.nextTick)(function () {
        domFocus();
      });
    };
    (0, _vue.provide)('parentDrawerOpts', {
      setPush: setPush,
      setPull: setPull
    });
    (0, _vue.onMounted)(function () {
      if (mergedOpen.value && parentDrawerOpts) {
        parentDrawerOpts.setPush();
      }
    });
    (0, _vue.onUnmounted)(function () {
      if (parentDrawerOpts) {
        parentDrawerOpts.setPull();
      }
    });
    (0, _vue.watch)(visible, function () {
      if (parentDrawerOpts) {
        if (visible.value) {
          parentDrawerOpts.setPush();
        } else {
          parentDrawerOpts.setPull();
        }
      }
    }, {
      flush: 'post'
    });
    var domFocus = function domFocus() {
      var _a, _b;
      (_b = (_a = vcDrawer.value) === null || _a === void 0 ? void 0 : _a.domFocus) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var close = function close(e) {
      emit('update:visible', false);
      emit('update:open', false);
      emit('close', e);
    };
    var afterVisibleChange = function afterVisibleChange(open) {
      var _a;
      if (!open) {
        if (destroyClose.value === false) {
          // set true only once
          destroyClose.value = true;
        }
        if (props.destroyOnClose) {
          load.value = false;
        }
      }
      (_a = props.afterVisibleChange) === null || _a === void 0 ? void 0 : _a.call(props, open);
      emit('afterVisibleChange', open);
      emit('afterOpenChange', open);
    };
    var pushTransform = (0, _vue.computed)(function () {
      var push = props.push,
        placement = props.placement;
      var distance;
      if (typeof push === 'boolean') {
        distance = push ? defaultPushState.distance : 0;
      } else {
        distance = push.distance;
      }
      distance = parseFloat(String(distance || 0));
      if (placement === 'left' || placement === 'right') {
        return "translateX(".concat(placement === 'left' ? distance : -distance, "px)");
      }
      if (placement === 'top' || placement === 'bottom') {
        return "translateY(".concat(placement === 'top' ? distance : -distance, "px)");
      }
      return null;
    });
    // ============================ Size ============================
    var mergedWidth = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.width) !== null && _a !== void 0 ? _a : props.size === 'large' ? 736 : 378;
    });
    var mergedHeight = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.height) !== null && _a !== void 0 ? _a : props.size === 'large' ? 736 : 378;
    });
    var offsetStyle = (0, _vue.computed)(function () {
      // https://github.com/ant-design/ant-design/issues/24287
      var mask = props.mask,
        placement = props.placement;
      if (!visible.value && !mask) {
        return {};
      }
      var val = {};
      if (placement === 'left' || placement === 'right') {
        val.width = (0, _isNumeric.default)(mergedWidth.value) ? "".concat(mergedWidth.value, "px") : mergedWidth.value;
      } else {
        val.height = (0, _isNumeric.default)(mergedHeight.value) ? "".concat(mergedHeight.value, "px") : mergedHeight.value;
      }
      return val;
    });
    var wrapperStyle = (0, _vue.computed)(function () {
      var zIndex = props.zIndex;
      var val = offsetStyle.value;
      return [{
        zIndex: zIndex,
        transform: sPush.value ? pushTransform.value : undefined
      }, val];
    });
    var renderHeader = function renderHeader(prefixCls) {
      var closable = props.closable,
        headerStyle = props.headerStyle;
      var extra = (0, _propsUtil.getPropsSlot)(slots, props, 'extra');
      var title = (0, _propsUtil.getPropsSlot)(slots, props, 'title');
      if (!title && !closable) {
        return null;
      }
      return (0, _vue.createVNode)("div", {
        "class": (0, _classNames.default)("".concat(prefixCls, "-header"), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-header-close-only"), closable && !title && !extra)),
        "style": headerStyle
      }, [(0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-header-title")
      }, [renderCloseIcon(prefixCls), title && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-title")
      }, [title])]), extra && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-extra")
      }, [extra])]);
    };
    var renderCloseIcon = function renderCloseIcon(prefixCls) {
      var _a;
      var closable = props.closable;
      var $closeIcon = slots.closeIcon ? (_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots) : props.closeIcon;
      return closable && (0, _vue.createVNode)("button", {
        "key": "closer",
        "onClick": close,
        "aria-label": "Close",
        "class": "".concat(prefixCls, "-close")
      }, [$closeIcon === undefined ? (0, _vue.createVNode)(_CloseOutlined.default, null, null) : $closeIcon]);
    };
    var renderBody = function renderBody(prefixCls) {
      var _a;
      if (destroyClose.value && !props.forceRender && !load.value) {
        return null;
      }
      var bodyStyle = props.bodyStyle,
        drawerStyle = props.drawerStyle;
      return (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-wrapper-body"),
        "style": drawerStyle
      }, [renderHeader(prefixCls), (0, _vue.createVNode)("div", {
        "key": "body",
        "class": "".concat(prefixCls, "-body"),
        "style": bodyStyle
      }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]), renderFooter(prefixCls)]);
    };
    var renderFooter = function renderFooter(prefixCls) {
      var footer = (0, _propsUtil.getPropsSlot)(slots, props, 'footer');
      if (!footer) {
        return null;
      }
      var footerClassName = "".concat(prefixCls, "-footer");
      return (0, _vue.createVNode)("div", {
        "class": footerClassName,
        "style": props.footerStyle
      }, [footer]);
    };
    var drawerClassName = (0, _vue.computed)(function () {
      return (0, _classNames.default)((0, _defineProperty2.default)({
        'no-mask': !props.mask
      }, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), props.rootClassName, hashId.value);
    });
    // =========================== Motion ===========================
    var maskMotion = (0, _vue.computed)(function () {
      return (0, _transition.getTransitionProps)((0, _transition.getTransitionName)(prefixCls.value, 'mask-motion'));
    });
    var panelMotion = function panelMotion(motionPlacement) {
      return (0, _transition.getTransitionProps)((0, _transition.getTransitionName)(prefixCls.value, "panel-motion-".concat(motionPlacement)));
    };
    return function () {
      var width = props.width,
        height = props.height,
        placement = props.placement,
        mask = props.mask,
        forceRender = props.forceRender,
        rest = __rest(props, ["width", "height", "placement", "mask", "forceRender"]);
      var vcDrawerProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, attrs), (0, _omit.default)(rest, ['size', 'closeIcon', 'closable', 'destroyOnClose', 'drawerStyle', 'headerStyle', 'bodyStyle', 'title', 'push', 'onAfterVisibleChange', 'onClose', 'onUpdate:visible', 'onUpdate:open', 'visible'])), {
        forceRender: forceRender,
        onClose: close,
        afterVisibleChange: afterVisibleChange,
        handler: false,
        prefixCls: prefixCls.value,
        open: visible.value,
        showMask: mask,
        placement: placement,
        ref: vcDrawer
      });
      return wrapSSR((0, _vue.createVNode)(_Compact.NoCompactStyle, null, {
        default: function _default() {
          return [(0, _vue.createVNode)(_vcDrawer.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, vcDrawerProps), {}, {
            "maskMotion": maskMotion.value,
            "motion": panelMotion,
            "width": mergedWidth.value,
            "height": mergedHeight.value,
            "getContainer": getContainer.value,
            "rootClassName": drawerClassName.value,
            "rootStyle": props.rootStyle,
            "contentWrapperStyle": wrapperStyle.value
          }), {
            handler: props.handle ? function () {
              return props.handle;
            } : slots.handle,
            default: function _default() {
              return renderBody(prefixCls.value);
            }
          })];
        }
      }));
    };
  }
});
var _default2 = (0, _type.withInstall)(Drawer);
exports.default = _default2;