"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _vcDropdown = _interopRequireDefault(require("../vc-dropdown"));
var _dropdownButton = _interopRequireDefault(require("./dropdown-button"));
var _vnode = require("../_util/vnode");
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _propsUtil = require("../_util/props-util");
var _props = require("./props");
var _RightOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/RightOutlined"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _omit = _interopRequireDefault(require("../_util/omit"));
var _placements = _interopRequireDefault(require("../_util/placements"));
var _warning = _interopRequireDefault(require("../_util/warning"));
var _style = _interopRequireDefault(require("./style"));
var _OverrideContext = require("../menu/src/OverrideContext");
var Dropdown = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ADropdown',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)((0, _props.dropdownProps)(), {
    mouseEnterDelay: 0.15,
    mouseLeaveDelay: 0.1,
    placement: 'bottomLeft',
    trigger: 'hover'
  }),
  // emits: ['visibleChange', 'update:visible'],
  slots: ['overlay'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit;
    var _useConfigInject = (0, _useConfigInject2.default)('dropdown', props),
      prefixCls = _useConfigInject.prefixCls,
      rootPrefixCls = _useConfigInject.rootPrefixCls,
      direction = _useConfigInject.direction,
      getPopupContainer = _useConfigInject.getPopupContainer;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    // Warning for deprecated usage
    if (process.env.NODE_ENV !== 'production') {
      [['visible', 'open'], ['onVisibleChange', 'onOpenChange'], ['onUpdate:visible', 'onUpdate:open']].forEach(function (_ref2) {
        var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        (0, _warning.default)(props[deprecatedName] === undefined, 'Dropdown', "`".concat(deprecatedName, "` is deprecated which will be removed in next major version, please use `").concat(newName, "` instead."));
      });
    }
    var transitionName = (0, _vue.computed)(function () {
      var _props$placement = props.placement,
        placement = _props$placement === void 0 ? '' : _props$placement,
        transitionName = props.transitionName;
      if (transitionName !== undefined) {
        return transitionName;
      }
      if (placement.includes('top')) {
        return "".concat(rootPrefixCls.value, "-slide-down");
      }
      return "".concat(rootPrefixCls.value, "-slide-up");
    });
    (0, _OverrideContext.useProvideOverride)({
      prefixCls: (0, _vue.computed)(function () {
        return "".concat(prefixCls.value, "-menu");
      }),
      expandIcon: (0, _vue.computed)(function () {
        return (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls.value, "-menu-submenu-arrow")
        }, [(0, _vue.createVNode)(_RightOutlined.default, {
          "class": "".concat(prefixCls.value, "-menu-submenu-arrow-icon")
        }, null)]);
      }),
      mode: (0, _vue.computed)(function () {
        return 'vertical';
      }),
      selectable: (0, _vue.computed)(function () {
        return false;
      }),
      onClick: function onClick() {},
      validator: function validator(_ref4) {
        var mode = _ref4.mode;
        // Warning if use other mode
        (0, _warning.default)(!mode || mode === 'vertical', 'Dropdown', "mode=\"".concat(mode, "\" is not supported for Dropdown's Menu."));
      }
    });
    var renderOverlay = function renderOverlay() {
      var _a, _b, _c;
      // rc-dropdown already can process the function of overlay, but we have check logic here.
      // So we need render the element to check and pass back to rc-dropdown.
      var overlay = props.overlay || ((_a = slots.overlay) === null || _a === void 0 ? void 0 : _a.call(slots));
      var overlayNode = Array.isArray(overlay) ? overlay[0] : overlay;
      if (!overlayNode) return null;
      var overlayProps = overlayNode.props || {};
      // Warning if use other mode
      (0, _devWarning.default)(!overlayProps.mode || overlayProps.mode === 'vertical', 'Dropdown', "mode=\"".concat(overlayProps.mode, "\" is not supported for Dropdown's Menu."));
      // menu cannot be selectable in dropdown defaultly
      var _overlayProps$selecta = overlayProps.selectable,
        selectable = _overlayProps$selecta === void 0 ? false : _overlayProps$selecta,
        _overlayProps$expandI = overlayProps.expandIcon,
        expandIcon = _overlayProps$expandI === void 0 ? (_c = (_b = overlayNode.children) === null || _b === void 0 ? void 0 : _b.expandIcon) === null || _c === void 0 ? void 0 : _c.call(_b) : _overlayProps$expandI;
      var overlayNodeExpandIcon = typeof expandIcon !== 'undefined' && (0, _propsUtil.isValidElement)(expandIcon) ? expandIcon : (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls.value, "-menu-submenu-arrow")
      }, [(0, _vue.createVNode)(_RightOutlined.default, {
        "class": "".concat(prefixCls.value, "-menu-submenu-arrow-icon")
      }, null)]);
      var fixedModeOverlay = (0, _propsUtil.isValidElement)(overlayNode) ? (0, _vnode.cloneElement)(overlayNode, {
        mode: 'vertical',
        selectable: selectable,
        expandIcon: function expandIcon() {
          return overlayNodeExpandIcon;
        }
      }) : overlayNode;
      return fixedModeOverlay;
    };
    var placement = (0, _vue.computed)(function () {
      var placement = props.placement;
      if (!placement) {
        return direction.value === 'rtl' ? 'bottomRight' : 'bottomLeft';
      }
      if (placement.includes('Center')) {
        var newPlacement = placement.slice(0, placement.indexOf('Center'));
        (0, _devWarning.default)(!placement.includes('Center'), 'Dropdown', "You are using '".concat(placement, "' placement in Dropdown, which is deprecated. Try to use '").concat(newPlacement, "' instead."));
        return newPlacement;
      }
      return placement;
    });
    var mergedVisible = (0, _vue.computed)(function () {
      return typeof props.visible === 'boolean' ? props.visible : props.open;
    });
    var handleVisibleChange = function handleVisibleChange(val) {
      emit('update:visible', val);
      emit('visibleChange', val);
      emit('update:open', val);
      emit('openChange', val);
    };
    return function () {
      var _a, _b;
      var arrow = props.arrow,
        trigger = props.trigger,
        disabled = props.disabled,
        overlayClassName = props.overlayClassName;
      var child = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)[0];
      var dropdownTrigger = (0, _vnode.cloneElement)(child, (0, _extends2.default)({
        class: (0, _classNames3.default)((_b = child === null || child === void 0 ? void 0 : child.props) === null || _b === void 0 ? void 0 : _b.class, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), "".concat(prefixCls.value, "-trigger"))
      }, disabled ? {
        disabled: disabled
      } : {}));
      var overlayClassNameCustomized = (0, _classNames3.default)(overlayClassName, hashId.value, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'));
      var triggerActions = disabled ? [] : trigger;
      var alignPoint;
      if (triggerActions && triggerActions.includes('contextmenu')) {
        alignPoint = true;
      }
      var builtinPlacements = (0, _placements.default)({
        arrowPointAtCenter: (0, _typeof2.default)(arrow) === 'object' && arrow.pointAtCenter,
        autoAdjustOverflow: true
      });
      var dropdownProps = (0, _omit.default)((0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, props), attrs), {
        visible: mergedVisible.value,
        builtinPlacements: builtinPlacements,
        overlayClassName: overlayClassNameCustomized,
        arrow: !!arrow,
        alignPoint: alignPoint,
        prefixCls: prefixCls.value,
        getPopupContainer: getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        transitionName: transitionName.value,
        trigger: triggerActions,
        onVisibleChange: handleVisibleChange,
        placement: placement.value
      }), ['overlay', 'onUpdate:visible']);
      return wrapSSR((0, _vue.createVNode)(_vcDropdown.default, dropdownProps, {
        default: function _default() {
          return [dropdownTrigger];
        },
        overlay: renderOverlay
      }));
    };
  }
});
Dropdown.Button = _dropdownButton.default;
var _default2 = Dropdown;
exports.default = _default2;