"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends6 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _placementArrow = require("../../style/placementArrow");
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _button = _interopRequireDefault(require("./button"));
var _status = _interopRequireDefault(require("./status"));
var _style = require("../../style");
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _extends2, _extends5, _ref2;
  var componentCls = token.componentCls,
    menuCls = token.menuCls,
    zIndexPopup = token.zIndexPopup,
    dropdownArrowDistance = token.dropdownArrowDistance,
    dropdownArrowOffset = token.dropdownArrowOffset,
    sizePopupArrow = token.sizePopupArrow,
    antCls = token.antCls,
    iconCls = token.iconCls,
    motionDurationMid = token.motionDurationMid,
    dropdownPaddingVertical = token.dropdownPaddingVertical,
    fontSize = token.fontSize,
    dropdownEdgeChildPadding = token.dropdownEdgeChildPadding,
    colorTextDisabled = token.colorTextDisabled,
    fontSizeIcon = token.fontSizeIcon,
    controlPaddingHorizontal = token.controlPaddingHorizontal,
    colorBgElevated = token.colorBgElevated,
    boxShadowPopoverArrow = token.boxShadowPopoverArrow;
  return [(0, _defineProperty2.default)({}, componentCls, (0, _extends6.default)((0, _extends6.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'absolute',
    top: -9999,
    left: {
      _skip_check_: true,
      value: -9999
    },
    zIndex: zIndexPopup,
    display: 'block',
    // A placeholder out of dropdown visible range to avoid close when user moving
    '&::before': {
      position: 'absolute',
      insetBlock: -dropdownArrowDistance + sizePopupArrow / 2,
      // insetInlineStart: -7, // FIXME: Seems not work for hidden element
      zIndex: -9999,
      opacity: 0.0001,
      content: '""'
    }
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-wrap"), (_$concat = {
    position: 'relative'
  }, (0, _defineProperty2.default)(_$concat, "".concat(antCls, "-btn > ").concat(iconCls, "-down"), {
    fontSize: fontSizeIcon
  }), (0, _defineProperty2.default)(_$concat, "".concat(iconCls, "-down::before"), {
    transition: "transform ".concat(motionDurationMid)
  }), _$concat)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-wrap-open"), (0, _defineProperty2.default)({}, "".concat(iconCls, "-down::before"), {
    transform: "rotate(180deg)"
  })), (0, _defineProperty2.default)(_extends2, "\n        &-hidden,\n        &-menu-hidden,\n        &-menu-submenu-hidden\n      ", {
    display: 'none'
  }), (0, _defineProperty2.default)(_extends2, "\n        &-show-arrow".concat(componentCls, "-placement-topLeft,\n        &-show-arrow").concat(componentCls, "-placement-top,\n        &-show-arrow").concat(componentCls, "-placement-topRight\n      "), {
    paddingBottom: dropdownArrowDistance
  }), (0, _defineProperty2.default)(_extends2, "\n        &-show-arrow".concat(componentCls, "-placement-bottomLeft,\n        &-show-arrow").concat(componentCls, "-placement-bottom,\n        &-show-arrow").concat(componentCls, "-placement-bottomRight\n      "), {
    paddingTop: dropdownArrowDistance
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-arrow"), (0, _extends6.default)({
    position: 'absolute',
    zIndex: 1,
    display: 'block'
  }, (0, _style.roundedArrow)(sizePopupArrow, token.borderRadiusXS, token.borderRadiusOuter, colorBgElevated, boxShadowPopoverArrow))), (0, _defineProperty2.default)(_extends2, "\n        &-placement-top > ".concat(componentCls, "-arrow,\n        &-placement-topLeft > ").concat(componentCls, "-arrow,\n        &-placement-topRight > ").concat(componentCls, "-arrow\n      "), {
    bottom: dropdownArrowDistance,
    transform: 'translateY(100%) rotate(180deg)'
  }), (0, _defineProperty2.default)(_extends2, "&-placement-top > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: '50%'
    },
    transform: 'translateX(-50%) translateY(100%) rotate(180deg)'
  }), (0, _defineProperty2.default)(_extends2, "&-placement-topLeft > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), (0, _defineProperty2.default)(_extends2, "&-placement-topRight > ".concat(componentCls, "-arrow"), {
    right: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), (0, _defineProperty2.default)(_extends2, "\n          &-placement-bottom > ".concat(componentCls, "-arrow,\n          &-placement-bottomLeft > ").concat(componentCls, "-arrow,\n          &-placement-bottomRight > ").concat(componentCls, "-arrow\n        "), {
    top: dropdownArrowDistance,
    transform: "translateY(-100%)"
  }), (0, _defineProperty2.default)(_extends2, "&-placement-bottom > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: '50%'
    },
    transform: "translateY(-100%) translateX(-50%)"
  }), (0, _defineProperty2.default)(_extends2, "&-placement-bottomLeft > ".concat(componentCls, "-arrow"), {
    left: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), (0, _defineProperty2.default)(_extends2, "&-placement-bottomRight > ".concat(componentCls, "-arrow"), {
    right: {
      _skip_check_: true,
      value: dropdownArrowOffset
    }
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-enter").concat(antCls, "-slide-down-enter-active").concat(componentCls, "-placement-bottomRight,\n          &").concat(antCls, "-slide-down-appear").concat(antCls, "-slide-down-appear-active").concat(componentCls, "-placement-bottomRight"), {
    animationName: _motion.slideUpIn
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-placement-topRight,\n          &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-placement-topRight"), {
    animationName: _motion.slideDownIn
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottomLeft,\n          &").concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottom,\n          &").concat(antCls, "-slide-down-leave").concat(antCls, "-slide-down-leave-active").concat(componentCls, "-placement-bottomRight"), {
    animationName: _motion.slideUpOut
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-topLeft,\n          &").concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-top,\n          &").concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-placement-topRight"), {
    animationName: _motion.slideDownOut
  }), _extends2))), (_ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(componentCls, " ").concat(menuCls), {
    position: 'relative',
    margin: 0
  }), (0, _defineProperty2.default)(_ref2, "".concat(menuCls, "-submenu-popup"), {
    position: 'absolute',
    zIndex: zIndexPopup,
    background: 'transparent',
    boxShadow: 'none',
    transformOrigin: '0 0',
    'ul,li': {
      listStyle: 'none'
    },
    ul: {
      marginInline: '0.3em'
    }
  }), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, ", ").concat(componentCls, "-menu-submenu"), (0, _defineProperty2.default)({}, menuCls, (0, _extends6.default)((0, _extends6.default)({
    padding: dropdownEdgeChildPadding,
    listStyleType: 'none',
    backgroundColor: colorBgElevated,
    backgroundClip: 'padding-box',
    borderRadius: token.borderRadiusLG,
    outline: 'none',
    boxShadow: token.boxShadowSecondary
  }, (0, _style.genFocusStyle)(token)), (_extends5 = {}, (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-item-group-title"), {
    padding: "".concat(dropdownPaddingVertical, "px ").concat(controlPaddingHorizontal, "px"),
    color: token.colorTextDescription,
    transition: "all ".concat(motionDurationMid)
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-item"), {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    borderRadius: token.borderRadiusSM
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-item-icon"), {
    minWidth: fontSize,
    marginInlineEnd: token.marginXS,
    fontSize: token.fontSizeSM
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-title-content"), {
    flex: 'auto',
    '> a': {
      color: 'inherit',
      transition: "all ".concat(motionDurationMid),
      '&:hover': {
        color: 'inherit'
      },
      '&::after': {
        position: 'absolute',
        inset: 0,
        content: '""'
      }
    }
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-item, ").concat(menuCls, "-submenu-title"), (0, _extends6.default)((0, _extends6.default)((0, _defineProperty2.default)({
    clear: 'both',
    margin: 0,
    padding: "".concat(dropdownPaddingVertical, "px ").concat(controlPaddingHorizontal, "px"),
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: fontSize,
    lineHeight: token.lineHeight,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationMid)
  }, "&:hover, &-active", {
    backgroundColor: token.controlItemBgHover
  }), (0, _style.genFocusStyle)(token)), (0, _defineProperty2.default)({
    '&-selected': {
      color: token.colorPrimary,
      backgroundColor: token.controlItemBgActive,
      '&:hover, &-active': {
        backgroundColor: token.controlItemBgActiveHover
      }
    },
    '&-disabled': {
      color: colorTextDisabled,
      cursor: 'not-allowed',
      '&:hover': {
        color: colorTextDisabled,
        backgroundColor: colorBgElevated,
        cursor: 'not-allowed'
      },
      a: {
        pointerEvents: 'none'
      }
    },
    '&-divider': {
      height: 1,
      margin: "".concat(token.marginXXS, "px 0"),
      overflow: 'hidden',
      lineHeight: 0,
      backgroundColor: token.colorSplit
    }
  }, "".concat(componentCls, "-menu-submenu-expand-icon"), (0, _defineProperty2.default)({
    position: 'absolute',
    insetInlineEnd: token.paddingXS
  }, "".concat(componentCls, "-menu-submenu-arrow-icon"), {
    marginInlineEnd: '0 !important',
    color: token.colorTextDescription,
    fontSize: fontSizeIcon,
    fontStyle: 'normal'
  })))), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-item-group-list"), {
    margin: "0 ".concat(token.marginXS, "px"),
    padding: 0,
    listStyle: 'none'
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-submenu-title"), {
    paddingInlineEnd: controlPaddingHorizontal + token.fontSizeSM
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-submenu-vertical"), {
    position: 'relative'
  }), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-submenu").concat(menuCls, "-submenu-disabled ").concat(componentCls, "-menu-submenu-title"), (0, _defineProperty2.default)({}, "&, ".concat(componentCls, "-menu-submenu-arrow-icon"), {
    color: colorTextDisabled,
    backgroundColor: colorBgElevated,
    cursor: 'not-allowed'
  })), (0, _defineProperty2.default)(_extends5, "".concat(menuCls, "-submenu-selected ").concat(componentCls, "-menu-submenu-title"), {
    color: token.colorPrimary
  }), _extends5)))), _ref2),
  // Follow code may reuse in other components
  [(0, _motion.initSlideMotion)(token, 'slide-up'), (0, _motion.initSlideMotion)(token, 'slide-down'), (0, _motion.initMoveMotion)(token, 'move-up'), (0, _motion.initMoveMotion)(token, 'move-down'), (0, _motion.initZoomMotion)(token, 'zoom-big')]];
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Dropdown', function (token, _ref3) {
  var rootPrefixCls = _ref3.rootPrefixCls;
  var marginXXS = token.marginXXS,
    sizePopupArrow = token.sizePopupArrow,
    controlHeight = token.controlHeight,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    paddingXXS = token.paddingXXS,
    componentCls = token.componentCls,
    borderRadiusOuter = token.borderRadiusOuter,
    borderRadiusLG = token.borderRadiusLG;
  var dropdownPaddingVertical = (controlHeight - fontSize * lineHeight) / 2;
  var _getArrowOffset = (0, _placementArrow.getArrowOffset)({
      sizePopupArrow: sizePopupArrow,
      contentRadius: borderRadiusLG,
      borderRadiusOuter: borderRadiusOuter
    }),
    dropdownArrowOffset = _getArrowOffset.dropdownArrowOffset;
  var dropdownToken = (0, _internal.mergeToken)(token, {
    menuCls: "".concat(componentCls, "-menu"),
    rootPrefixCls: rootPrefixCls,
    dropdownArrowDistance: sizePopupArrow / 2 + marginXXS,
    dropdownArrowOffset: dropdownArrowOffset,
    dropdownPaddingVertical: dropdownPaddingVertical,
    dropdownEdgeChildPadding: paddingXXS
  });
  return [genBaseStyle(dropdownToken), (0, _button.default)(dropdownToken), (0, _status.default)(dropdownToken)];
}, function (token) {
  return {
    zIndexPopup: token.zIndexPopupBase + 50
  };
});
exports.default = _default;