"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.floatButtonPrefixCls = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _FloatButtonContent = _interopRequireDefault(require("./FloatButtonContent"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _context = require("./context");
var _warning = _interopRequireDefault(require("../_util/warning"));
var _propsUtil = require("../_util/props-util");
var _interface = require("./interface");
var _style = _interopRequireDefault(require("./style"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// import { useCompactItemContext } from '../space/Compact';
// CSSINJS
var floatButtonPrefixCls = 'float-btn';
exports.floatButtonPrefixCls = floatButtonPrefixCls;
var FloatButton = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AFloatButton',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)((0, _interface.floatButtonProps)(), {
    type: 'default',
    shape: 'circle'
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = (0, _useConfigInject2.default)(floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useInjectFloatButton = (0, _context.useInjectFloatButtonGroupContext)(),
      groupShape = _useInjectFloatButton.shape;
    var floatButtonRef = (0, _vue.ref)(null);
    var mergeShape = (0, _vue.computed)(function () {
      return (groupShape === null || groupShape === void 0 ? void 0 : groupShape.value) || props.shape;
    });
    return function () {
      var _a;
      var customPrefixCls = props.prefixCls,
        _props$type = props.type,
        type = _props$type === void 0 ? 'default' : _props$type,
        _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'circle' : _props$shape,
        _props$description = props.description,
        _description = _props$description === void 0 ? (_a = slots.description) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$description,
        tooltip = props.tooltip,
        restProps = __rest(props, ["prefixCls", "type", "shape", "description", "tooltip"]);
      var classString = (0, _classNames2.default)(prefixCls.value, "".concat(prefixCls.value, "-").concat(type), "".concat(prefixCls.value, "-").concat(mergeShape.value), (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value);
      var buttonNode = (0, _vue.createVNode)(_tooltip.default, {
        "placement": "left"
      }, {
        title: slots.tooltip || tooltip ? function () {
          return slots.tooltip && slots.tooltip() || tooltip;
        } : undefined,
        default: function _default() {
          return (0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls.value, "-body")
          }, [(0, _vue.createVNode)(_FloatButtonContent.default, {
            "prefixCls": prefixCls.value
          }, {
            icon: slots.icon,
            description: function description() {
              return _description;
            }
          })]);
        }
      });
      if (process.env.NODE_ENV !== 'production') {
        (0, _warning.default)(!(shape === 'circle' && _description), 'FloatButton', 'supported only when `shape` is `square`. Due to narrow space for text, short sentence is recommended.');
      }
      return wrapSSR(props.href ? (0, _vue.createVNode)("a", (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({
        "ref": floatButtonRef
      }, attrs), restProps), {}, {
        "class": classString
      }), [buttonNode]) : (0, _vue.createVNode)("button", (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({
        "ref": floatButtonRef
      }, attrs), restProps), {}, {
        "class": classString,
        "type": "button"
      }), [buttonNode]));
    };
  }
});
var _default2 = FloatButton;
exports.default = _default2;