"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _FileTextOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/FileTextOutlined"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _transition = require("../_util/transition");
var _FloatButton = _interopRequireWildcard(require("./FloatButton"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _context = require("./context");
var _propsUtil = require("../_util/props-util");
var _interface = require("./interface");
var _style = _interopRequireDefault(require("./style"));
var _useMergedState3 = _interopRequireDefault(require("../_util/hooks/useMergedState"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// CSSINJS

var FloatButtonGroup = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AFloatButtonGroup',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)((0, _interface.floatButtonGroupProps)(), {
    type: 'default',
    shape: 'circle'
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      emit = _ref.emit;
    var _useConfigInject = (0, _useConfigInject2.default)(_FloatButton.floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useMergedState = (0, _useMergedState3.default)(false, {
        value: (0, _vue.computed)(function () {
          return props.open;
        })
      }),
      _useMergedState2 = (0, _slicedToArray2.default)(_useMergedState, 2),
      open = _useMergedState2[0],
      setOpen = _useMergedState2[1];
    var floatButtonGroupRef = (0, _vue.ref)(null);
    var floatButtonRef = (0, _vue.ref)(null);
    (0, _context.useProvideFloatButtonGroupContext)({
      shape: (0, _vue.computed)(function () {
        return props.shape;
      })
    });
    var hoverTypeAction = {
      onMouseenter: function onMouseenter() {
        var _a;
        setOpen(true);
        emit('update:open', true);
        (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, true);
      },
      onMouseleave: function onMouseleave() {
        var _a;
        setOpen(false);
        emit('update:open', false);
        (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, false);
      }
    };
    var hoverAction = (0, _vue.computed)(function () {
      return props.trigger === 'hover' ? hoverTypeAction : {};
    });
    var handleOpenChange = function handleOpenChange() {
      var _a;
      var nextOpen = !open.value;
      emit('update:open', nextOpen);
      (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, nextOpen);
      setOpen(nextOpen);
    };
    var onClick = function onClick(e) {
      var _a, _b, _c;
      if ((_a = floatButtonGroupRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
        if ((_b = (0, _propsUtil.findDOMNode)(floatButtonRef.value)) === null || _b === void 0 ? void 0 : _b.contains(e.target)) {
          handleOpenChange();
        }
        return;
      }
      setOpen(false);
      emit('update:open', false);
      (_c = props.onOpenChange) === null || _c === void 0 ? void 0 : _c.call(props, false);
    };
    (0, _vue.watch)((0, _vue.computed)(function () {
      return props.trigger;
    }), function (value) {
      document.removeEventListener('click', onClick);
      if (value === 'click') {
        document.addEventListener('click', onClick);
      }
    }, {
      immediate: true
    });
    (0, _vue.onBeforeUnmount)(function () {
      document.removeEventListener('click', onClick);
    });
    return function () {
      var _classNames;
      var _a;
      var _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'circle' : _props$shape,
        _props$type = props.type,
        type = _props$type === void 0 ? 'default' : _props$type,
        tooltip = props.tooltip,
        description = props.description,
        trigger = props.trigger;
      var groupPrefixCls = "".concat(prefixCls.value, "-group");
      var groupCls = (0, _classNames2.default)(groupPrefixCls, hashId.value, attrs.class, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(groupPrefixCls, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames, "".concat(groupPrefixCls, "-").concat(shape), shape), (0, _defineProperty2.default)(_classNames, "".concat(groupPrefixCls, "-").concat(shape, "-shadow"), !trigger), _classNames));
      var wrapperCls = (0, _classNames2.default)(hashId.value, "".concat(groupPrefixCls, "-wrap"));
      var transitionProps = (0, _transition.getTransitionProps)("".concat(groupPrefixCls, "-wrap"));
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({
        "ref": floatButtonGroupRef
      }, attrs), {}, {
        "class": groupCls
      }, hoverAction.value), [trigger && ['click', 'hover'].includes(trigger) ? (0, _vue.createVNode)(_vue.Fragment, null, [(0, _vue.createVNode)(_transition.Transition, transitionProps, {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)("div", {
            "class": wrapperCls
          }, [slots.default && slots.default()]), [[_vue.vShow, open.value]])];
        }
      }), (0, _vue.createVNode)(_FloatButton.default, {
        "ref": floatButtonRef,
        "type": type,
        "shape": shape,
        "tooltip": tooltip,
        "description": description
      }, {
        icon: function icon() {
          var _a, _b;
          return open.value ? ((_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots)) || (0, _vue.createVNode)(_CloseOutlined.default, null, null) : ((_b = slots.icon) === null || _b === void 0 ? void 0 : _b.call(slots)) || (0, _vue.createVNode)(_FileTextOutlined.default, null, null);
        },
        tooltip: slots.tooltip,
        description: slots.description
      })]) : (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]));
    };
  }
});
var _default2 = FloatButtonGroup;
exports.default = _default2;