"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _context = require("./context");
var _transition = require("../_util/transition");
var _collapseMotion = _interopRequireDefault(require("../_util/collapseMotion"));
var _style = _interopRequireDefault(require("./style"));
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ErrorList',
  inheritAttrs: false,
  props: ['errors', 'help', 'onErrorVisibleChanged', 'helpStatus', 'warnings'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs;
    var _useInjectFormItemPre = (0, _context.useInjectFormItemPrefix)(),
      prefixCls = _useInjectFormItemPre.prefixCls,
      status = _useInjectFormItemPre.status;
    var baseClassName = (0, _vue.computed)(function () {
      return "".concat(prefixCls.value, "-item-explain");
    });
    var visible = (0, _vue.computed)(function () {
      return !!(props.errors && props.errors.length);
    });
    var innerStatus = (0, _vue.ref)(status.value);
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      hashId = _useStyle2[1];
    // Memo status in same visible
    (0, _vue.watch)([visible, status], function () {
      if (visible.value) {
        innerStatus.value = status.value;
      }
    });
    return function () {
      var _a, _b;
      var colMItem = (0, _collapseMotion.default)("".concat(prefixCls.value, "-show-help-item"));
      var transitionGroupProps = (0, _transition.getTransitionGroupProps)("".concat(prefixCls.value, "-show-help-item"), colMItem);
      transitionGroupProps.role = 'alert';
      transitionGroupProps.class = [hashId.value, baseClassName.value, attrs.class, "".concat(prefixCls.value, "-show-help")];
      return (0, _vue.createVNode)(_vue.Transition, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, (0, _transition.getTransitionProps)("".concat(prefixCls.value, "-show-help"))), {}, {
        "onAfterEnter": function onAfterEnter() {
          return props.onErrorVisibleChanged(true);
        },
        "onAfterLeave": function onAfterLeave() {
          return props.onErrorVisibleChanged(false);
        }
      }), {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)(_vue.TransitionGroup, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, transitionGroupProps), {}, {
            "tag": "div"
          }), {
            default: function _default() {
              return [(_b = props.errors) === null || _b === void 0 ? void 0 : _b.map(function (error, index) {
                return (0, _vue.createVNode)("div", {
                  "key": index,
                  "class": innerStatus.value ? "".concat(baseClassName.value, "-").concat(innerStatus.value) : ''
                }, [error]);
              })];
            }
          }), [[_vue.vShow, !!((_a = props.errors) === null || _a === void 0 ? void 0 : _a.length)]])];
        }
      });
    };
  }
});
exports.default = _default2;