"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _CloseCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleFilled"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _vnode = require("../_util/vnode");
var _type = require("../_util/type");
var _util = require("./util");
var _FormItemContext = require("../form/FormItemContext");
var _statusUtils = require("../_util/statusUtils");
var ClearableInputType = ['text', 'input'];
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ClearableLabeledInput',
  inheritAttrs: false,
  props: {
    prefixCls: String,
    inputType: _vueTypes.default.oneOf((0, _type.tuple)('text', 'input')),
    value: (0, _type.anyType)(),
    defaultValue: (0, _type.anyType)(),
    allowClear: {
      type: Boolean,
      default: undefined
    },
    element: (0, _type.anyType)(),
    handleReset: Function,
    disabled: {
      type: Boolean,
      default: undefined
    },
    direction: {
      type: String
    },
    size: {
      type: String
    },
    suffix: (0, _type.anyType)(),
    prefix: (0, _type.anyType)(),
    addonBefore: (0, _type.anyType)(),
    addonAfter: (0, _type.anyType)(),
    readonly: {
      type: Boolean,
      default: undefined
    },
    focused: {
      type: Boolean,
      default: undefined
    },
    bordered: {
      type: Boolean,
      default: true
    },
    triggerFocus: {
      type: Function
    },
    hidden: Boolean,
    status: String,
    hashId: String
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var statusContext = _FormItemContext.FormItemInputContext.useInject();
    var renderClearIcon = function renderClearIcon(prefixCls) {
      var _classNames;
      var value = props.value,
        disabled = props.disabled,
        readonly = props.readonly,
        handleReset = props.handleReset,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? slots.suffix : _props$suffix;
      var needClear = !disabled && !readonly && value;
      var className = "".concat(prefixCls, "-clear-icon");
      return (0, _vue.createVNode)(_CloseCircleFilled.default, {
        "onClick": handleReset,
        "onMousedown": function onMousedown(e) {
          return e.preventDefault();
        },
        "class": (0, _classNames3.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(className, "-hidden"), !needClear), (0, _defineProperty2.default)(_classNames, "".concat(className, "-has-suffix"), !!suffix), _classNames), className),
        "role": "button"
      }, null);
    };
    var renderTextAreaWithClearIcon = function renderTextAreaWithClearIcon(prefixCls, element) {
      var _classNames2;
      var value = props.value,
        allowClear = props.allowClear,
        direction = props.direction,
        bordered = props.bordered,
        hidden = props.hidden,
        customStatus = props.status,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        hashId = props.hashId;
      var contextStatus = statusContext.status,
        hasFeedback = statusContext.hasFeedback;
      if (!allowClear) {
        return (0, _vnode.cloneElement)(element, {
          value: value
        });
      }
      var affixWrapperCls = (0, _classNames3.default)("".concat(prefixCls, "-affix-wrapper"), "".concat(prefixCls, "-affix-wrapper-textarea-with-clear-btn"), (0, _statusUtils.getStatusClassNames)("".concat(prefixCls, "-affix-wrapper"), (0, _statusUtils.getMergedStatus)(contextStatus, customStatus), hasFeedback), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-affix-wrapper-rtl"), direction === 'rtl'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-affix-wrapper-borderless"), !bordered), (0, _defineProperty2.default)(_classNames2, "".concat(attrs.class), !(0, _util.hasAddon)({
        addonAfter: addonAfter,
        addonBefore: addonBefore
      }) && attrs.class), _classNames2), hashId);
      return (0, _vue.createVNode)("span", {
        "class": affixWrapperCls,
        "style": attrs.style,
        "hidden": hidden
      }, [(0, _vnode.cloneElement)(element, {
        style: null,
        value: value
      }), renderClearIcon(prefixCls)]);
    };
    return function () {
      var _a;
      var prefixCls = props.prefixCls,
        inputType = props.inputType,
        _props$element = props.element,
        element = _props$element === void 0 ? (_a = slots.element) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$element;
      if (inputType === ClearableInputType[0]) {
        return renderTextAreaWithClearIcon(prefixCls, element);
      }
      return null;
    };
  }
});
exports.default = _default;