"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genStatusStyle = exports.genPlaceholderStyle = exports.genInputSmallStyle = exports.genInputGroupStyle = exports.genHoverStyle = exports.genDisabledStyle = exports.genBasicInputStyle = exports.genActiveStyle = exports.default = void 0;
exports.initInputToken = initInputToken;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends6 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
var _compactItem = require("../../style/compact-item");
var genPlaceholderStyle = function genPlaceholderStyle(color) {
  return {
    // Firefox
    '&::-moz-placeholder': {
      opacity: 1
    },
    '&::placeholder': {
      color: color,
      userSelect: 'none' // https://github.com/ant-design/ant-design/pull/32639
    },

    '&:placeholder-shown': {
      textOverflow: 'ellipsis'
    }
  };
};
exports.genPlaceholderStyle = genPlaceholderStyle;
var genHoverStyle = function genHoverStyle(token) {
  return {
    borderColor: token.inputBorderHoverColor,
    borderInlineEndWidth: token.lineWidth
  };
};
exports.genHoverStyle = genHoverStyle;
var genActiveStyle = function genActiveStyle(token) {
  return {
    borderColor: token.inputBorderHoverColor,
    boxShadow: "0 0 0 ".concat(token.controlOutlineWidth, "px ").concat(token.controlOutline),
    borderInlineEndWidth: token.lineWidth,
    outline: 0
  };
};
exports.genActiveStyle = genActiveStyle;
var genDisabledStyle = function genDisabledStyle(token) {
  return {
    color: token.colorTextDisabled,
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder,
    boxShadow: 'none',
    cursor: 'not-allowed',
    opacity: 1,
    '&:hover': (0, _extends6.default)({}, genHoverStyle((0, _internal.mergeToken)(token, {
      inputBorderHoverColor: token.colorBorder
    })))
  };
};
exports.genDisabledStyle = genDisabledStyle;
var genInputLargeStyle = function genInputLargeStyle(token) {
  var inputPaddingVerticalLG = token.inputPaddingVerticalLG,
    fontSizeLG = token.fontSizeLG,
    lineHeightLG = token.lineHeightLG,
    borderRadiusLG = token.borderRadiusLG,
    inputPaddingHorizontalLG = token.inputPaddingHorizontalLG;
  return {
    padding: "".concat(inputPaddingVerticalLG, "px ").concat(inputPaddingHorizontalLG, "px"),
    fontSize: fontSizeLG,
    lineHeight: lineHeightLG,
    borderRadius: borderRadiusLG
  };
};
var genInputSmallStyle = function genInputSmallStyle(token) {
  return {
    padding: "".concat(token.inputPaddingVerticalSM, "px ").concat(token.controlPaddingHorizontalSM - 1, "px"),
    borderRadius: token.borderRadiusSM
  };
};
exports.genInputSmallStyle = genInputSmallStyle;
var genStatusStyle = function genStatusStyle(token, parentCls) {
  var _ref;
  var componentCls = token.componentCls,
    colorError = token.colorError,
    colorWarning = token.colorWarning,
    colorErrorOutline = token.colorErrorOutline,
    colorWarningOutline = token.colorWarningOutline,
    colorErrorBorderHover = token.colorErrorBorderHover,
    colorWarningBorderHover = token.colorWarningBorderHover;
  return _ref = {}, (0, _defineProperty2.default)(_ref, "&-status-error:not(".concat(parentCls, "-disabled):not(").concat(parentCls, "-borderless)").concat(parentCls), (0, _defineProperty2.default)({
    borderColor: colorError,
    '&:hover': {
      borderColor: colorErrorBorderHover
    },
    '&:focus, &-focused': (0, _extends6.default)({}, genActiveStyle((0, _internal.mergeToken)(token, {
      inputBorderActiveColor: colorError,
      inputBorderHoverColor: colorError,
      controlOutline: colorErrorOutline
    })))
  }, "".concat(componentCls, "-prefix"), {
    color: colorError
  })), (0, _defineProperty2.default)(_ref, "&-status-warning:not(".concat(parentCls, "-disabled):not(").concat(parentCls, "-borderless)").concat(parentCls), (0, _defineProperty2.default)({
    borderColor: colorWarning,
    '&:hover': {
      borderColor: colorWarningBorderHover
    },
    '&:focus, &-focused': (0, _extends6.default)({}, genActiveStyle((0, _internal.mergeToken)(token, {
      inputBorderActiveColor: colorWarning,
      inputBorderHoverColor: colorWarning,
      controlOutline: colorWarningOutline
    })))
  }, "".concat(componentCls, "-prefix"), {
    color: colorWarning
  })), _ref;
};
exports.genStatusStyle = genStatusStyle;
var genBasicInputStyle = function genBasicInputStyle(token) {
  return (0, _extends6.default)((0, _extends6.default)({
    position: 'relative',
    display: 'inline-block',
    width: '100%',
    minWidth: 0,
    padding: "".concat(token.inputPaddingVertical, "px ").concat(token.inputPaddingHorizontal, "px"),
    color: token.colorText,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    backgroundColor: token.colorBgContainer,
    backgroundImage: 'none',
    borderWidth: token.lineWidth,
    borderStyle: token.lineType,
    borderColor: token.colorBorder,
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationMid)
  }, genPlaceholderStyle(token.colorTextPlaceholder)), {
    '&:hover': (0, _extends6.default)({}, genHoverStyle(token)),
    '&:focus, &-focused': (0, _extends6.default)({}, genActiveStyle(token)),
    '&-disabled, &[disabled]': (0, _extends6.default)({}, genDisabledStyle(token)),
    '&-borderless': {
      '&, &:hover, &:focus, &-focused, &-disabled, &[disabled]': {
        backgroundColor: 'transparent',
        border: 'none',
        boxShadow: 'none'
      }
    },
    // Reset height for `textarea`s
    'textarea&': {
      maxWidth: '100%',
      height: 'auto',
      minHeight: token.controlHeight,
      lineHeight: token.lineHeight,
      verticalAlign: 'bottom',
      transition: "all ".concat(token.motionDurationSlow, ", height 0s"),
      resize: 'vertical'
    },
    // Size
    '&-lg': (0, _extends6.default)({}, genInputLargeStyle(token)),
    '&-sm': (0, _extends6.default)({}, genInputSmallStyle(token)),
    // RTL
    '&-rtl': {
      direction: 'rtl'
    },
    '&-textarea-rtl': {
      direction: 'rtl'
    }
  });
};
exports.genBasicInputStyle = genBasicInputStyle;
var genInputGroupStyle = function genInputGroupStyle(token) {
  var _$concat, _addon, _$concat3, _$concat4, _$concat$concat5, _extends2, _ref2;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  return _ref2 = {
    position: 'relative',
    display: 'table',
    width: '100%',
    borderCollapse: 'separate',
    borderSpacing: 0
  }, (0, _defineProperty2.default)(_ref2, "&[class*='col-']", {
    paddingInlineEnd: token.paddingXS,
    '&:last-child': {
      paddingInlineEnd: 0
    }
  }), (0, _defineProperty2.default)(_ref2, "&-lg ".concat(componentCls, ", &-lg > ").concat(componentCls, "-group-addon"), (0, _extends6.default)({}, genInputLargeStyle(token))), (0, _defineProperty2.default)(_ref2, "&-sm ".concat(componentCls, ", &-sm > ").concat(componentCls, "-group-addon"), (0, _extends6.default)({}, genInputSmallStyle(token))), (0, _defineProperty2.default)(_ref2, "&-lg ".concat(antCls, "-select-single ").concat(antCls, "-select-selector"), {
    height: token.controlHeightLG
  }), (0, _defineProperty2.default)(_ref2, "&-sm ".concat(antCls, "-select-single ").concat(antCls, "-select-selector"), {
    height: token.controlHeightSM
  }), (0, _defineProperty2.default)(_ref2, "> ".concat(componentCls), {
    display: 'table-cell',
    '&:not(:first-child):not(:last-child)': {
      borderRadius: 0
    }
  }), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-group"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, "&-addon, &-wrap", {
    display: 'table-cell',
    width: 1,
    whiteSpace: 'nowrap',
    verticalAlign: 'middle',
    '&:not(:first-child):not(:last-child)': {
      borderRadius: 0
    }
  }), (0, _defineProperty2.default)(_$concat3, '&-wrap > *', {
    display: 'block !important'
  }), (0, _defineProperty2.default)(_$concat3, '&-addon', (_addon = {
    position: 'relative',
    padding: "0 ".concat(token.inputPaddingHorizontal, "px"),
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: token.fontSize,
    textAlign: 'center',
    backgroundColor: token.colorFillAlter,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationSlow),
    lineHeight: 1
  }, (0, _defineProperty2.default)(_addon, "".concat(antCls, "-select"), (_$concat = {
    margin: "-".concat(token.inputPaddingVertical + 1, "px -").concat(token.inputPaddingHorizontal, "px")
  }, (0, _defineProperty2.default)(_$concat, "&".concat(antCls, "-select-single:not(").concat(antCls, "-select-customize-input)"), (0, _defineProperty2.default)({}, "".concat(antCls, "-select-selector"), {
    backgroundColor: 'inherit',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    boxShadow: 'none'
  })), (0, _defineProperty2.default)(_$concat, '&-open, &-focused', (0, _defineProperty2.default)({}, "".concat(antCls, "-select-selector"), {
    color: token.colorPrimary
  })), _$concat)), (0, _defineProperty2.default)(_addon, "".concat(antCls, "-cascader-picker"), (0, _defineProperty2.default)({
    margin: "-9px -".concat(token.inputPaddingHorizontal, "px"),
    backgroundColor: 'transparent'
  }, "".concat(antCls, "-cascader-input"), {
    textAlign: 'start',
    border: 0,
    boxShadow: 'none'
  })), _addon)), (0, _defineProperty2.default)(_$concat3, '&-addon:first-child', {
    borderInlineEnd: 0
  }), (0, _defineProperty2.default)(_$concat3, '&-addon:last-child', {
    borderInlineStart: 0
  }), _$concat3)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls), {
    float: 'inline-start',
    width: '100%',
    marginBottom: 0,
    textAlign: 'inherit',
    '&:focus': {
      zIndex: 1,
      borderInlineEndWidth: 1
    },
    '&:hover': (0, _defineProperty2.default)({
      zIndex: 1,
      borderInlineEndWidth: 1
    }, "".concat(componentCls, "-search-with-button &"), {
      zIndex: 0
    })
  }), (0, _defineProperty2.default)(_ref2, "> ".concat(componentCls, ":first-child, ").concat(componentCls, "-group-addon:first-child"), (0, _defineProperty2.default)({
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  }, "".concat(antCls, "-select ").concat(antCls, "-select-selector"), {
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  })), (0, _defineProperty2.default)(_ref2, "> ".concat(componentCls, "-affix-wrapper"), (_$concat4 = {}, (0, _defineProperty2.default)(_$concat4, "&:not(:first-child) ".concat(componentCls), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  }), (0, _defineProperty2.default)(_$concat4, "&:not(:last-child) ".concat(componentCls), {
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  }), _$concat4)), (0, _defineProperty2.default)(_ref2, "> ".concat(componentCls, ":last-child, ").concat(componentCls, "-group-addon:last-child"), (0, _defineProperty2.default)({
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  }, "".concat(antCls, "-select ").concat(antCls, "-select-selector"), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  })), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-affix-wrapper"), (0, _defineProperty2.default)({
    '&:not(:last-child)': (0, _defineProperty2.default)({
      borderStartEndRadius: 0,
      borderEndEndRadius: 0
    }, "".concat(componentCls, "-search &"), {
      borderStartStartRadius: token.borderRadius,
      borderEndStartRadius: token.borderRadius
    })
  }, "&:not(:first-child), ".concat(componentCls, "-search &:not(:first-child)"), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  })), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-group-compact"), (0, _extends6.default)((0, _extends6.default)({
    display: 'block'
  }, (0, _style.clearFix)()), (_extends2 = {}, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-group-addon, ").concat(componentCls, "-group-wrap, > ").concat(componentCls), {
    '&:not(:first-child):not(:last-child)': {
      borderInlineEndWidth: token.lineWidth,
      '&:hover': {
        zIndex: 1
      },
      '&:focus': {
        zIndex: 1
      }
    }
  }), (0, _defineProperty2.default)(_extends2, '& > *', {
    display: 'inline-block',
    float: 'none',
    verticalAlign: 'top',
    borderRadius: 0
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(componentCls, "-affix-wrapper"), {
    display: 'inline-flex'
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(antCls, "-picker-range"), {
    display: 'inline-flex'
  }), (0, _defineProperty2.default)(_extends2, '& > *:not(:last-child)', {
    marginInlineEnd: -token.lineWidth,
    borderInlineEndWidth: token.lineWidth
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls), {
    float: 'none'
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(antCls, "-select > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-select-auto-complete ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker ").concat(componentCls, ",\n      & > ").concat(componentCls, "-group-wrapper ").concat(componentCls), {
    borderInlineEndWidth: token.lineWidth,
    borderRadius: 0,
    '&:hover': {
      zIndex: 1
    },
    '&:focus': {
      zIndex: 1
    }
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(antCls, "-select-focused"), {
    zIndex: 1
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(antCls, "-select > ").concat(antCls, "-select-arrow"), {
    zIndex: 1 // https://github.com/ant-design/ant-design/issues/20371
  }), (0, _defineProperty2.default)(_extends2, "& > *:first-child,\n      & > ".concat(antCls, "-select:first-child > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-select-auto-complete:first-child ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker:first-child ").concat(componentCls), {
    borderStartStartRadius: token.borderRadius,
    borderEndStartRadius: token.borderRadius
  }), (0, _defineProperty2.default)(_extends2, "& > *:last-child,\n      & > ".concat(antCls, "-select:last-child > ").concat(antCls, "-select-selector,\n      & > ").concat(antCls, "-cascader-picker:last-child ").concat(componentCls, ",\n      & > ").concat(antCls, "-cascader-picker-focused:last-child ").concat(componentCls), {
    borderInlineEndWidth: token.lineWidth,
    borderStartEndRadius: token.borderRadius,
    borderEndEndRadius: token.borderRadius
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(antCls, "-select-auto-complete ").concat(componentCls), {
    verticalAlign: 'top'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-group-wrapper + ").concat(componentCls, "-group-wrapper"), (0, _defineProperty2.default)({
    marginInlineStart: -token.lineWidth
  }, "".concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-group-wrapper:not(:last-child)"), (0, _defineProperty2.default)({}, "&".concat(componentCls, "-search > ").concat(componentCls, "-group"), (_$concat$concat5 = {}, (0, _defineProperty2.default)(_$concat$concat5, "& > ".concat(componentCls, "-group-addon > ").concat(componentCls, "-search-button"), {
    borderRadius: 0
  }), (0, _defineProperty2.default)(_$concat$concat5, "& > ".concat(componentCls), {
    borderStartStartRadius: token.borderRadius,
    borderStartEndRadius: 0,
    borderEndEndRadius: 0,
    borderEndStartRadius: token.borderRadius
  }), _$concat$concat5))), _extends2))), _ref2;
};
exports.genInputGroupStyle = genInputGroupStyle;
var genInputStyle = function genInputStyle(token) {
  var _typeColor;
  var componentCls = token.componentCls,
    controlHeightSM = token.controlHeightSM,
    lineWidth = token.lineWidth;
  var FIXED_CHROME_COLOR_HEIGHT = 16;
  var colorSmallPadding = (controlHeightSM - lineWidth * 2 - FIXED_CHROME_COLOR_HEIGHT) / 2;
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)({}, (0, _style.resetComponent)(token)), genBasicInputStyle(token)), genStatusStyle(token, componentCls)), {
    '&[type="color"]': (_typeColor = {
      height: token.controlHeight
    }, (0, _defineProperty2.default)(_typeColor, "&".concat(componentCls, "-lg"), {
      height: token.controlHeightLG
    }), (0, _defineProperty2.default)(_typeColor, "&".concat(componentCls, "-sm"), {
      height: controlHeightSM,
      paddingTop: colorSmallPadding,
      paddingBottom: colorSmallPadding
    }), _typeColor)
  }));
};
var genAllowClearStyle = function genAllowClearStyle(token) {
  var _ref4;
  var componentCls = token.componentCls;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-clear-icon"), {
    margin: 0,
    color: token.colorTextQuaternary,
    fontSize: token.fontSizeIcon,
    verticalAlign: -1,
    // https://github.com/ant-design/ant-design/pull/18151
    // https://codesandbox.io/s/wizardly-sun-u10br
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationSlow),
    '&:hover': {
      color: token.colorTextTertiary
    },
    '&:active': {
      color: token.colorText
    },
    '&-hidden': {
      visibility: 'hidden'
    },
    '&-has-suffix': {
      margin: "0 ".concat(token.inputAffixPadding, "px")
    }
  }), (0, _defineProperty2.default)(_ref4, '&-textarea-with-clear-btn', (0, _defineProperty2.default)({
    padding: '0 !important',
    border: '0 !important'
  }, "".concat(componentCls, "-clear-icon"), {
    position: 'absolute',
    insetBlockStart: token.paddingXS,
    insetInlineEnd: token.paddingXS,
    zIndex: 1
  })), _ref4;
};
var genAffixStyle = function genAffixStyle(token) {
  var _extends4;
  var componentCls = token.componentCls,
    inputAffixPadding = token.inputAffixPadding,
    colorTextDescription = token.colorTextDescription,
    motionDurationSlow = token.motionDurationSlow,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover,
    iconCls = token.iconCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-affix-wrapper"), (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)({}, genBasicInputStyle(token)), (_extends4 = {
    display: 'inline-flex'
  }, (0, _defineProperty2.default)(_extends4, "&:not(".concat(componentCls, "-affix-wrapper-disabled):hover"), (0, _extends6.default)((0, _extends6.default)({}, genHoverStyle(token)), (0, _defineProperty2.default)({
    zIndex: 1
  }, "".concat(componentCls, "-search-with-button &"), {
    zIndex: 0
  }))), (0, _defineProperty2.default)(_extends4, '&-focused, &:focus', {
    zIndex: 1
  }), (0, _defineProperty2.default)(_extends4, '&-disabled', (0, _defineProperty2.default)({}, "".concat(componentCls, "[disabled]"), {
    background: 'transparent'
  })), (0, _defineProperty2.default)(_extends4, "> input".concat(componentCls), {
    padding: 0,
    fontSize: 'inherit',
    border: 'none',
    borderRadius: 0,
    outline: 'none',
    '&:focus': {
      boxShadow: 'none !important'
    }
  }), (0, _defineProperty2.default)(_extends4, '&::before', {
    width: 0,
    visibility: 'hidden',
    content: '"\\a0"'
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls), {
    '&-prefix, &-suffix': {
      display: 'flex',
      flex: 'none',
      alignItems: 'center',
      '> *:not(:last-child)': {
        marginInlineEnd: token.paddingXS
      }
    },
    '&-show-count-suffix': {
      color: colorTextDescription
    },
    '&-show-count-has-suffix': {
      marginInlineEnd: token.paddingXXS
    },
    '&-prefix': {
      marginInlineEnd: inputAffixPadding
    },
    '&-suffix': {
      marginInlineStart: inputAffixPadding
    }
  }), _extends4)), genAllowClearStyle(token)), (0, _defineProperty2.default)({}, "".concat(iconCls).concat(componentCls, "-password-icon"), {
    color: colorIcon,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationSlow),
    '&:hover': {
      color: colorIconHover
    }
  })), genStatusStyle(token, "".concat(componentCls, "-affix-wrapper"))));
};
var genGroupStyle = function genGroupStyle(token) {
  var componentCls = token.componentCls,
    colorError = token.colorError,
    colorSuccess = token.colorSuccess,
    borderRadiusLG = token.borderRadiusLG,
    borderRadiusSM = token.borderRadiusSM;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-group"), (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)({}, (0, _style.resetComponent)(token)), genInputGroupStyle(token)), {
    '&-rtl': {
      direction: 'rtl'
    },
    '&-wrapper': {
      display: 'inline-block',
      width: '100%',
      textAlign: 'start',
      verticalAlign: 'top',
      '&-rtl': {
        direction: 'rtl'
      },
      // Size
      '&-lg': (0, _defineProperty2.default)({}, "".concat(componentCls, "-group-addon"), {
        borderRadius: borderRadiusLG
      }),
      '&-sm': (0, _defineProperty2.default)({}, "".concat(componentCls, "-group-addon"), {
        borderRadius: borderRadiusSM
      }),
      // Status
      '&-status-error': (0, _defineProperty2.default)({}, "".concat(componentCls, "-group-addon"), {
        color: colorError,
        borderColor: colorError
      }),
      '&-status-warning': (0, _defineProperty2.default)({}, "".concat(componentCls, "-group-addon:last-child"), {
        color: colorSuccess,
        borderColor: colorSuccess
      })
    }
  }));
};
var genSearchInputStyle = function genSearchInputStyle(token) {
  var _$concat7, _$concat10, _searchPrefixCls;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  var searchPrefixCls = "".concat(componentCls, "-search");
  return (0, _defineProperty2.default)({}, searchPrefixCls, (_searchPrefixCls = {}, (0, _defineProperty2.default)(_searchPrefixCls, "".concat(componentCls), {
    '&:hover, &:focus': (0, _defineProperty2.default)({
      borderColor: token.colorPrimaryHover
    }, "+ ".concat(componentCls, "-group-addon ").concat(searchPrefixCls, "-button:not(").concat(antCls, "-btn-primary)"), {
      borderInlineStartColor: token.colorPrimaryHover
    })
  }), (0, _defineProperty2.default)(_searchPrefixCls, "".concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  }), (0, _defineProperty2.default)(_searchPrefixCls, "".concat(componentCls, "-lg"), {
    lineHeight: token.lineHeightLG - 0.0002
  }), (0, _defineProperty2.default)(_searchPrefixCls, "> ".concat(componentCls, "-group"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-group-addon:last-child"), (_$concat7 = {
    insetInlineStart: -1,
    padding: 0,
    border: 0
  }, (0, _defineProperty2.default)(_$concat7, "".concat(searchPrefixCls, "-button"), {
    paddingTop: 0,
    paddingBottom: 0,
    borderStartStartRadius: 0,
    borderStartEndRadius: token.borderRadius,
    borderEndEndRadius: token.borderRadius,
    borderEndStartRadius: 0
  }), (0, _defineProperty2.default)(_$concat7, "".concat(searchPrefixCls, "-button:not(").concat(antCls, "-btn-primary)"), (0, _defineProperty2.default)({
    color: token.colorTextDescription,
    '&:hover': {
      color: token.colorPrimaryHover
    },
    '&:active': {
      color: token.colorPrimaryActive
    }
  }, "&".concat(antCls, "-btn-loading::before"), {
    insetInlineStart: 0,
    insetInlineEnd: 0,
    insetBlockStart: 0,
    insetBlockEnd: 0
  })), _$concat7))), (0, _defineProperty2.default)(_searchPrefixCls, "".concat(searchPrefixCls, "-button"), {
    height: token.controlHeight,
    '&:hover, &:focus': {
      zIndex: 1
    }
  }), (0, _defineProperty2.default)(_searchPrefixCls, "&-large ".concat(searchPrefixCls, "-button"), {
    height: token.controlHeightLG
  }), (0, _defineProperty2.default)(_searchPrefixCls, "&-small ".concat(searchPrefixCls, "-button"), {
    height: token.controlHeightSM
  }), (0, _defineProperty2.default)(_searchPrefixCls, '&-rtl', {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_searchPrefixCls, "&".concat(componentCls, "-compact-item"), (_$concat10 = {}, (0, _defineProperty2.default)(_$concat10, "&:not(".concat(componentCls, "-compact-last-item)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-group-addon"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-search-button"), {
    marginInlineEnd: -token.lineWidth,
    borderRadius: 0
  }))), (0, _defineProperty2.default)(_$concat10, "&:not(".concat(componentCls, "-compact-first-item)"), (0, _defineProperty2.default)({}, "".concat(componentCls, ",").concat(componentCls, "-affix-wrapper"), {
    borderRadius: 0
  })), (0, _defineProperty2.default)(_$concat10, "> ".concat(componentCls, "-group-addon ").concat(componentCls, "-search-button,\n        > ").concat(componentCls, ",\n        ").concat(componentCls, "-affix-wrapper"), {
    '&:hover,&:focus,&:active': {
      zIndex: 2
    }
  }), (0, _defineProperty2.default)(_$concat10, "> ".concat(componentCls, "-affix-wrapper-focused"), {
    zIndex: 2
  }), _$concat10)), _searchPrefixCls));
};
function initInputToken(token) {
  // @ts-ignore
  return (0, _internal.mergeToken)(token, {
    inputAffixPadding: token.paddingXXS,
    inputPaddingVertical: Math.max(Math.round((token.controlHeight - token.fontSize * token.lineHeight) / 2 * 10) / 10 - token.lineWidth, 3),
    inputPaddingVerticalLG: Math.ceil((token.controlHeightLG - token.fontSizeLG * token.lineHeightLG) / 2 * 10) / 10 - token.lineWidth,
    inputPaddingVerticalSM: Math.max(Math.round((token.controlHeightSM - token.fontSize * token.lineHeight) / 2 * 10) / 10 - token.lineWidth, 0),
    inputPaddingHorizontal: token.paddingSM - token.lineWidth,
    inputPaddingHorizontalSM: token.paddingXS - token.lineWidth,
    inputPaddingHorizontalLG: token.controlPaddingHorizontal - token.lineWidth,
    inputBorderHoverColor: token.colorPrimaryHover,
    inputBorderActiveColor: token.colorPrimaryHover
  });
}
var genTextAreaStyle = function genTextAreaStyle(token) {
  var _showCount, _textareaPrefixCls;
  var componentCls = token.componentCls,
    inputPaddingHorizontal = token.inputPaddingHorizontal,
    paddingLG = token.paddingLG;
  var textareaPrefixCls = "".concat(componentCls, "-textarea");
  return (0, _defineProperty2.default)({}, textareaPrefixCls, (_textareaPrefixCls = {
    position: 'relative'
  }, (0, _defineProperty2.default)(_textareaPrefixCls, "".concat(textareaPrefixCls, "-suffix"), {
    position: 'absolute',
    top: 0,
    insetInlineEnd: inputPaddingHorizontal,
    bottom: 0,
    zIndex: 1,
    display: 'inline-flex',
    alignItems: 'center',
    margin: 'auto'
  }), (0, _defineProperty2.default)(_textareaPrefixCls, "&-status-error,\n        &-status-warning,\n        &-status-success,\n        &-status-validating", (0, _defineProperty2.default)({}, "&".concat(textareaPrefixCls, "-has-feedback"), (0, _defineProperty2.default)({}, "".concat(componentCls), {
    paddingInlineEnd: paddingLG
  }))), (0, _defineProperty2.default)(_textareaPrefixCls, '&-show-count', (_showCount = {}, (0, _defineProperty2.default)(_showCount, "> ".concat(componentCls), {
    height: '100%'
  }), (0, _defineProperty2.default)(_showCount, '&::after', {
    color: token.colorTextDescription,
    whiteSpace: 'nowrap',
    content: 'attr(data-count)',
    pointerEvents: 'none',
    float: 'right'
  }), _showCount)), (0, _defineProperty2.default)(_textareaPrefixCls, '&-rtl', {
    '&::after': {
      float: 'left'
    }
  }), _textareaPrefixCls));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Input', function (token) {
  var inputToken = initInputToken(token);
  return [genInputStyle(inputToken), genTextAreaStyle(inputToken), genAffixStyle(inputToken), genGroupStyle(inputToken), genSearchInputStyle(inputToken),
  // =====================================================
  // ==             Space Compact                       ==
  // =====================================================
  (0, _compactItem.genCompactItemStyle)(inputToken)];
});
exports.default = _default;