"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _style = require("../../style");
// deps-lint-skip-all

var genMessageStyle = function genMessageStyle(token) {
  var _extends2, _$concat;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    boxShadowSecondary = token.boxShadowSecondary,
    colorBgElevated = token.colorBgElevated,
    colorSuccess = token.colorSuccess,
    colorError = token.colorError,
    colorWarning = token.colorWarning,
    colorInfo = token.colorInfo,
    fontSizeLG = token.fontSizeLG,
    motionEaseInOutCirc = token.motionEaseInOutCirc,
    motionDurationSlow = token.motionDurationSlow,
    marginXS = token.marginXS,
    paddingXS = token.paddingXS,
    borderRadiusLG = token.borderRadiusLG,
    zIndexPopup = token.zIndexPopup,
    messageNoticeContentPadding = token.messageNoticeContentPadding;
  var messageMoveIn = new _cssinjs.Keyframes('MessageMoveIn', {
    '0%': {
      padding: 0,
      transform: 'translateY(-100%)',
      opacity: 0
    },
    '100%': {
      padding: paddingXS,
      transform: 'translateY(0)',
      opacity: 1
    }
  });
  var messageMoveOut = new _cssinjs.Keyframes('MessageMoveOut', {
    '0%': {
      maxHeight: token.height,
      padding: paddingXS,
      opacity: 1
    },
    '100%': {
      maxHeight: 0,
      padding: 0,
      opacity: 0
    }
  });
  return [// ============================ Holder ============================
  (0, _defineProperty2.default)({}, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'fixed',
    top: marginXS,
    width: '100%',
    pointerEvents: 'none',
    zIndex: zIndexPopup
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-move-up"), {
    animationFillMode: 'forwards'
  }), (0, _defineProperty2.default)(_extends2, "\n        ".concat(componentCls, "-move-up-appear,\n        ").concat(componentCls, "-move-up-enter\n      "), {
    animationName: messageMoveIn,
    animationDuration: motionDurationSlow,
    animationPlayState: 'paused',
    animationTimingFunction: motionEaseInOutCirc
  }), (0, _defineProperty2.default)(_extends2, "\n        ".concat(componentCls, "-move-up-appear").concat(componentCls, "-move-up-appear-active,\n        ").concat(componentCls, "-move-up-enter").concat(componentCls, "-move-up-enter-active\n      "), {
    animationPlayState: 'running'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-move-up-leave"), {
    animationName: messageMoveOut,
    animationDuration: motionDurationSlow,
    animationPlayState: 'paused',
    animationTimingFunction: motionEaseInOutCirc
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-move-up-leave").concat(componentCls, "-move-up-leave-active"), {
    animationPlayState: 'running'
  }), (0, _defineProperty2.default)(_extends2, '&-rtl', {
    direction: 'rtl',
    span: {
      direction: 'rtl'
    }
  }), _extends2))), // ============================ Notice ============================
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-notice"), (_$concat = {
    padding: paddingXS,
    textAlign: 'center'
  }, (0, _defineProperty2.default)(_$concat, iconCls, {
    verticalAlign: 'text-bottom',
    marginInlineEnd: marginXS,
    fontSize: fontSizeLG
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-notice-content"), {
    display: 'inline-block',
    padding: messageNoticeContentPadding,
    background: colorBgElevated,
    borderRadius: borderRadiusLG,
    boxShadow: boxShadowSecondary,
    pointerEvents: 'all'
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-success ").concat(iconCls), {
    color: colorSuccess
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-error ").concat(iconCls), {
    color: colorError
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-warning ").concat(iconCls), {
    color: colorWarning
  }), (0, _defineProperty2.default)(_$concat, "\n        ".concat(componentCls, "-info ").concat(iconCls, ",\n        ").concat(componentCls, "-loading ").concat(iconCls), {
    color: colorInfo
  }), _$concat)), // ============================= Pure =============================
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-notice-pure-panel"), {
    padding: 0,
    textAlign: 'start'
  })];
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Message', function (token) {
  // Gen-style functions here
  var combinedToken = (0, _internal.mergeToken)(token, {
    messageNoticeContentPadding: "".concat((token.controlHeightLG - token.fontSize * token.lineHeight) / 2, "px ").concat(token.paddingSM, "px")
  });
  return [genMessageStyle(combinedToken)];
}, function (token) {
  return {
    height: 150,
    zIndexPopup: token.zIndexPopupBase + 10
  };
});
exports.default = _default;