"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genModalMaskStyle = exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _style = require("../../style");
require("vue");
function box(position) {
  return {
    position: position,
    top: 0,
    insetInlineEnd: 0,
    bottom: 0,
    insetInlineStart: 0
  };
}
var genModalMaskStyle = function genModalMaskStyle(token) {
  var _$concat;
  var componentCls = token.componentCls;
  return [(0, _defineProperty2.default)({}, "".concat(componentCls, "-root"), (_$concat = {}, (0, _defineProperty2.default)(_$concat, "".concat(componentCls).concat(token.antCls, "-zoom-enter, ").concat(componentCls).concat(token.antCls, "-zoom-appear"), {
    // reset scale avoid mousePosition bug
    transform: 'none',
    opacity: 0,
    animationDuration: token.motionDurationSlow,
    // https://github.com/ant-design/ant-design/issues/11777
    userSelect: 'none'
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-mask"), (0, _extends4.default)((0, _extends4.default)({}, box('fixed')), (0, _defineProperty2.default)({
    zIndex: token.zIndexPopupBase,
    height: '100%',
    backgroundColor: token.colorBgMask
  }, "".concat(componentCls, "-hidden"), {
    display: 'none'
  }))), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-wrap"), (0, _extends4.default)((0, _extends4.default)({}, box('fixed')), {
    overflow: 'auto',
    outline: 0,
    WebkitOverflowScrolling: 'touch'
  })), _$concat)), (0, _defineProperty2.default)({}, "".concat(componentCls, "-root"), (0, _motion.initFadeMotion)(token))];
};
exports.genModalMaskStyle = genModalMaskStyle;
var genModalStyle = function genModalStyle(token) {
  var _mediaMaxWidth$, _$concat4, _extends3, _$concat6;
  var componentCls = token.componentCls;
  return [// ======================== Root =========================
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-root"), (_$concat4 = {}, (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-wrap"), {
    zIndex: token.zIndexPopupBase,
    position: 'fixed',
    inset: 0,
    overflow: 'auto',
    outline: 0,
    WebkitOverflowScrolling: 'touch'
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-wrap-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-centered"), (0, _defineProperty2.default)({
    textAlign: 'center',
    '&::before': {
      display: 'inline-block',
      width: 0,
      height: '100%',
      verticalAlign: 'middle',
      content: '""'
    }
  }, componentCls, {
    top: 0,
    display: 'inline-block',
    paddingBottom: 0,
    textAlign: 'start',
    verticalAlign: 'middle'
  })), (0, _defineProperty2.default)(_$concat4, "@media (max-width: ".concat(token.screenSMMax, ")"), (_mediaMaxWidth$ = {}, (0, _defineProperty2.default)(_mediaMaxWidth$, componentCls, {
    maxWidth: 'calc(100vw - 16px)',
    margin: "".concat(token.marginXS, " auto")
  }), (0, _defineProperty2.default)(_mediaMaxWidth$, "".concat(componentCls, "-centered"), (0, _defineProperty2.default)({}, componentCls, {
    flex: 1
  })), _mediaMaxWidth$)), _$concat4)), // ======================== Modal ========================
  (0, _defineProperty2.default)({}, componentCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    pointerEvents: 'none',
    position: 'relative',
    top: 100,
    width: 'auto',
    maxWidth: "calc(100vw - ".concat(token.margin * 2, "px)"),
    margin: '0 auto',
    paddingBottom: token.paddingLG
  }, (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-title"), {
    margin: 0,
    color: token.modalHeadingColor,
    fontWeight: token.fontWeightStrong,
    fontSize: token.modalHeaderTitleFontSize,
    lineHeight: token.modalHeaderTitleLineHeight,
    wordWrap: 'break-word'
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-content"), {
    position: 'relative',
    backgroundColor: token.modalContentBg,
    backgroundClip: 'padding-box',
    border: 0,
    borderRadius: token.borderRadiusLG,
    boxShadow: token.boxShadowSecondary,
    pointerEvents: 'auto',
    padding: "".concat(token.paddingMD, "px ").concat(token.paddingContentHorizontalLG, "px")
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-close"), (0, _extends4.default)({
    position: 'absolute',
    top: (token.modalHeaderCloseSize - token.modalCloseBtnSize) / 2,
    insetInlineEnd: (token.modalHeaderCloseSize - token.modalCloseBtnSize) / 2,
    zIndex: token.zIndexPopupBase + 10,
    padding: 0,
    color: token.modalCloseColor,
    fontWeight: token.fontWeightStrong,
    lineHeight: 1,
    textDecoration: 'none',
    background: 'transparent',
    borderRadius: token.borderRadiusSM,
    width: token.modalConfirmIconSize,
    height: token.modalConfirmIconSize,
    border: 0,
    outline: 0,
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationMid, ", background-color ").concat(token.motionDurationMid),
    '&-x': {
      display: 'block',
      fontSize: token.fontSizeLG,
      fontStyle: 'normal',
      lineHeight: "".concat(token.modalCloseBtnSize, "px"),
      textAlign: 'center',
      textTransform: 'none',
      textRendering: 'auto'
    },
    '&:hover': {
      color: token.modalIconHoverColor,
      backgroundColor: token.wireframe ? 'transparent' : token.colorFillContent,
      textDecoration: 'none'
    },
    '&:active': {
      backgroundColor: token.wireframe ? 'transparent' : token.colorFillContentHover
    }
  }, (0, _style.genFocusStyle)(token))), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-header"), {
    color: token.colorText,
    background: token.modalHeaderBg,
    borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0"),
    marginBottom: token.marginXS
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-body"), {
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    wordWrap: 'break-word'
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-footer"), (0, _defineProperty2.default)({
    textAlign: 'end',
    background: token.modalFooterBg,
    marginTop: token.marginSM
  }, "".concat(token.antCls, "-btn + ").concat(token.antCls, "-btn:not(").concat(token.antCls, "-dropdown-trigger)"), {
    marginBottom: 0,
    marginInlineStart: token.marginXS
  })), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-open"), {
    overflow: 'hidden'
  }), _extends3))), // ======================== Pure =========================
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-pure-panel"), (_$concat6 = {
    top: 'auto',
    padding: 0,
    display: 'flex',
    flexDirection: 'column'
  }, (0, _defineProperty2.default)(_$concat6, "".concat(componentCls, "-content,\n          ").concat(componentCls, "-body,\n          ").concat(componentCls, "-confirm-body-wrapper"), {
    display: 'flex',
    flexDirection: 'column',
    flex: 'auto'
  }), (0, _defineProperty2.default)(_$concat6, "".concat(componentCls, "-confirm-body"), {
    marginBottom: 'auto'
  }), _$concat6))];
};
var genModalConfirmStyle = function genModalConfirmStyle(token) {
  var _$concat8, _$concat9, _confirmComponentCls, _ref6;
  var componentCls = token.componentCls;
  var confirmComponentCls = "".concat(componentCls, "-confirm");
  return _ref6 = {}, (0, _defineProperty2.default)(_ref6, confirmComponentCls, (_confirmComponentCls = {
    '&-rtl': {
      direction: 'rtl'
    }
  }, (0, _defineProperty2.default)(_confirmComponentCls, "".concat(token.antCls, "-modal-header"), {
    display: 'none'
  }), (0, _defineProperty2.default)(_confirmComponentCls, "".concat(confirmComponentCls, "-body-wrapper"), (0, _extends4.default)({}, (0, _style.clearFix)())), (0, _defineProperty2.default)(_confirmComponentCls, "".concat(confirmComponentCls, "-body"), (_$concat9 = {
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center'
  }, (0, _defineProperty2.default)(_$concat9, "".concat(confirmComponentCls, "-title"), (0, _defineProperty2.default)({
    flex: '0 0 100%',
    display: 'block',
    // create BFC to avoid
    // https://user-images.githubusercontent.com/507615/37702510-ba844e06-2d2d-11e8-9b67-8e19be57f445.png
    overflow: 'hidden',
    color: token.colorTextHeading,
    fontWeight: token.fontWeightStrong,
    fontSize: token.modalHeaderTitleFontSize,
    lineHeight: token.modalHeaderTitleLineHeight
  }, "+ ".concat(confirmComponentCls, "-content"), {
    marginBlockStart: token.marginXS,
    flexBasis: '100%',
    maxWidth: "calc(100% - ".concat(token.modalConfirmIconSize + token.marginSM, "px)")
  })), (0, _defineProperty2.default)(_$concat9, "".concat(confirmComponentCls, "-content"), {
    color: token.colorText,
    fontSize: token.fontSize
  }), (0, _defineProperty2.default)(_$concat9, "> ".concat(token.iconCls), (_$concat8 = {
    flex: 'none',
    marginInlineEnd: token.marginSM,
    fontSize: token.modalConfirmIconSize
  }, (0, _defineProperty2.default)(_$concat8, "+ ".concat(confirmComponentCls, "-title"), {
    flex: 1
  }), (0, _defineProperty2.default)(_$concat8, "+ ".concat(confirmComponentCls, "-title + ").concat(confirmComponentCls, "-content"), {
    marginInlineStart: token.modalConfirmIconSize + token.marginSM
  }), _$concat8)), _$concat9)), (0, _defineProperty2.default)(_confirmComponentCls, "".concat(confirmComponentCls, "-btns"), (0, _defineProperty2.default)({
    textAlign: 'end',
    marginTop: token.marginSM
  }, "".concat(token.antCls, "-btn + ").concat(token.antCls, "-btn"), {
    marginBottom: 0,
    marginInlineStart: token.marginXS
  })), _confirmComponentCls)), (0, _defineProperty2.default)(_ref6, "".concat(confirmComponentCls, "-error ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorError
  }), (0, _defineProperty2.default)(_ref6, "".concat(confirmComponentCls, "-warning ").concat(confirmComponentCls, "-body > ").concat(token.iconCls, ",\n        ").concat(confirmComponentCls, "-confirm ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorWarning
  }), (0, _defineProperty2.default)(_ref6, "".concat(confirmComponentCls, "-info ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorInfo
  }), (0, _defineProperty2.default)(_ref6, "".concat(confirmComponentCls, "-success ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorSuccess
  }), (0, _defineProperty2.default)(_ref6, "".concat(componentCls, "-zoom-leave ").concat(componentCls, "-btns"), {
    pointerEvents: 'none'
  }), _ref6;
};
var genRTLStyle = function genRTLStyle(token) {
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-root"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrap-rtl"), (0, _defineProperty2.default)({
    direction: 'rtl'
  }, "".concat(componentCls, "-confirm-body"), {
    direction: 'rtl'
  })));
};
var genWireframeStyle = function genWireframeStyle(token) {
  var _componentCls, _confirmComponentCls2, _ref8;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  var confirmComponentCls = "".concat(componentCls, "-confirm");
  return _ref8 = {}, (0, _defineProperty2.default)(_ref8, componentCls, (_componentCls = {}, (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-content"), {
    padding: 0
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-header"), {
    padding: token.modalHeaderPadding,
    borderBottom: "".concat(token.modalHeaderBorderWidth, "px ").concat(token.modalHeaderBorderStyle, " ").concat(token.modalHeaderBorderColorSplit),
    marginBottom: 0
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-body"), {
    padding: token.modalBodyPadding
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-footer"), {
    padding: "".concat(token.modalFooterPaddingVertical, "px ").concat(token.modalFooterPaddingHorizontal, "px"),
    borderTop: "".concat(token.modalFooterBorderWidth, "px ").concat(token.modalFooterBorderStyle, " ").concat(token.modalFooterBorderColorSplit),
    borderRadius: "0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px"),
    marginTop: 0
  }), _componentCls)), (0, _defineProperty2.default)(_ref8, confirmComponentCls, (_confirmComponentCls2 = {}, (0, _defineProperty2.default)(_confirmComponentCls2, "".concat(antCls, "-modal-body"), {
    padding: "".concat(token.padding * 2, "px ").concat(token.padding * 2, "px ").concat(token.paddingLG, "px")
  }), (0, _defineProperty2.default)(_confirmComponentCls2, "".concat(confirmComponentCls, "-body"), (0, _defineProperty2.default)({}, "> ".concat(token.iconCls), (0, _defineProperty2.default)({
    marginInlineEnd: token.margin
  }, "+ ".concat(confirmComponentCls, "-title + ").concat(confirmComponentCls, "-content"), {
    marginInlineStart: token.modalConfirmIconSize + token.margin
  }))), (0, _defineProperty2.default)(_confirmComponentCls2, "".concat(confirmComponentCls, "-btns"), {
    marginTop: token.marginLG
  }), _confirmComponentCls2)), _ref8;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Modal', function (token) {
  var headerPaddingVertical = token.padding;
  var headerFontSize = token.fontSizeHeading5;
  var headerLineHeight = token.lineHeightHeading5;
  var modalToken = (0, _internal.mergeToken)(token, {
    modalBodyPadding: token.paddingLG,
    modalHeaderBg: token.colorBgElevated,
    modalHeaderPadding: "".concat(headerPaddingVertical, "px ").concat(token.paddingLG, "px"),
    modalHeaderBorderWidth: token.lineWidth,
    modalHeaderBorderStyle: token.lineType,
    modalHeaderTitleLineHeight: headerLineHeight,
    modalHeaderTitleFontSize: headerFontSize,
    modalHeaderBorderColorSplit: token.colorSplit,
    modalHeaderCloseSize: headerLineHeight * headerFontSize + headerPaddingVertical * 2,
    modalContentBg: token.colorBgElevated,
    modalHeadingColor: token.colorTextHeading,
    modalCloseColor: token.colorTextDescription,
    modalFooterBg: 'transparent',
    modalFooterBorderColorSplit: token.colorSplit,
    modalFooterBorderStyle: token.lineType,
    modalFooterPaddingVertical: token.paddingXS,
    modalFooterPaddingHorizontal: token.padding,
    modalFooterBorderWidth: token.lineWidth,
    modalConfirmTitleFontSize: token.fontSizeLG,
    modalIconHoverColor: token.colorIconHover,
    modalConfirmIconSize: token.fontSize * token.lineHeight,
    modalCloseBtnSize: token.controlHeightLG * 0.55
  });
  return [genModalStyle(modalToken), genModalConfirmStyle(modalToken), genRTLStyle(modalToken), genModalMaskStyle(modalToken), token.wireframe && genWireframeStyle(modalToken), (0, _motion.initZoomMotion)(modalToken, 'zoom')];
});
exports.default = _default;