"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var _placementArrow = _interopRequireDefault(require("../../style/placementArrow"));
var genBaseStyle = function genBaseStyle(token) {
  var _extends2;
  var componentCls = token.componentCls,
    popoverBg = token.popoverBg,
    popoverColor = token.popoverColor,
    width = token.width,
    fontWeightStrong = token.fontWeightStrong,
    popoverPadding = token.popoverPadding,
    boxShadowSecondary = token.boxShadowSecondary,
    colorTextHeading = token.colorTextHeading,
    borderRadius = token.borderRadiusLG,
    zIndexPopup = token.zIndexPopup,
    marginXS = token.marginXS,
    colorBgElevated = token.colorBgElevated;
  return [(0, _defineProperty2.default)({}, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'absolute',
    top: 0,
    // use `left` to fix https://github.com/ant-design/ant-design/issues/39195
    left: {
      _skip_check_: true,
      value: 0
    },
    zIndex: zIndexPopup,
    fontWeight: 'normal',
    whiteSpace: 'normal',
    textAlign: 'start',
    cursor: 'auto',
    userSelect: 'text',
    '--antd-arrow-background-color': colorBgElevated,
    '&-rtl': {
      direction: 'rtl'
    },
    '&-hidden': {
      display: 'none'
    }
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-content"), {
    position: 'relative'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-inner"), {
    backgroundColor: popoverBg,
    backgroundClip: 'padding-box',
    borderRadius: borderRadius,
    boxShadow: boxShadowSecondary,
    padding: popoverPadding
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-title"), {
    minWidth: width,
    marginBottom: marginXS,
    color: colorTextHeading,
    fontWeight: fontWeightStrong
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-inner-content"), {
    color: popoverColor
  }), _extends2))),
  // Arrow Style
  (0, _placementArrow.default)(token, {
    colorBg: 'var(--antd-arrow-background-color)'
  }), // Pure Render
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-pure"), (0, _defineProperty2.default)({
    position: 'relative',
    maxWidth: 'none'
  }, "".concat(componentCls, "-content"), {
    display: 'inline-block'
  }))];
};
var genColorStyle = function genColorStyle(token) {
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, componentCls, _internal.PresetColors.map(function (colorKey) {
    var _$concat$concat;
    var lightColor = token["".concat(colorKey, "-6")];
    return (0, _defineProperty2.default)({}, "&".concat(componentCls, "-").concat(colorKey), (_$concat$concat = {
      '--antd-arrow-background-color': lightColor
    }, (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-inner"), {
      backgroundColor: lightColor
    }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-arrow"), {
      background: 'transparent'
    }), _$concat$concat));
  }));
};
var genWireframeStyle = function genWireframeStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    colorSplit = token.colorSplit,
    paddingSM = token.paddingSM,
    controlHeight = token.controlHeight,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    padding = token.padding;
  var titlePaddingBlockDist = controlHeight - Math.round(fontSize * lineHeight);
  var popoverTitlePaddingBlockTop = titlePaddingBlockDist / 2;
  var popoverTitlePaddingBlockBottom = titlePaddingBlockDist / 2 - lineWidth;
  var popoverPaddingHorizontal = padding;
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls = {}, (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-inner"), {
    padding: 0
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-title"), {
    margin: 0,
    padding: "".concat(popoverTitlePaddingBlockTop, "px ").concat(popoverPaddingHorizontal, "px ").concat(popoverTitlePaddingBlockBottom, "px"),
    borderBottom: "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorSplit)
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-inner-content"), {
    padding: "".concat(paddingSM, "px ").concat(popoverPaddingHorizontal, "px")
  }), _componentCls));
};
var _default = (0, _internal.genComponentStyleHook)('Popover', function (token) {
  var colorBgElevated = token.colorBgElevated,
    colorText = token.colorText,
    wireframe = token.wireframe;
  var popoverToken = (0, _internal.mergeToken)(token, {
    popoverBg: colorBgElevated,
    popoverColor: colorText,
    popoverPadding: 12 // Fixed Value
  });

  return [genBaseStyle(popoverToken), genColorStyle(popoverToken), wireframe && genWireframeStyle(popoverToken), (0, _motion.initZoomMotion)(popoverToken, 'zoom-big')];
}, function (_ref6) {
  var zIndexPopupBase = _ref6.zIndexPopupBase;
  return {
    zIndexPopup: zIndexPopupBase + 30,
    width: 177
  };
});
exports.default = _default;