"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
var genQRCodeStyle = function genQRCodeStyle(token) {
  var _extends2, _ref;
  var componentCls = token.componentCls;
  return _ref = {}, (0, _defineProperty2.default)(_ref, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    padding: token.paddingSM,
    backgroundColor: token.colorWhite,
    borderRadius: token.borderRadiusLG,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit),
    position: 'relative',
    width: '100%',
    height: '100%',
    overflow: 'hidden'
  }, (0, _defineProperty2.default)(_extends2, "& > ".concat(componentCls, "-mask"), (0, _defineProperty2.default)({
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    zIndex: 10,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    width: '100%',
    height: '100%',
    color: token.colorText,
    lineHeight: token.lineHeight,
    background: token.QRCodeMaskBackgroundColor,
    textAlign: 'center'
  }, "& > ".concat(componentCls, "-expired"), {
    color: token.QRCodeExpiredTextColor
  })), (0, _defineProperty2.default)(_extends2, '&-icon', {
    marginBlockEnd: token.marginXS,
    fontSize: token.controlHeight
  }), _extends2))), (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-borderless"), {
    borderColor: 'transparent'
  }), _ref;
};
var _default = (0, _internal.genComponentStyleHook)('QRCode', function (token) {
  return genQRCodeStyle((0, _internal.mergeToken)(token, {
    QRCodeExpiredTextColor: 'rgba(0, 0, 0, 0.88)',
    QRCodeMaskBackgroundColor: 'rgba(255, 255, 255, 0.96)'
  }));
});
exports.default = _default;