"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.radioGroupProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _Radio = _interopRequireDefault(require("./Radio"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _type = require("../_util/type");
var _FormItemContext = require("../form/FormItemContext");
var _context = require("./context");
var _style = _interopRequireDefault(require("./style"));
// CSSINJS

var RadioGroupSizeTypes = ['large', 'default', 'small'];
var radioGroupProps = function radioGroupProps() {
  return {
    prefixCls: String,
    value: _vueTypes.default.any,
    size: (0, _type.stringType)(),
    options: (0, _type.arrayType)(),
    disabled: (0, _type.booleanType)(),
    name: String,
    buttonStyle: (0, _type.stringType)('outline'),
    id: String,
    optionType: (0, _type.stringType)('default'),
    onChange: (0, _type.functionType)(),
    'onUpdate:value': (0, _type.functionType)()
  };
};
exports.radioGroupProps = radioGroupProps;
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ARadioGroup',
  inheritAttrs: false,
  props: radioGroupProps(),
  // emits: ['update:value', 'change'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var _useConfigInject = (0, _useConfigInject2.default)('radio', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    // Style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var stateValue = (0, _vue.ref)(props.value);
    var updatingValue = (0, _vue.ref)(false);
    (0, _vue.watch)(function () {
      return props.value;
    }, function (val) {
      stateValue.value = val;
      updatingValue.value = false;
    });
    var onRadioChange = function onRadioChange(ev) {
      var lastValue = stateValue.value;
      var value = ev.target.value;
      if (!('value' in props)) {
        stateValue.value = value;
      }
      // nextTick for https://github.com/vueComponent/ant-design-vue/issues/1280
      if (!updatingValue.value && value !== lastValue) {
        updatingValue.value = true;
        emit('update:value', value);
        emit('change', ev);
        formItemContext.onFieldChange();
      }
      (0, _vue.nextTick)(function () {
        updatingValue.value = false;
      });
    };
    (0, _context.useProvideRadioGroupContext)({
      onChange: onRadioChange,
      value: stateValue,
      disabled: (0, _vue.computed)(function () {
        return props.disabled;
      }),
      name: (0, _vue.computed)(function () {
        return props.name;
      }),
      optionType: (0, _vue.computed)(function () {
        return props.optionType;
      })
    });
    return function () {
      var _classNames;
      var _a;
      var options = props.options,
        buttonStyle = props.buttonStyle,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id;
      var groupPrefixCls = "".concat(prefixCls.value, "-group");
      var classString = (0, _classNames2.default)(groupPrefixCls, "".concat(groupPrefixCls, "-").concat(buttonStyle), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(groupPrefixCls, "-").concat(size.value), size.value), (0, _defineProperty2.default)(_classNames, "".concat(groupPrefixCls, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value);
      var children = null;
      if (options && options.length > 0) {
        children = options.map(function (option) {
          if (typeof option === 'string' || typeof option === 'number') {
            return (0, _vue.createVNode)(_Radio.default, {
              "key": option,
              "prefixCls": prefixCls.value,
              "disabled": props.disabled,
              "value": option,
              "checked": stateValue.value === option
            }, {
              default: function _default() {
                return [option];
              }
            });
          }
          var value = option.value,
            disabled = option.disabled,
            label = option.label;
          return (0, _vue.createVNode)(_Radio.default, {
            "key": "radio-group-value-options-".concat(value),
            "prefixCls": prefixCls.value,
            "disabled": disabled || props.disabled,
            "value": value,
            "checked": stateValue.value === value
          }, {
            default: function _default() {
              return [label];
            }
          });
        });
      } else {
        children = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
      }
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": classString,
        "id": id
      }), [children]));
    };
  }
});
exports.default = _default2;