"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.radioProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _Checkbox = _interopRequireDefault(require("../vc-checkbox/Checkbox"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _FormItemContext = require("../form/FormItemContext");
var _omit = _interopRequireDefault(require("../_util/omit"));
var _context = require("./context");
var _type = require("../_util/type");
var _style = _interopRequireDefault(require("./style"));
var _DisabledContext = require("../config-provider/DisabledContext");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// CSSINJS

var radioProps = function radioProps() {
  return {
    prefixCls: String,
    checked: (0, _type.booleanType)(),
    disabled: (0, _type.booleanType)(),
    isGroup: (0, _type.booleanType)(),
    value: _vueTypes.default.any,
    name: String,
    id: String,
    autofocus: (0, _type.booleanType)(),
    onChange: (0, _type.functionType)(),
    onFocus: (0, _type.functionType)(),
    onBlur: (0, _type.functionType)(),
    onClick: (0, _type.functionType)(),
    'onUpdate:checked': (0, _type.functionType)(),
    'onUpdate:value': (0, _type.functionType)()
  };
};
exports.radioProps = radioProps;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ARadio',
  inheritAttrs: false,
  props: radioProps(),
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      expose = _ref.expose,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    var radioOptionTypeContext = (0, _context.useInjectRadioOptionTypeContext)();
    var radioGroupContext = (0, _context.useInjectRadioGroupContext)();
    var vcCheckbox = (0, _vue.ref)();
    var _useConfigInject = (0, _useConfigInject2.default)('radio', props),
      radioPrefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      disabled = _useConfigInject.disabled;
    var prefixCls = (0, _vue.computed)(function () {
      return (radioGroupContext === null || radioGroupContext === void 0 ? void 0 : radioGroupContext.optionType.value) === 'button' || radioOptionTypeContext === 'button' ? "".concat(radioPrefixCls.value, "-button") : radioPrefixCls.value;
    });
    var contextDisabled = (0, _DisabledContext.useInjectDisabled)();
    // Style
    var _useStyle = (0, _style.default)(radioPrefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var focus = function focus() {
      vcCheckbox.value.focus();
    };
    var blur = function blur() {
      vcCheckbox.value.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleChange = function handleChange(event) {
      var targetChecked = event.target.checked;
      emit('update:checked', targetChecked);
      emit('update:value', targetChecked);
      emit('change', event);
      formItemContext.onFieldChange();
    };
    var onChange = function onChange(e) {
      emit('change', e);
      if (radioGroupContext && radioGroupContext.onChange) {
        radioGroupContext.onChange(e);
      }
    };
    return function () {
      var _classNames;
      var _a;
      var radioGroup = radioGroupContext;
      var customizePrefixCls = props.prefixCls,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        restProps = __rest(props, ["prefixCls", "id"]);
      var rProps = (0, _extends2.default)((0, _extends2.default)({
        prefixCls: prefixCls.value,
        id: id
      }, (0, _omit.default)(restProps, ['onUpdate:checked', 'onUpdate:value'])), {
        disabled: (_a = disabled.value) !== null && _a !== void 0 ? _a : contextDisabled.value
      });
      if (radioGroup) {
        rProps.name = radioGroup.name.value;
        rProps.onChange = onChange;
        rProps.checked = props.value === radioGroup.value.value;
        rProps.disabled = props.disabled || radioGroup.disabled.value;
      } else {
        rProps.onChange = handleChange;
      }
      var wrapperClassString = (0, _classNames2.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-wrapper"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-wrapper-checked"), rProps.checked), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-wrapper-disabled"), rProps.disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-wrapper-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-wrapper-in-form-item"), formItemInputContext.isFormItemInput), _classNames), attrs.class, hashId.value);
      return wrapSSR((0, _vue.createVNode)("label", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": wrapperClassString
      }), [(0, _vue.createVNode)(_Checkbox.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, rProps), {}, {
        "type": "radio",
        "ref": vcCheckbox
      }), null), slots.default && (0, _vue.createVNode)("span", null, [slots.default()])]));
    };
  }
});
exports.default = _default;