"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _style = require("../../style");
// ============================== Styles ==============================
var antRadioEffect = new _cssinjs.Keyframes('antRadioEffect', {
  '0%': {
    transform: 'scale(1)',
    opacity: 0.5
  },
  '100%': {
    transform: 'scale(1.6)',
    opacity: 0
  }
});
// styles from RadioGroup only
var getGroupRadioStyle = function getGroupRadioStyle(token) {
  var _extends2;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  var groupPrefixCls = "".concat(componentCls, "-group");
  return (0, _defineProperty2.default)({}, groupPrefixCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    display: 'inline-block',
    fontSize: 0
  }, (0, _defineProperty2.default)(_extends2, "&".concat(groupPrefixCls, "-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends2, "".concat(antCls, "-badge ").concat(antCls, "-badge-count"), {
    zIndex: 1
  }), (0, _defineProperty2.default)(_extends2, "> ".concat(antCls, "-badge:not(:first-child) > ").concat(antCls, "-button-wrapper"), {
    borderInlineStart: 'none'
  }), _extends2)));
};
// Styles from radio-wrapper
var getRadioBasicStyle = function getRadioBasicStyle(token) {
  var _$concat3, _extends3;
  var componentCls = token.componentCls,
    radioWrapperMarginRight = token.radioWrapperMarginRight,
    radioCheckedColor = token.radioCheckedColor,
    radioSize = token.radioSize,
    motionDurationSlow = token.motionDurationSlow,
    motionDurationMid = token.motionDurationMid,
    motionEaseInOut = token.motionEaseInOut,
    motionEaseInOutCirc = token.motionEaseInOutCirc,
    radioButtonBg = token.radioButtonBg,
    colorBorder = token.colorBorder,
    lineWidth = token.lineWidth,
    radioDotSize = token.radioDotSize,
    colorBgContainerDisabled = token.colorBgContainerDisabled,
    colorTextDisabled = token.colorTextDisabled,
    paddingXS = token.paddingXS,
    radioDotDisabledColor = token.radioDotDisabledColor,
    lineType = token.lineType,
    radioDotDisabledSize = token.radioDotDisabledSize,
    wireframe = token.wireframe,
    colorWhite = token.colorWhite;
  var radioInnerPrefixCls = "".concat(componentCls, "-inner");
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper"), (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    position: 'relative',
    display: 'inline-flex',
    alignItems: 'baseline',
    marginInlineStart: 0,
    marginInlineEnd: radioWrapperMarginRight,
    cursor: 'pointer'
  }, (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-wrapper-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends3, '&-disabled', {
    cursor: 'not-allowed',
    color: token.colorTextDisabled
  }), (0, _defineProperty2.default)(_extends3, '&::after', {
    display: 'inline-block',
    width: 0,
    overflow: 'hidden',
    content: '"\\a0"'
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-checked::after"), {
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: '100%',
    height: '100%',
    border: "".concat(lineWidth, "px ").concat(lineType, " ").concat(radioCheckedColor),
    borderRadius: '50%',
    visibility: 'hidden',
    animationName: antRadioEffect,
    animationDuration: motionDurationSlow,
    animationTimingFunction: motionEaseInOut,
    animationFillMode: 'both',
    content: '""'
  }), (0, _defineProperty2.default)(_extends3, componentCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), {
    position: 'relative',
    display: 'inline-block',
    outline: 'none',
    cursor: 'pointer',
    alignSelf: 'center'
  })), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-wrapper:hover &,\n        &:hover ").concat(radioInnerPrefixCls), {
    borderColor: radioCheckedColor
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-input:focus-visible + ").concat(radioInnerPrefixCls), (0, _extends4.default)({}, (0, _style.genFocusOutline)(token))), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, ":hover::after, ").concat(componentCls, "-wrapper:hover &::after"), {
    visibility: 'visible'
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-inner"), {
    '&::after': {
      boxSizing: 'border-box',
      position: 'absolute',
      insetBlockStart: '50%',
      insetInlineStart: '50%',
      display: 'block',
      width: radioSize,
      height: radioSize,
      marginBlockStart: radioSize / -2,
      marginInlineStart: radioSize / -2,
      backgroundColor: wireframe ? radioCheckedColor : colorWhite,
      borderBlockStart: 0,
      borderInlineStart: 0,
      borderRadius: radioSize,
      transform: 'scale(0)',
      opacity: 0,
      transition: "all ".concat(motionDurationSlow, " ").concat(motionEaseInOutCirc),
      content: '""'
    },
    boxSizing: 'border-box',
    position: 'relative',
    insetBlockStart: 0,
    insetInlineStart: 0,
    display: 'block',
    width: radioSize,
    height: radioSize,
    backgroundColor: radioButtonBg,
    borderColor: colorBorder,
    borderStyle: 'solid',
    borderWidth: lineWidth,
    borderRadius: '50%',
    transition: "all ".concat(motionDurationMid)
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-input"), {
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineEnd: 0,
    insetBlockEnd: 0,
    insetInlineStart: 0,
    zIndex: 1,
    cursor: 'pointer',
    opacity: 0
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-checked"), (0, _defineProperty2.default)({}, radioInnerPrefixCls, {
    borderColor: radioCheckedColor,
    backgroundColor: wireframe ? radioButtonBg : radioCheckedColor,
    '&::after': {
      transform: "scale(".concat(radioDotSize / radioSize, ")"),
      opacity: 1,
      transition: "all ".concat(motionDurationSlow, " ").concat(motionEaseInOutCirc)
    }
  })), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-disabled"), (_$concat3 = {
    cursor: 'not-allowed'
  }, (0, _defineProperty2.default)(_$concat3, radioInnerPrefixCls, {
    backgroundColor: colorBgContainerDisabled,
    borderColor: colorBorder,
    cursor: 'not-allowed',
    '&::after': {
      backgroundColor: radioDotDisabledColor
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-input"), {
    cursor: 'not-allowed'
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-disabled + span"), {
    color: colorTextDisabled,
    cursor: 'not-allowed'
  }), (0, _defineProperty2.default)(_$concat3, "&".concat(componentCls, "-checked"), (0, _defineProperty2.default)({}, radioInnerPrefixCls, {
    '&::after': {
      transform: "scale(".concat(radioDotDisabledSize / radioSize, ")")
    }
  })), _$concat3)), (0, _defineProperty2.default)(_extends3, "span".concat(componentCls, " + *"), {
    paddingInlineStart: paddingXS,
    paddingInlineEnd: paddingXS
  }), _extends3)));
};
// Styles from radio-button
var getRadioButtonStyle = function getRadioButtonStyle(token) {
  var _$concat4;
  var radioButtonColor = token.radioButtonColor,
    controlHeight = token.controlHeight,
    componentCls = token.componentCls,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    colorBorder = token.colorBorder,
    motionDurationSlow = token.motionDurationSlow,
    motionDurationMid = token.motionDurationMid,
    radioButtonPaddingHorizontal = token.radioButtonPaddingHorizontal,
    fontSize = token.fontSize,
    radioButtonBg = token.radioButtonBg,
    fontSizeLG = token.fontSizeLG,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    paddingXS = token.paddingXS,
    borderRadius = token.borderRadius,
    borderRadiusSM = token.borderRadiusSM,
    borderRadiusLG = token.borderRadiusLG,
    radioCheckedColor = token.radioCheckedColor,
    radioButtonCheckedBg = token.radioButtonCheckedBg,
    radioButtonHoverColor = token.radioButtonHoverColor,
    radioButtonActiveColor = token.radioButtonActiveColor,
    radioSolidCheckedColor = token.radioSolidCheckedColor,
    colorTextDisabled = token.colorTextDisabled,
    colorBgContainerDisabled = token.colorBgContainerDisabled,
    radioDisabledButtonCheckedColor = token.radioDisabledButtonCheckedColor,
    radioDisabledButtonCheckedBg = token.radioDisabledButtonCheckedBg;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-button-wrapper"), (_$concat4 = {
    position: 'relative',
    display: 'inline-block',
    height: controlHeight,
    margin: 0,
    paddingInline: radioButtonPaddingHorizontal,
    paddingBlock: 0,
    color: radioButtonColor,
    fontSize: fontSize,
    lineHeight: "".concat(controlHeight - lineWidth * 2, "px"),
    background: radioButtonBg,
    border: "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorBorder),
    // strange align fix for chrome but works
    // https://gw.alipayobjects.com/zos/rmsportal/VFTfKXJuogBAXcvfAUWJ.gif
    borderBlockStartWidth: lineWidth + 0.02,
    borderInlineStartWidth: 0,
    borderInlineEndWidth: lineWidth,
    cursor: 'pointer',
    transition: ["color ".concat(motionDurationMid), "background ".concat(motionDurationMid), "border-color ".concat(motionDurationMid), "box-shadow ".concat(motionDurationMid)].join(','),
    a: {
      color: radioButtonColor
    }
  }, (0, _defineProperty2.default)(_$concat4, "> ".concat(componentCls, "-button"), {
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    zIndex: -1,
    width: '100%',
    height: '100%'
  }), (0, _defineProperty2.default)(_$concat4, '&:not(:first-child)', {
    '&::before': {
      position: 'absolute',
      insetBlockStart: -lineWidth,
      insetInlineStart: -lineWidth,
      display: 'block',
      boxSizing: 'content-box',
      width: 1,
      height: '100%',
      paddingBlock: lineWidth,
      paddingInline: 0,
      backgroundColor: colorBorder,
      transition: "background-color ".concat(motionDurationSlow),
      content: '""'
    }
  }), (0, _defineProperty2.default)(_$concat4, '&:first-child', {
    borderInlineStart: "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorBorder),
    borderStartStartRadius: borderRadius,
    borderEndStartRadius: borderRadius
  }), (0, _defineProperty2.default)(_$concat4, '&:last-child', {
    borderStartEndRadius: borderRadius,
    borderEndEndRadius: borderRadius
  }), (0, _defineProperty2.default)(_$concat4, '&:first-child:last-child', {
    borderRadius: borderRadius
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-group-large &"), {
    height: controlHeightLG,
    fontSize: fontSizeLG,
    lineHeight: "".concat(controlHeightLG - lineWidth * 2, "px"),
    '&:first-child': {
      borderStartStartRadius: borderRadiusLG,
      borderEndStartRadius: borderRadiusLG
    },
    '&:last-child': {
      borderStartEndRadius: borderRadiusLG,
      borderEndEndRadius: borderRadiusLG
    }
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-group-small &"), {
    height: controlHeightSM,
    paddingInline: paddingXS - lineWidth,
    paddingBlock: 0,
    lineHeight: "".concat(controlHeightSM - lineWidth * 2, "px"),
    '&:first-child': {
      borderStartStartRadius: borderRadiusSM,
      borderEndStartRadius: borderRadiusSM
    },
    '&:last-child': {
      borderStartEndRadius: borderRadiusSM,
      borderEndEndRadius: borderRadiusSM
    }
  }), (0, _defineProperty2.default)(_$concat4, '&:hover', {
    position: 'relative',
    color: radioCheckedColor
  }), (0, _defineProperty2.default)(_$concat4, '&:has(:focus-visible)', (0, _extends4.default)({}, (0, _style.genFocusOutline)(token))), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-inner, input[type='checkbox'], input[type='radio']"), {
    width: 0,
    height: 0,
    opacity: 0,
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_$concat4, "&-checked:not(".concat(componentCls, "-button-wrapper-disabled)"), {
    zIndex: 1,
    color: radioCheckedColor,
    background: radioButtonCheckedBg,
    borderColor: radioCheckedColor,
    '&::before': {
      backgroundColor: radioCheckedColor
    },
    '&:first-child': {
      borderColor: radioCheckedColor
    },
    '&:hover': {
      color: radioButtonHoverColor,
      borderColor: radioButtonHoverColor,
      '&::before': {
        backgroundColor: radioButtonHoverColor
      }
    },
    '&:active': {
      color: radioButtonActiveColor,
      borderColor: radioButtonActiveColor,
      '&::before': {
        backgroundColor: radioButtonActiveColor
      }
    }
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-group-solid &-checked:not(").concat(componentCls, "-button-wrapper-disabled)"), {
    color: radioSolidCheckedColor,
    background: radioCheckedColor,
    borderColor: radioCheckedColor,
    '&:hover': {
      color: radioSolidCheckedColor,
      background: radioButtonHoverColor,
      borderColor: radioButtonHoverColor
    },
    '&:active': {
      color: radioSolidCheckedColor,
      background: radioButtonActiveColor,
      borderColor: radioButtonActiveColor
    }
  }), (0, _defineProperty2.default)(_$concat4, '&-disabled', {
    color: colorTextDisabled,
    backgroundColor: colorBgContainerDisabled,
    borderColor: colorBorder,
    cursor: 'not-allowed',
    '&:first-child, &:hover': {
      color: colorTextDisabled,
      backgroundColor: colorBgContainerDisabled,
      borderColor: colorBorder
    }
  }), (0, _defineProperty2.default)(_$concat4, "&-disabled".concat(componentCls, "-button-wrapper-checked"), {
    color: radioDisabledButtonCheckedColor,
    backgroundColor: radioDisabledButtonCheckedBg,
    borderColor: colorBorder,
    boxShadow: 'none'
  }), _$concat4));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Radio', function (token) {
  var padding = token.padding,
    lineWidth = token.lineWidth,
    controlItemBgActiveDisabled = token.controlItemBgActiveDisabled,
    colorTextDisabled = token.colorTextDisabled,
    colorBgContainer = token.colorBgContainer,
    fontSizeLG = token.fontSizeLG,
    controlOutline = token.controlOutline,
    colorPrimaryHover = token.colorPrimaryHover,
    colorPrimaryActive = token.colorPrimaryActive,
    colorText = token.colorText,
    colorPrimary = token.colorPrimary,
    marginXS = token.marginXS,
    controlOutlineWidth = token.controlOutlineWidth,
    colorTextLightSolid = token.colorTextLightSolid,
    wireframe = token.wireframe;
  // Radio
  var radioFocusShadow = "0 0 0 ".concat(controlOutlineWidth, "px ").concat(controlOutline);
  var radioButtonFocusShadow = radioFocusShadow;
  var radioSize = fontSizeLG;
  var dotPadding = 4; // Fixed value
  var radioDotDisabledSize = radioSize - dotPadding * 2;
  var radioDotSize = wireframe ? radioDotDisabledSize : radioSize - (dotPadding + lineWidth) * 2;
  var radioCheckedColor = colorPrimary;
  // Radio buttons
  var radioButtonColor = colorText;
  var radioButtonHoverColor = colorPrimaryHover;
  var radioButtonActiveColor = colorPrimaryActive;
  var radioButtonPaddingHorizontal = padding - lineWidth;
  var radioDisabledButtonCheckedColor = colorTextDisabled;
  var radioWrapperMarginRight = marginXS;
  var radioToken = (0, _internal.mergeToken)(token, {
    radioFocusShadow: radioFocusShadow,
    radioButtonFocusShadow: radioButtonFocusShadow,
    radioSize: radioSize,
    radioDotSize: radioDotSize,
    radioDotDisabledSize: radioDotDisabledSize,
    radioCheckedColor: radioCheckedColor,
    radioDotDisabledColor: colorTextDisabled,
    radioSolidCheckedColor: colorTextLightSolid,
    radioButtonBg: colorBgContainer,
    radioButtonCheckedBg: colorBgContainer,
    radioButtonColor: radioButtonColor,
    radioButtonHoverColor: radioButtonHoverColor,
    radioButtonActiveColor: radioButtonActiveColor,
    radioButtonPaddingHorizontal: radioButtonPaddingHorizontal,
    radioDisabledButtonCheckedBg: controlItemBgActiveDisabled,
    radioDisabledButtonCheckedColor: radioDisabledButtonCheckedColor,
    radioWrapperMarginRight: radioWrapperMarginRight
  });
  return [getGroupRadioStyle(radioToken), getRadioBasicStyle(radioToken), getRadioButtonStyle(radioToken)];
});
exports.default = _default;