"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
// ============================== Styles ==============================
var genBaseStyle = function genBaseStyle(token) {
  var _ref;
  var componentCls = token.componentCls,
    lineHeightHeading3 = token.lineHeightHeading3,
    iconCls = token.iconCls,
    padding = token.padding,
    paddingXL = token.paddingXL,
    paddingXS = token.paddingXS,
    paddingLG = token.paddingLG,
    marginXS = token.marginXS,
    lineHeight = token.lineHeight;
  return _ref = {}, (0, _defineProperty2.default)(_ref, componentCls, {
    padding: "".concat(paddingLG * 2, "px ").concat(paddingXL, "px"),
    // RTL
    '&-rtl': {
      direction: 'rtl'
    }
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-image"), {
    width: token.imageWidth,
    height: token.imageHeight,
    margin: 'auto'
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-icon"), (0, _defineProperty2.default)({
    marginBottom: paddingLG,
    textAlign: 'center'
  }, "& > ".concat(iconCls), {
    fontSize: token.resultIconFontSize
  })), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-title"), {
    color: token.colorTextHeading,
    fontSize: token.resultTitleFontSize,
    lineHeight: lineHeightHeading3,
    marginBlock: marginXS,
    textAlign: 'center'
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-subtitle"), {
    color: token.colorTextDescription,
    fontSize: token.resultSubtitleFontSize,
    lineHeight: lineHeight,
    textAlign: 'center'
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-content"), {
    marginTop: paddingLG,
    padding: "".concat(paddingLG, "px ").concat(padding * 2.5, "px"),
    backgroundColor: token.colorFillAlter
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, " ").concat(componentCls, "-extra"), {
    margin: token.resultExtraMargin,
    textAlign: 'center',
    '& > *': {
      marginInlineEnd: paddingXS,
      '&:last-child': {
        marginInlineEnd: 0
      }
    }
  }), _ref;
};
var genStatusIconStyle = function genStatusIconStyle(token) {
  var _ref2;
  var componentCls = token.componentCls,
    iconCls = token.iconCls;
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-success ").concat(componentCls, "-icon > ").concat(iconCls), {
    color: token.resultSuccessIconColor
  }), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-error ").concat(componentCls, "-icon > ").concat(iconCls), {
    color: token.resultErrorIconColor
  }), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-info ").concat(componentCls, "-icon > ").concat(iconCls), {
    color: token.resultInfoIconColor
  }), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-warning ").concat(componentCls, "-icon > ").concat(iconCls), {
    color: token.resultWarningIconColor
  }), _ref2;
};
var genResultStyle = function genResultStyle(token) {
  return [genBaseStyle(token), genStatusIconStyle(token)];
};
// ============================== Export ==============================
var getStyle = function getStyle(token) {
  return genResultStyle(token);
};
var _default = (0, _internal.genComponentStyleHook)('Result', function (token) {
  var paddingLG = token.paddingLG,
    fontSizeHeading3 = token.fontSizeHeading3;
  var resultSubtitleFontSize = token.fontSize;
  var resultExtraMargin = "".concat(paddingLG, "px 0 0 0");
  var resultInfoIconColor = token.colorInfo;
  var resultErrorIconColor = token.colorError;
  var resultSuccessIconColor = token.colorSuccess;
  var resultWarningIconColor = token.colorWarning;
  var resultToken = (0, _internal.mergeToken)(token, {
    resultTitleFontSize: fontSizeHeading3,
    resultSubtitleFontSize: resultSubtitleFontSize,
    resultIconFontSize: fontSizeHeading3 * 3,
    resultExtraMargin: resultExtraMargin,
    resultInfoIconColor: resultInfoIconColor,
    resultErrorIconColor: resultErrorIconColor,
    resultSuccessIconColor: resultSuccessIconColor,
    resultWarningIconColor: resultWarningIconColor
  });
  return [getStyle(resultToken)];
}, {
  imageWidth: 250,
  imageHeight: 295
});
exports.default = _default;