"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _class = require("../../vc-util/Dom/class");
var _type = require("../../_util/type");
var calcThumbStyle = function calcThumbStyle(targetElement) {
  return targetElement ? {
    left: targetElement.offsetLeft,
    right: targetElement.parentElement.clientWidth - targetElement.clientWidth - targetElement.offsetLeft,
    width: targetElement.clientWidth
  } : null;
};
var toPX = function toPX(value) {
  return value !== undefined ? "".concat(value, "px") : undefined;
};
var MotionThumb = (0, _vue.defineComponent)({
  props: {
    value: (0, _type.anyType)(),
    getValueIndex: (0, _type.anyType)(),
    prefixCls: (0, _type.anyType)(),
    motionName: (0, _type.anyType)(),
    onMotionStart: (0, _type.anyType)(),
    onMotionEnd: (0, _type.anyType)(),
    direction: (0, _type.anyType)(),
    containerRef: (0, _type.anyType)()
  },
  emits: ['motionStart', 'motionEnd'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit;
    var thumbRef = (0, _vue.ref)();
    // =========================== Effect ===========================
    var findValueElement = function findValueElement(val) {
      var _a;
      var index = props.getValueIndex(val);
      var ele = (_a = props.containerRef.value) === null || _a === void 0 ? void 0 : _a.querySelectorAll(".".concat(props.prefixCls, "-item"))[index];
      return (ele === null || ele === void 0 ? void 0 : ele.offsetParent) && ele;
    };
    var prevStyle = (0, _vue.ref)(null);
    var nextStyle = (0, _vue.ref)(null);
    (0, _vue.watch)(function () {
      return props.value;
    }, function (value, prevValue) {
      var prev = findValueElement(prevValue);
      var next = findValueElement(value);
      var calcPrevStyle = calcThumbStyle(prev);
      var calcNextStyle = calcThumbStyle(next);
      prevStyle.value = calcPrevStyle;
      nextStyle.value = calcNextStyle;
      if (prev && next) {
        emit('motionStart');
      } else {
        emit('motionEnd');
      }
    }, {
      flush: 'post'
    });
    var thumbStart = (0, _vue.computed)(function () {
      var _a, _b;
      return props.direction === 'rtl' ? toPX(-((_a = prevStyle.value) === null || _a === void 0 ? void 0 : _a.right)) : toPX((_b = prevStyle.value) === null || _b === void 0 ? void 0 : _b.left);
    });
    var thumbActive = (0, _vue.computed)(function () {
      var _a, _b;
      return props.direction === 'rtl' ? toPX(-((_a = nextStyle.value) === null || _a === void 0 ? void 0 : _a.right)) : toPX((_b = nextStyle.value) === null || _b === void 0 ? void 0 : _b.left);
    });
    // =========================== Motion ===========================
    var timeid;
    var onAppearStart = function onAppearStart(el) {
      clearTimeout(timeid);
      (0, _vue.nextTick)(function () {
        if (el) {
          el.style.transform = "translateX(var(--thumb-start-left))";
          el.style.width = "var(--thumb-start-width)";
        }
      });
    };
    var onAppearActive = function onAppearActive(el) {
      timeid = setTimeout(function () {
        if (el) {
          (0, _class.addClass)(el, "".concat(props.motionName, "-appear-active"));
          el.style.transform = "translateX(var(--thumb-active-left))";
          el.style.width = "var(--thumb-active-width)";
        }
      });
    };
    var onAppearEnd = function onAppearEnd(el) {
      prevStyle.value = null;
      nextStyle.value = null;
      if (el) {
        el.style.transform = null;
        el.style.width = null;
        (0, _class.removeClass)(el, "".concat(props.motionName, "-appear-active"));
      }
      emit('motionEnd');
    };
    var mergedStyle = (0, _vue.computed)(function () {
      var _a, _b;
      return {
        '--thumb-start-left': thumbStart.value,
        '--thumb-start-width': toPX((_a = prevStyle.value) === null || _a === void 0 ? void 0 : _a.width),
        '--thumb-active-left': thumbActive.value,
        '--thumb-active-width': toPX((_b = nextStyle.value) === null || _b === void 0 ? void 0 : _b.width)
      };
    });
    (0, _vue.onBeforeUnmount)(function () {
      clearTimeout(timeid);
    });
    return function () {
      // It's little ugly which should be refactor when @umi/test update to latest jsdom
      var motionProps = {
        ref: thumbRef,
        style: mergedStyle.value,
        class: ["".concat(props.prefixCls, "-thumb")]
      };
      if (process.env.NODE_ENV === 'test') {
        motionProps['data-test-style'] = JSON.stringify(mergedStyle.value);
      }
      return (0, _vue.createVNode)(_vue.Transition, {
        "appear": true,
        "onBeforeEnter": onAppearStart,
        "onEnter": onAppearActive,
        "onAfterEnter": onAppearEnd
      }, {
        default: function _default() {
          return [!prevStyle.value || !nextStyle.value ? null : (0, _vue.createVNode)("div", motionProps, null)];
        }
      });
    };
  }
});
var _default2 = MotionThumb;
exports.default = _default2;