"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends5 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
// ============================== Mixins ==============================
function getItemDisabledStyle(cls, token) {
  return (0, _defineProperty2.default)({}, "".concat(cls, ", ").concat(cls, ":hover, ").concat(cls, ":focus"), {
    color: token.colorTextDisabled,
    cursor: 'not-allowed'
  });
}
function getItemSelectedStyle(token) {
  return {
    backgroundColor: token.bgColorSelected,
    boxShadow: token.boxShadow
  };
}
var segmentedTextEllipsisCss = (0, _extends5.default)({
  overflow: 'hidden'
}, _style.textEllipsis);
// ============================== Styles ==============================
var genSegmentedStyle = function genSegmentedStyle(token) {
  var _$concat, _$concat2, _$concat3, _extends3;
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    display: 'inline-block',
    padding: token.segmentedContainerPadding,
    color: token.labelColor,
    backgroundColor: token.bgColor,
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut)
  }, (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-group"), {
    position: 'relative',
    display: 'flex',
    alignItems: 'stretch',
    justifyItems: 'flex-start',
    width: '100%'
  }), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-block"), {
    display: 'flex'
  }), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-block ").concat(componentCls, "-item"), {
    flex: 1,
    minWidth: 0
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item"), (_$concat = {
    position: 'relative',
    textAlign: 'center',
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut),
    borderRadius: token.borderRadiusSM,
    '&-selected': (0, _extends5.default)((0, _extends5.default)({}, getItemSelectedStyle(token)), {
      color: token.labelColorHover
    }),
    '&::after': {
      content: '""',
      position: 'absolute',
      width: '100%',
      height: '100%',
      top: 0,
      insetInlineStart: 0,
      borderRadius: 'inherit',
      transition: "background-color ".concat(token.motionDurationMid)
    }
  }, (0, _defineProperty2.default)(_$concat, "&:hover:not(".concat(componentCls, "-item-selected):not(").concat(componentCls, "-item-disabled)"), {
    color: token.labelColorHover,
    '&::after': {
      backgroundColor: token.bgColorHover
    }
  }), (0, _defineProperty2.default)(_$concat, '&-label', (0, _extends5.default)({
    minHeight: token.controlHeight - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeight - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontal, "px")
  }, segmentedTextEllipsisCss)), (0, _defineProperty2.default)(_$concat, '&-icon + *', {
    marginInlineStart: token.marginSM / 2
  }), (0, _defineProperty2.default)(_$concat, '&-input', {
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: 0,
    height: 0,
    opacity: 0,
    pointerEvents: 'none'
  }), _$concat)), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-thumb"), (0, _extends5.default)((0, _extends5.default)({}, getItemSelectedStyle(token)), (0, _defineProperty2.default)({
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: 0,
    height: '100%',
    padding: "".concat(token.paddingXXS, "px 0"),
    borderRadius: token.borderRadiusSM
  }, "& ~ ".concat(componentCls, "-item:not(").concat(componentCls, "-item-selected):not(").concat(componentCls, "-item-disabled)::after"), {
    backgroundColor: 'transparent'
  }))), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-lg"), (_$concat2 = {
    borderRadius: token.borderRadiusLG
  }, (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item-label"), {
    minHeight: token.controlHeightLG - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeightLG - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontal, "px"),
    fontSize: token.fontSizeLG
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item, ").concat(componentCls, "-thumb"), {
    borderRadius: token.borderRadius
  }), _$concat2)), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-sm"), (_$concat3 = {
    borderRadius: token.borderRadiusSM
  }, (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item-label"), {
    minHeight: token.controlHeightSM - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeightSM - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontalSM, "px")
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item, ").concat(componentCls, "-thumb"), {
    borderRadius: token.borderRadiusXS
  }), _$concat3)), _extends3)), getItemDisabledStyle("&-disabled ".concat(componentCls, "-item"), token)), getItemDisabledStyle("".concat(componentCls, "-item-disabled"), token)), (0, _defineProperty2.default)({}, "".concat(componentCls, "-thumb-motion-appear-active"), {
    transition: "transform ".concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut, ", width ").concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut),
    willChange: 'transform, width'
  })));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Segmented', function (token) {
  var lineWidthBold = token.lineWidthBold,
    lineWidth = token.lineWidth,
    colorTextLabel = token.colorTextLabel,
    colorText = token.colorText,
    colorFillSecondary = token.colorFillSecondary,
    colorBgLayout = token.colorBgLayout,
    colorBgElevated = token.colorBgElevated;
  var segmentedToken = (0, _internal.mergeToken)(token, {
    segmentedPaddingHorizontal: token.controlPaddingHorizontal - lineWidth,
    segmentedPaddingHorizontalSM: token.controlPaddingHorizontalSM - lineWidth,
    segmentedContainerPadding: lineWidthBold,
    labelColor: colorTextLabel,
    labelColorHover: colorText,
    bgColor: colorBgLayout,
    bgColorHover: colorFillSecondary,
    bgColorSelected: colorBgElevated
  });
  return [genSegmentedStyle(segmentedToken)];
});
exports.default = _default;