"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _motion = require("../../style/motion");
var _style = require("../../style");
var genItemStyle = function genItemStyle(token) {
  var controlPaddingHorizontal = token.controlPaddingHorizontal;
  return {
    position: 'relative',
    display: 'block',
    minHeight: token.controlHeight,
    padding: "".concat((token.controlHeight - token.fontSize * token.lineHeight) / 2, "px ").concat(controlPaddingHorizontal, "px"),
    color: token.colorText,
    fontWeight: 'normal',
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    boxSizing: 'border-box'
  };
};
var genSingleStyle = function genSingleStyle(token) {
  var _disabled, _option, _extends2;
  var antCls = token.antCls,
    componentCls = token.componentCls;
  var selectItemCls = "".concat(componentCls, "-item");
  return [(0, _defineProperty2.default)({}, "".concat(componentCls, "-dropdown"), (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'absolute',
    top: -9999,
    zIndex: token.zIndexPopup,
    boxSizing: 'border-box',
    padding: token.paddingXXS,
    overflow: 'hidden',
    fontSize: token.fontSize,
    // Fix select render lag of long text in chrome
    // https://github.com/ant-design/ant-design/issues/11456
    // https://github.com/ant-design/ant-design/issues/11843
    fontVariant: 'initial',
    backgroundColor: token.colorBgElevated,
    borderRadius: token.borderRadiusLG,
    outline: 'none',
    boxShadow: token.boxShadowSecondary
  }, (0, _defineProperty2.default)(_extends2, "\n            &".concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-dropdown-placement-bottomLeft,\n            &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-dropdown-placement-bottomLeft\n          "), {
    animationName: _motion.slideUpIn
  }), (0, _defineProperty2.default)(_extends2, "\n            &".concat(antCls, "-slide-up-enter").concat(antCls, "-slide-up-enter-active").concat(componentCls, "-dropdown-placement-topLeft,\n            &").concat(antCls, "-slide-up-appear").concat(antCls, "-slide-up-appear-active").concat(componentCls, "-dropdown-placement-topLeft\n          "), {
    animationName: _motion.slideDownIn
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-dropdown-placement-bottomLeft"), {
    animationName: _motion.slideUpOut
  }), (0, _defineProperty2.default)(_extends2, "&".concat(antCls, "-slide-up-leave").concat(antCls, "-slide-up-leave-active").concat(componentCls, "-dropdown-placement-topLeft"), {
    animationName: _motion.slideDownOut
  }), (0, _defineProperty2.default)(_extends2, '&-hidden', {
    display: 'none'
  }), (0, _defineProperty2.default)(_extends2, '&-empty', {
    color: token.colorTextDisabled
  }), (0, _defineProperty2.default)(_extends2, "".concat(selectItemCls, "-empty"), (0, _extends3.default)((0, _extends3.default)({}, genItemStyle(token)), {
    color: token.colorTextDisabled
  })), (0, _defineProperty2.default)(_extends2, "".concat(selectItemCls), (0, _extends3.default)((0, _extends3.default)({}, genItemStyle(token)), {
    cursor: 'pointer',
    transition: "background ".concat(token.motionDurationSlow, " ease"),
    borderRadius: token.borderRadiusSM,
    // =========== Group ============
    '&-group': {
      color: token.colorTextDescription,
      fontSize: token.fontSizeSM,
      cursor: 'default'
    },
    // =========== Option ===========
    '&-option': (_option = {
      display: 'flex',
      '&-content': (0, _extends3.default)({
        flex: 'auto'
      }, _style.textEllipsis),
      '&-state': {
        flex: 'none'
      }
    }, (0, _defineProperty2.default)(_option, "&-active:not(".concat(selectItemCls, "-option-disabled)"), {
      backgroundColor: token.controlItemBgHover
    }), (0, _defineProperty2.default)(_option, "&-selected:not(".concat(selectItemCls, "-option-disabled)"), (0, _defineProperty2.default)({
      color: token.colorText,
      fontWeight: token.fontWeightStrong,
      backgroundColor: token.controlItemBgActive
    }, "".concat(selectItemCls, "-option-state"), {
      color: token.colorPrimary
    })), (0, _defineProperty2.default)(_option, '&-disabled', (_disabled = {}, (0, _defineProperty2.default)(_disabled, "&".concat(selectItemCls, "-option-selected"), {
      backgroundColor: token.colorBgContainerDisabled
    }), (0, _defineProperty2.default)(_disabled, "color", token.colorTextDisabled), (0, _defineProperty2.default)(_disabled, "cursor", 'not-allowed'), _disabled)), (0, _defineProperty2.default)(_option, '&-grouped', {
      paddingInlineStart: token.controlPaddingHorizontal * 2
    }), _option)
  })), (0, _defineProperty2.default)(_extends2, '&-rtl', {
    direction: 'rtl'
  }), _extends2))),
  // Follow code may reuse in other components
  (0, _motion.initSlideMotion)(token, 'slide-up'), (0, _motion.initSlideMotion)(token, 'slide-down'), (0, _motion.initMoveMotion)(token, 'move-up'), (0, _motion.initMoveMotion)(token, 'move-down')];
};
var _default = genSingleStyle;
exports.default = _default;