"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = genSingleStyle;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _style = require("../../style");
var _internal = require("../../theme/internal");
function genSizeStyle(token, suffix) {
  var _extends2, _$concat, _$concat2, _$concat$concat;
  var componentCls = token.componentCls,
    inputPaddingHorizontalBase = token.inputPaddingHorizontalBase,
    borderRadius = token.borderRadius;
  var selectHeightWithoutBorder = token.controlHeight - token.lineWidth * 2;
  var selectionItemPadding = Math.ceil(token.fontSize * 1.25);
  var suffixCls = suffix ? "".concat(componentCls, "-").concat(suffix) : '';
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-single").concat(suffixCls), (_$concat$concat = {
    fontSize: token.fontSize
  }, (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-selector"), (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    display: 'flex',
    borderRadius: borderRadius
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-selection-search"), {
    position: 'absolute',
    top: 0,
    insetInlineStart: inputPaddingHorizontalBase,
    insetInlineEnd: inputPaddingHorizontalBase,
    bottom: 0,
    '&-input': {
      width: '100%'
    }
  }), (0, _defineProperty2.default)(_extends2, "\n          ".concat(componentCls, "-selection-item,\n          ").concat(componentCls, "-selection-placeholder\n        "), {
    padding: 0,
    lineHeight: "".concat(selectHeightWithoutBorder, "px"),
    transition: "all ".concat(token.motionDurationSlow),
    // Firefox inline-block position calculation is not same as Chrome & Safari. Patch this:
    '@supports (-moz-appearance: meterbar)': {
      lineHeight: "".concat(selectHeightWithoutBorder, "px")
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-selection-item"), {
    position: 'relative',
    userSelect: 'none'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-selection-placeholder"), {
    transition: 'none',
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_extends2, ['&:after', /* For '' value baseline align */"".concat(componentCls, "-selection-item:after"), /* For undefined value baseline align */"".concat(componentCls, "-selection-placeholder:after")].join(','), {
    display: 'inline-block',
    width: 0,
    visibility: 'hidden',
    content: '"\\a0"'
  }), _extends2))), (0, _defineProperty2.default)(_$concat$concat, "\n        &".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-item,\n        &").concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-placeholder\n      "), {
    paddingInlineEnd: selectionItemPadding
  }), (0, _defineProperty2.default)(_$concat$concat, "&".concat(componentCls, "-open ").concat(componentCls, "-selection-item"), {
    color: token.colorTextPlaceholder
  }), (0, _defineProperty2.default)(_$concat$concat, "&:not(".concat(componentCls, "-customize-input)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-selector"), (_$concat = {
    width: '100%',
    height: token.controlHeight,
    padding: "0 ".concat(inputPaddingHorizontalBase, "px")
  }, (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-selection-search-input"), {
    height: selectHeightWithoutBorder
  }), (0, _defineProperty2.default)(_$concat, '&:after', {
    lineHeight: "".concat(selectHeightWithoutBorder, "px")
  }), _$concat))), (0, _defineProperty2.default)(_$concat$concat, "&".concat(componentCls, "-customize-input"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-selector"), (_$concat2 = {
    '&:after': {
      display: 'none'
    }
  }, (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-selection-search"), {
    position: 'static',
    width: '100%'
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-selection-placeholder"), {
    position: 'absolute',
    insetInlineStart: 0,
    insetInlineEnd: 0,
    padding: "0 ".concat(inputPaddingHorizontalBase, "px"),
    '&:after': {
      display: 'none'
    }
  }), _$concat2))), _$concat$concat));
}
function genSingleStyle(token) {
  var _not$concat2;
  var componentCls = token.componentCls;
  var inputPaddingHorizontalSM = token.controlPaddingHorizontalSM - token.lineWidth;
  return [genSizeStyle(token),
  // ======================== Small ========================
  // Shared
  genSizeStyle((0, _internal.mergeToken)(token, {
    controlHeight: token.controlHeightSM,
    borderRadius: token.borderRadiusSM
  }), 'sm'), // padding
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-single").concat(componentCls, "-sm"), (0, _defineProperty2.default)({}, "&:not(".concat(componentCls, "-customize-input)"), (_not$concat2 = {}, (0, _defineProperty2.default)(_not$concat2, "".concat(componentCls, "-selection-search"), {
    insetInlineStart: inputPaddingHorizontalSM,
    insetInlineEnd: inputPaddingHorizontalSM
  }), (0, _defineProperty2.default)(_not$concat2, "".concat(componentCls, "-selector"), {
    padding: "0 ".concat(inputPaddingHorizontalSM, "px")
  }), (0, _defineProperty2.default)(_not$concat2, "&".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-search"), {
    insetInlineEnd: inputPaddingHorizontalSM + token.fontSize * 1.5
  }), (0, _defineProperty2.default)(_not$concat2, "\n            &".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-item,\n            &").concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-placeholder\n          "), {
    paddingInlineEnd: token.fontSize * 1.5
  }), _not$concat2))),
  // ======================== Large ========================
  // Shared
  genSizeStyle((0, _internal.mergeToken)(token, {
    controlHeight: token.controlHeightLG,
    fontSize: token.fontSizeLG,
    borderRadius: token.borderRadiusLG
  }), 'lg')];
}