"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _tinycolor = require("@ctrl/tinycolor");
var _internal = require("../../theme/internal");
var _style = require("../../style");
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _hover, _$concat, _$concat2, _extends2;
  var componentCls = token.componentCls,
    controlSize = token.controlSize,
    dotSize = token.dotSize,
    marginFull = token.marginFull,
    marginPart = token.marginPart,
    colorFillContentHover = token.colorFillContentHover;
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'relative',
    height: controlSize,
    margin: "".concat(marginPart, "px ").concat(marginFull, "px"),
    padding: 0,
    cursor: 'pointer',
    touchAction: 'none'
  }, (0, _defineProperty2.default)(_extends2, "&-vertical", {
    margin: "".concat(marginFull, "px ").concat(marginPart, "px")
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-rail"), {
    position: 'absolute',
    backgroundColor: token.colorFillTertiary,
    borderRadius: token.borderRadiusXS,
    transition: "background-color ".concat(token.motionDurationMid)
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-track"), {
    position: 'absolute',
    backgroundColor: token.colorPrimaryBorder,
    borderRadius: token.borderRadiusXS,
    transition: "background-color ".concat(token.motionDurationMid)
  }), (0, _defineProperty2.default)(_extends2, '&:hover', (_hover = {}, (0, _defineProperty2.default)(_hover, "".concat(componentCls, "-rail"), {
    backgroundColor: token.colorFillSecondary
  }), (0, _defineProperty2.default)(_hover, "".concat(componentCls, "-track"), {
    backgroundColor: token.colorPrimaryBorderHover
  }), (0, _defineProperty2.default)(_hover, "".concat(componentCls, "-dot"), {
    borderColor: colorFillContentHover
  }), (0, _defineProperty2.default)(_hover, "".concat(componentCls, "-handle::after"), {
    boxShadow: "0 0 0 ".concat(token.handleLineWidth, "px ").concat(token.colorPrimaryBorderHover)
  }), (0, _defineProperty2.default)(_hover, "".concat(componentCls, "-dot-active"), {
    borderColor: token.colorPrimary
  }), _hover)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-handle"), (_$concat = {
    position: 'absolute',
    width: token.handleSize,
    height: token.handleSize,
    outline: 'none'
  }, (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-dragging"), {
    zIndex: 1
  }), (0, _defineProperty2.default)(_$concat, '&::before', {
    content: '""',
    position: 'absolute',
    insetInlineStart: -token.handleLineWidth,
    insetBlockStart: -token.handleLineWidth,
    width: token.handleSize + token.handleLineWidth * 2,
    height: token.handleSize + token.handleLineWidth * 2,
    backgroundColor: 'transparent'
  }), (0, _defineProperty2.default)(_$concat, '&::after', {
    content: '""',
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: token.handleSize,
    height: token.handleSize,
    backgroundColor: token.colorBgElevated,
    boxShadow: "0 0 0 ".concat(token.handleLineWidth, "px ").concat(token.colorPrimaryBorder),
    borderRadius: '50%',
    cursor: 'pointer',
    transition: "\n            inset-inline-start ".concat(token.motionDurationMid, ",\n            inset-block-start ").concat(token.motionDurationMid, ",\n            width ").concat(token.motionDurationMid, ",\n            height ").concat(token.motionDurationMid, ",\n            box-shadow ").concat(token.motionDurationMid, "\n          ")
  }), (0, _defineProperty2.default)(_$concat, '&:hover, &:active, &:focus', {
    '&::before': {
      insetInlineStart: -((token.handleSizeHover - token.handleSize) / 2 + token.handleLineWidthHover),
      insetBlockStart: -((token.handleSizeHover - token.handleSize) / 2 + token.handleLineWidthHover),
      width: token.handleSizeHover + token.handleLineWidthHover * 2,
      height: token.handleSizeHover + token.handleLineWidthHover * 2
    },
    '&::after': {
      boxShadow: "0 0 0 ".concat(token.handleLineWidthHover, "px ").concat(token.colorPrimary),
      width: token.handleSizeHover,
      height: token.handleSizeHover,
      insetInlineStart: (token.handleSize - token.handleSizeHover) / 2,
      insetBlockStart: (token.handleSize - token.handleSizeHover) / 2
    }
  }), _$concat)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-mark"), {
    position: 'absolute',
    fontSize: token.fontSize
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-mark-text"), {
    position: 'absolute',
    display: 'inline-block',
    color: token.colorTextDescription,
    textAlign: 'center',
    wordBreak: 'keep-all',
    cursor: 'pointer',
    userSelect: 'none',
    '&-active': {
      color: token.colorText
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-step"), {
    position: 'absolute',
    background: 'transparent',
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-dot"), {
    position: 'absolute',
    width: dotSize,
    height: dotSize,
    backgroundColor: token.colorBgElevated,
    border: "".concat(token.handleLineWidth, "px solid ").concat(token.colorBorderSecondary),
    borderRadius: '50%',
    cursor: 'pointer',
    transition: "border-color ".concat(token.motionDurationSlow),
    '&-active': {
      borderColor: token.colorPrimaryBorder
    }
  }), (0, _defineProperty2.default)(_extends2, "&".concat(componentCls, "-disabled"), (_$concat2 = {
    cursor: 'not-allowed'
  }, (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-rail"), {
    backgroundColor: "".concat(token.colorFillSecondary, " !important")
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-track"), {
    backgroundColor: "".concat(token.colorTextDisabled, " !important")
  }), (0, _defineProperty2.default)(_$concat2, "\n          ".concat(componentCls, "-dot\n        "), {
    backgroundColor: token.colorBgElevated,
    borderColor: token.colorTextDisabled,
    boxShadow: 'none',
    cursor: 'not-allowed'
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-handle::after"), {
    backgroundColor: token.colorBgElevated,
    cursor: 'not-allowed',
    width: token.handleSize,
    height: token.handleSize,
    boxShadow: "0 0 0 ".concat(token.handleLineWidth, "px ").concat(new _tinycolor.TinyColor(token.colorTextDisabled).onBackground(token.colorBgContainer).toHexString()),
    insetInlineStart: 0,
    insetBlockStart: 0
  }), (0, _defineProperty2.default)(_$concat2, "\n          ".concat(componentCls, "-mark-text,\n          ").concat(componentCls, "-dot\n        "), {
    cursor: "not-allowed !important"
  }), _$concat2)), _extends2)));
};
// ============================ Horizontal ============================
var genDirectionStyle = function genDirectionStyle(token, horizontal) {
  var _$concat3, _$concat6, _$concat7, _ref2;
  var componentCls = token.componentCls,
    railSize = token.railSize,
    handleSize = token.handleSize,
    dotSize = token.dotSize;
  var railPadding = horizontal ? 'paddingBlock' : 'paddingInline';
  var full = horizontal ? 'width' : 'height';
  var part = horizontal ? 'height' : 'width';
  var handlePos = horizontal ? 'insetBlockStart' : 'insetInlineStart';
  var markInset = horizontal ? 'top' : 'insetInlineStart';
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, railPadding, railSize), (0, _defineProperty2.default)(_ref2, part, railSize * 3), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-rail"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, full, '100%'), (0, _defineProperty2.default)(_$concat3, part, railSize), _$concat3)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-track"), (0, _defineProperty2.default)({}, part, railSize)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-handle"), (0, _defineProperty2.default)({}, handlePos, (railSize * 3 - handleSize) / 2)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-mark"), (_$concat6 = {
    // Reset all
    insetInlineStart: 0,
    top: 0
  }, (0, _defineProperty2.default)(_$concat6, markInset, handleSize), (0, _defineProperty2.default)(_$concat6, full, '100%'), _$concat6)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-step"), (_$concat7 = {
    // Reset all
    insetInlineStart: 0,
    top: 0
  }, (0, _defineProperty2.default)(_$concat7, markInset, railSize), (0, _defineProperty2.default)(_$concat7, full, '100%'), (0, _defineProperty2.default)(_$concat7, part, railSize), _$concat7)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-dot"), (0, _defineProperty2.default)({
    position: 'absolute'
  }, handlePos, (railSize - dotSize) / 2)), _ref2;
};
// ============================ Horizontal ============================
var genHorizontalStyle = function genHorizontalStyle(token) {
  var componentCls = token.componentCls,
    marginPartWithMark = token.marginPartWithMark;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-horizontal"), (0, _extends4.default)((0, _extends4.default)({}, genDirectionStyle(token, true)), (0, _defineProperty2.default)({}, "&".concat(componentCls, "-with-marks"), {
    marginBottom: marginPartWithMark
  })));
};
// ============================= Vertical =============================
var genVerticalStyle = function genVerticalStyle(token) {
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-vertical"), (0, _extends4.default)((0, _extends4.default)({}, genDirectionStyle(token, false)), {
    height: '100%'
  }));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Slider', function (token) {
  var sliderToken = (0, _internal.mergeToken)(token, {
    marginPart: (token.controlHeight - token.controlSize) / 2,
    marginFull: token.controlSize / 2,
    marginPartWithMark: token.controlHeightLG - token.controlSize
  });
  return [genBaseStyle(sliderToken), genHorizontalStyle(sliderToken), genVerticalStyle(sliderToken)];
}, function (token) {
  // Handle line width is always width-er 1px
  var increaseHandleWidth = 1;
  var controlSize = token.controlHeightLG / 4;
  var controlSizeHover = token.controlHeightSM / 2;
  var handleLineWidth = token.lineWidth + increaseHandleWidth;
  var handleLineWidthHover = token.lineWidth + increaseHandleWidth * 3;
  return {
    controlSize: controlSize,
    railSize: 4,
    handleSize: controlSize,
    handleSizeHover: controlSizeHover,
    dotSize: 8,
    handleLineWidth: handleLineWidth,
    handleLineWidthHover: handleLineWidthHover
  };
});
exports.default = _default;