"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.setDefaultIndicator = setDefaultIndicator;
exports.spinProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _throttleDebounce = require("throttle-debounce");
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _propsUtil = require("../_util/props-util");
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _style = _interopRequireDefault(require("./style"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var spinProps = function spinProps() {
  return {
    prefixCls: String,
    spinning: {
      type: Boolean,
      default: undefined
    },
    size: String,
    wrapperClassName: String,
    tip: _vueTypes.default.any,
    delay: Number,
    indicator: _vueTypes.default.any
  };
};
// Render indicator
exports.spinProps = spinProps;
var defaultIndicator = null;
function shouldDelay(spinning, delay) {
  return !!spinning && !!delay && !isNaN(Number(delay));
}
function setDefaultIndicator(Content) {
  var Indicator = Content.indicator;
  defaultIndicator = typeof Indicator === 'function' ? Indicator : function () {
    return (0, _vue.createVNode)(Indicator, null, null);
  };
}
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ASpin',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(spinProps(), {
    size: 'default',
    spinning: true,
    wrapperClassName: ''
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = (0, _useConfigInject2.default)('spin', props),
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var sSpinning = (0, _vue.shallowRef)(props.spinning && !shouldDelay(props.spinning, props.delay));
    var updateSpinning;
    (0, _vue.watch)([function () {
      return props.spinning;
    }, function () {
      return props.delay;
    }], function () {
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning.cancel();
      updateSpinning = (0, _throttleDebounce.debounce)(props.delay, function () {
        sSpinning.value = props.spinning;
      });
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning();
    }, {
      immediate: true,
      flush: 'post'
    });
    (0, _vue.onBeforeUnmount)(function () {
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning.cancel();
    });
    return function () {
      var _spinClassName;
      var _a, _b;
      var cls = attrs.class,
        divProps = __rest(attrs, ["class"]);
      var _props$tip = props.tip,
        tip = _props$tip === void 0 ? (_a = slots.tip) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$tip;
      var children = (_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots);
      var spinClassName = (_spinClassName = {}, (0, _defineProperty2.default)(_spinClassName, hashId.value, true), (0, _defineProperty2.default)(_spinClassName, prefixCls.value, true), (0, _defineProperty2.default)(_spinClassName, "".concat(prefixCls.value, "-sm"), size.value === 'small'), (0, _defineProperty2.default)(_spinClassName, "".concat(prefixCls.value, "-lg"), size.value === 'large'), (0, _defineProperty2.default)(_spinClassName, "".concat(prefixCls.value, "-spinning"), sSpinning.value), (0, _defineProperty2.default)(_spinClassName, "".concat(prefixCls.value, "-show-text"), !!tip), (0, _defineProperty2.default)(_spinClassName, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_spinClassName, cls, !!cls), _spinClassName);
      function renderIndicator(prefixCls) {
        var dotClassName = "".concat(prefixCls, "-dot");
        var indicator = (0, _propsUtil.getPropsSlot)(slots, props, 'indicator');
        // should not be render default indicator when indicator value is null
        if (indicator === null) {
          return null;
        }
        if (Array.isArray(indicator)) {
          indicator = indicator.length === 1 ? indicator[0] : indicator;
        }
        if ((0, _vue.isVNode)(indicator)) {
          return (0, _vue.cloneVNode)(indicator, {
            class: dotClassName
          });
        }
        if (defaultIndicator && (0, _vue.isVNode)(defaultIndicator())) {
          return (0, _vue.cloneVNode)(defaultIndicator(), {
            class: dotClassName
          });
        }
        return (0, _vue.createVNode)("span", {
          "class": "".concat(dotClassName, " ").concat(prefixCls, "-dot-spin")
        }, [(0, _vue.createVNode)("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), (0, _vue.createVNode)("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), (0, _vue.createVNode)("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), (0, _vue.createVNode)("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null)]);
      }
      var spinElement = (0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, divProps), {}, {
        "class": spinClassName,
        "aria-live": "polite",
        "aria-busy": sSpinning.value
      }), [renderIndicator(prefixCls.value), tip ? (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-text")
      }, [tip]) : null]);
      if (children && (0, _propsUtil.filterEmpty)(children).length) {
        var _containerClassName;
        var containerClassName = (_containerClassName = {}, (0, _defineProperty2.default)(_containerClassName, "".concat(prefixCls.value, "-container"), true), (0, _defineProperty2.default)(_containerClassName, "".concat(prefixCls.value, "-blur"), sSpinning.value), _containerClassName);
        return wrapSSR((0, _vue.createVNode)("div", {
          "class": ["".concat(prefixCls.value, "-nested-loading"), props.wrapperClassName, hashId.value]
        }, [sSpinning.value && (0, _vue.createVNode)("div", {
          "key": "loading"
        }, [spinElement]), (0, _vue.createVNode)("div", {
          "class": containerClassName,
          "key": "container"
        }, [children])]));
      }
      return wrapSSR(spinElement);
    };
  }
});
exports.default = _default;