"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends5 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var _customIcon = _interopRequireDefault(require("./custom-icon"));
var _labelPlacement = _interopRequireDefault(require("./label-placement"));
var _nav = _interopRequireDefault(require("./nav"));
var _progress = _interopRequireDefault(require("./progress"));
var _progressDot = _interopRequireDefault(require("./progress-dot"));
var _rtl = _interopRequireDefault(require("./rtl"));
var _small = _interopRequireDefault(require("./small"));
var _vertical = _interopRequireDefault(require("./vertical"));
var _inline = _interopRequireDefault(require("./inline"));
var _style = require("../../style");
var StepItemStatusEnum;
(function (StepItemStatusEnum) {
  StepItemStatusEnum["wait"] = "wait";
  StepItemStatusEnum["process"] = "process";
  StepItemStatusEnum["finish"] = "finish";
  StepItemStatusEnum["error"] = "error";
})(StepItemStatusEnum || (StepItemStatusEnum = {}));
var genStepsItemStatusStyle = function genStepsItemStatusStyle(status, token) {
  var _ref;
  var prefix = "".concat(token.componentCls, "-item");
  var iconColorKey = "".concat(status, "IconColor");
  var titleColorKey = "".concat(status, "TitleColor");
  var descriptionColorKey = "".concat(status, "DescriptionColor");
  var tailColorKey = "".concat(status, "TailColor");
  var iconBgColorKey = "".concat(status, "IconBgColor");
  var iconBorderColorKey = "".concat(status, "IconBorderColor");
  var dotColorKey = "".concat(status, "DotColor");
  return _ref = {}, (0, _defineProperty2.default)(_ref, "".concat(prefix, "-").concat(status, " ").concat(prefix, "-icon"), (0, _defineProperty2.default)({
    backgroundColor: token[iconBgColorKey],
    borderColor: token[iconBorderColorKey]
  }, "> ".concat(token.componentCls, "-icon"), (0, _defineProperty2.default)({
    color: token[iconColorKey]
  }, "".concat(token.componentCls, "-icon-dot"), {
    background: token[dotColorKey]
  }))), (0, _defineProperty2.default)(_ref, "".concat(prefix, "-").concat(status).concat(prefix, "-custom ").concat(prefix, "-icon"), (0, _defineProperty2.default)({}, "> ".concat(token.componentCls, "-icon"), {
    color: token[dotColorKey]
  })), (0, _defineProperty2.default)(_ref, "".concat(prefix, "-").concat(status, " > ").concat(prefix, "-container > ").concat(prefix, "-content > ").concat(prefix, "-title"), {
    color: token[titleColorKey],
    '&::after': {
      backgroundColor: token[tailColorKey]
    }
  }), (0, _defineProperty2.default)(_ref, "".concat(prefix, "-").concat(status, " > ").concat(prefix, "-container > ").concat(prefix, "-content > ").concat(prefix, "-description"), {
    color: token[descriptionColorKey]
  }), (0, _defineProperty2.default)(_ref, "".concat(prefix, "-").concat(status, " > ").concat(prefix, "-container > ").concat(prefix, "-tail::after"), {
    backgroundColor: token[tailColorKey]
  }), _ref;
};
var genStepsItemStyle = function genStepsItemStyle(token) {
  var _extends2, _extends4;
  var componentCls = token.componentCls,
    motionDurationSlow = token.motionDurationSlow;
  var stepsItemCls = "".concat(componentCls, "-item"); // .ant-steps-item
  return (0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((_extends2 = {}, (0, _defineProperty2.default)(_extends2, stepsItemCls, {
    position: 'relative',
    display: 'inline-block',
    flex: 1,
    overflow: 'hidden',
    verticalAlign: 'top',
    '&:last-child': (0, _defineProperty2.default)({
      flex: 'none'
    }, "> ".concat(stepsItemCls, "-container > ").concat(stepsItemCls, "-tail, > ").concat(stepsItemCls, "-container >  ").concat(stepsItemCls, "-content > ").concat(stepsItemCls, "-title::after"), {
      display: 'none'
    })
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-container"), {
    outline: 'none'
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-icon, ").concat(stepsItemCls, "-content"), {
    display: 'inline-block',
    verticalAlign: 'top'
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-icon"), (0, _defineProperty2.default)({
    width: token.stepsIconSize,
    height: token.stepsIconSize,
    marginTop: 0,
    marginBottom: 0,
    marginInlineStart: 0,
    marginInlineEnd: token.marginXS,
    fontSize: token.stepsIconFontSize,
    fontFamily: token.fontFamily,
    lineHeight: "".concat(token.stepsIconSize, "px"),
    textAlign: 'center',
    borderRadius: token.stepsIconSize,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    transition: "background-color ".concat(motionDurationSlow, ", border-color ").concat(motionDurationSlow)
  }, "".concat(componentCls, "-icon"), {
    position: 'relative',
    top: token.stepsIconTop,
    color: token.colorPrimary,
    lineHeight: 1
  })), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-tail"), {
    position: 'absolute',
    top: token.stepsIconSize / 2 - token.paddingXXS,
    insetInlineStart: 0,
    width: '100%',
    '&::after': {
      display: 'inline-block',
      width: '100%',
      height: token.lineWidth,
      background: token.colorSplit,
      borderRadius: token.lineWidth,
      transition: "background ".concat(motionDurationSlow),
      content: '""'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-title"), {
    position: 'relative',
    display: 'inline-block',
    paddingInlineEnd: token.padding,
    color: token.colorText,
    fontSize: token.fontSizeLG,
    lineHeight: "".concat(token.stepsTitleLineHeight, "px"),
    '&::after': {
      position: 'absolute',
      top: token.stepsTitleLineHeight / 2,
      insetInlineStart: '100%',
      display: 'block',
      width: 9999,
      height: token.lineWidth,
      background: token.processTailColor,
      content: '""'
    }
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-subtitle"), {
    display: 'inline',
    marginInlineStart: token.marginXS,
    color: token.colorTextDescription,
    fontWeight: 'normal',
    fontSize: token.fontSize
  }), (0, _defineProperty2.default)(_extends2, "".concat(stepsItemCls, "-description"), {
    color: token.colorTextDescription,
    fontSize: token.fontSize
  }), _extends2), genStepsItemStatusStyle(StepItemStatusEnum.wait, token)), genStepsItemStatusStyle(StepItemStatusEnum.process, token)), (0, _defineProperty2.default)({}, "".concat(stepsItemCls, "-process > ").concat(stepsItemCls, "-container > ").concat(stepsItemCls, "-title"), {
    fontWeight: token.fontWeightStrong
  })), genStepsItemStatusStyle(StepItemStatusEnum.finish, token)), genStepsItemStatusStyle(StepItemStatusEnum.error, token)), (_extends4 = {}, (0, _defineProperty2.default)(_extends4, "".concat(stepsItemCls).concat(componentCls, "-next-error > ").concat(componentCls, "-item-title::after"), {
    background: token.colorError
  }), (0, _defineProperty2.default)(_extends4, "".concat(stepsItemCls, "-disabled"), {
    cursor: 'not-allowed'
  }), _extends4));
};
// ============================= Clickable ===========================
var genStepsClickableStyle = function genStepsClickableStyle(token) {
  var _$concat5, _not$concat2, _$concat8, _ref2;
  var componentCls = token.componentCls,
    motionDurationSlow = token.motionDurationSlow;
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "& ".concat(componentCls, "-item"), (0, _defineProperty2.default)({}, "&:not(".concat(componentCls, "-item-active)"), (_not$concat2 = {}, (0, _defineProperty2.default)(_not$concat2, "& > ".concat(componentCls, "-item-container[role='button']"), (_$concat5 = {
    cursor: 'pointer'
  }, (0, _defineProperty2.default)(_$concat5, "".concat(componentCls, "-item"), (0, _defineProperty2.default)({}, "&-title, &-subtitle, &-description, &-icon ".concat(componentCls, "-icon"), {
    transition: "color ".concat(motionDurationSlow)
  })), (0, _defineProperty2.default)(_$concat5, '&:hover', (0, _defineProperty2.default)({}, "".concat(componentCls, "-item"), (0, _defineProperty2.default)({}, "&-title, &-subtitle, &-description", {
    color: token.colorPrimary
  }))), _$concat5)), (0, _defineProperty2.default)(_not$concat2, "&:not(".concat(componentCls, "-item-process)"), (0, _defineProperty2.default)({}, "& > ".concat(componentCls, "-item-container[role='button']:hover"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item"), {
    '&-icon': (0, _defineProperty2.default)({
      borderColor: token.colorPrimary
    }, "".concat(componentCls, "-icon"), {
      color: token.colorPrimary
    })
  }))), _not$concat2))), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-horizontal:not(").concat(componentCls, "-label-vertical)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item"), (_$concat8 = {
    paddingInlineStart: token.padding,
    whiteSpace: 'nowrap',
    '&:first-child': {
      paddingInlineStart: 0
    }
  }, (0, _defineProperty2.default)(_$concat8, "&:last-child ".concat(componentCls, "-item-title"), {
    paddingInlineEnd: 0
  }), (0, _defineProperty2.default)(_$concat8, '&-tail', {
    display: 'none'
  }), (0, _defineProperty2.default)(_$concat8, '&-description', {
    maxWidth: token.descriptionWidth,
    whiteSpace: 'normal'
  }), _$concat8))), _ref2;
};
var genStepsStyle = function genStepsStyle(token) {
  var componentCls = token.componentCls; // .ant-steps
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)({}, (0, _style.resetComponent)(token)), {
    display: 'flex',
    width: '100%',
    fontSize: 0,
    textAlign: 'initial'
  }), genStepsItemStyle(token)), genStepsClickableStyle(token)), (0, _customIcon.default)(token)), (0, _small.default)(token)), (0, _vertical.default)(token)), (0, _labelPlacement.default)(token)), (0, _progressDot.default)(token)), (0, _nav.default)(token)), (0, _rtl.default)(token)), (0, _progress.default)(token)), (0, _inline.default)(token)));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Steps', function (token) {
  var wireframe = token.wireframe,
    colorTextDisabled = token.colorTextDisabled,
    fontSizeHeading3 = token.fontSizeHeading3,
    fontSize = token.fontSize,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    colorTextLightSolid = token.colorTextLightSolid,
    colorText = token.colorText,
    colorPrimary = token.colorPrimary,
    colorTextLabel = token.colorTextLabel,
    colorTextDescription = token.colorTextDescription,
    colorTextQuaternary = token.colorTextQuaternary,
    colorFillContent = token.colorFillContent,
    controlItemBgActive = token.controlItemBgActive,
    colorError = token.colorError,
    colorBgContainer = token.colorBgContainer,
    colorBorderSecondary = token.colorBorderSecondary;
  var stepsIconSize = token.controlHeight;
  var processTailColor = token.colorSplit;
  var stepsToken = (0, _internal.mergeToken)(token, {
    // Steps variable default.less
    processTailColor: processTailColor,
    stepsNavArrowColor: colorTextDisabled,
    stepsIconSize: stepsIconSize,
    stepsIconCustomSize: stepsIconSize,
    stepsIconCustomTop: 0,
    stepsIconCustomFontSize: controlHeightLG / 2,
    stepsIconTop: -0.5,
    stepsIconFontSize: fontSize,
    stepsTitleLineHeight: controlHeight,
    stepsSmallIconSize: fontSizeHeading3,
    stepsDotSize: controlHeight / 4,
    stepsCurrentDotSize: controlHeightLG / 4,
    stepsNavContentMaxWidth: 'auto',
    // Steps component less variable
    processIconColor: colorTextLightSolid,
    processTitleColor: colorText,
    processDescriptionColor: colorText,
    processIconBgColor: colorPrimary,
    processIconBorderColor: colorPrimary,
    processDotColor: colorPrimary,
    waitIconColor: wireframe ? colorTextDisabled : colorTextLabel,
    waitTitleColor: colorTextDescription,
    waitDescriptionColor: colorTextDescription,
    waitTailColor: processTailColor,
    waitIconBgColor: wireframe ? colorBgContainer : colorFillContent,
    waitIconBorderColor: wireframe ? colorTextDisabled : 'transparent',
    waitDotColor: colorTextDisabled,
    finishIconColor: colorPrimary,
    finishTitleColor: colorText,
    finishDescriptionColor: colorTextDescription,
    finishTailColor: colorPrimary,
    finishIconBgColor: wireframe ? colorBgContainer : controlItemBgActive,
    finishIconBorderColor: wireframe ? colorPrimary : controlItemBgActive,
    finishDotColor: colorPrimary,
    errorIconColor: colorTextLightSolid,
    errorTitleColor: colorError,
    errorDescriptionColor: colorError,
    errorTailColor: processTailColor,
    errorIconBgColor: colorError,
    errorIconBorderColor: colorError,
    errorDotColor: colorError,
    stepsNavActiveColor: colorPrimary,
    stepsProgressSize: controlHeightLG,
    // Steps inline variable
    inlineDotSize: 6,
    inlineTitleColor: colorTextQuaternary,
    inlineTailColor: colorBorderSecondary
  });
  return [genStepsStyle(stepsToken)];
}, {
  descriptionWidth: 140
});
exports.default = _default;