"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genCompactItemStyle = genCompactItemStyle;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
// handle border collapse
function compactItemBorder(token, parentCls, options) {
  var _ref2;
  var focusElCls = options.focusElCls,
    focus = options.focus,
    borderElCls = options.borderElCls;
  var childCombinator = borderElCls ? '> *' : '';
  var hoverEffects = ['hover', focus ? 'focus' : null, 'active'].filter(Boolean).map(function (n) {
    return "&:".concat(n, " ").concat(childCombinator);
  }).join(',');
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "&-item:not(".concat(parentCls, "-last-item)"), {
    marginInlineEnd: -token.lineWidth
  }), (0, _defineProperty2.default)(_ref2, '&-item', (0, _extends4.default)((0, _extends4.default)((0, _defineProperty2.default)({}, hoverEffects, {
    zIndex: 2
  }), focusElCls ? (0, _defineProperty2.default)({}, "&".concat(focusElCls), {
    zIndex: 2
  }) : {}), (0, _defineProperty2.default)({}, "&[disabled] ".concat(childCombinator), {
    zIndex: 0
  }))), _ref2;
}
// handle border-radius
function compactItemBorderRadius(prefixCls, parentCls, options) {
  var _ref3;
  var borderElCls = options.borderElCls;
  var childCombinator = borderElCls ? "> ".concat(borderElCls) : '';
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "&-item:not(".concat(parentCls, "-first-item):not(").concat(parentCls, "-last-item) ").concat(childCombinator), {
    borderRadius: 0
  }), (0, _defineProperty2.default)(_ref3, "&-item:not(".concat(parentCls, "-last-item)").concat(parentCls, "-first-item"), (0, _defineProperty2.default)({}, "& ".concat(childCombinator, ", &").concat(prefixCls, "-sm ").concat(childCombinator, ", &").concat(prefixCls, "-lg ").concat(childCombinator), {
    borderStartEndRadius: 0,
    borderEndEndRadius: 0
  })), (0, _defineProperty2.default)(_ref3, "&-item:not(".concat(parentCls, "-first-item)").concat(parentCls, "-last-item"), (0, _defineProperty2.default)({}, "& ".concat(childCombinator, ", &").concat(prefixCls, "-sm ").concat(childCombinator, ", &").concat(prefixCls, "-lg ").concat(childCombinator), {
    borderStartStartRadius: 0,
    borderEndStartRadius: 0
  })), _ref3;
}
function genCompactItemStyle(token) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    focus: true
  };
  var componentCls = token.componentCls;
  var compactCls = "".concat(componentCls, "-compact");
  return (0, _defineProperty2.default)({}, compactCls, (0, _extends4.default)((0, _extends4.default)({}, compactItemBorder(token, compactCls, options)), compactItemBorderRadius(componentCls, compactCls, options)));
}