"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zoomUpOut = exports.zoomUpIn = exports.zoomRightOut = exports.zoomRightIn = exports.zoomOut = exports.zoomLeftOut = exports.zoomLeftIn = exports.zoomIn = exports.zoomDownOut = exports.zoomDownIn = exports.zoomBigOut = exports.zoomBigIn = exports.initZoomMotion = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _cssinjs = require("../../_util/cssinjs");
var _motion = require("./motion");
var zoomIn = new _cssinjs.Keyframes('antZoomIn', {
  '0%': {
    transform: 'scale(0.2)',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    opacity: 1
  }
});
exports.zoomIn = zoomIn;
var zoomOut = new _cssinjs.Keyframes('antZoomOut', {
  '0%': {
    transform: 'scale(1)'
  },
  '100%': {
    transform: 'scale(0.2)',
    opacity: 0
  }
});
exports.zoomOut = zoomOut;
var zoomBigIn = new _cssinjs.Keyframes('antZoomBigIn', {
  '0%': {
    transform: 'scale(0.8)',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    opacity: 1
  }
});
exports.zoomBigIn = zoomBigIn;
var zoomBigOut = new _cssinjs.Keyframes('antZoomBigOut', {
  '0%': {
    transform: 'scale(1)'
  },
  '100%': {
    transform: 'scale(0.8)',
    opacity: 0
  }
});
exports.zoomBigOut = zoomBigOut;
var zoomUpIn = new _cssinjs.Keyframes('antZoomUpIn', {
  '0%': {
    transform: 'scale(0.8)',
    transformOrigin: '50% 0%',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    transformOrigin: '50% 0%'
  }
});
exports.zoomUpIn = zoomUpIn;
var zoomUpOut = new _cssinjs.Keyframes('antZoomUpOut', {
  '0%': {
    transform: 'scale(1)',
    transformOrigin: '50% 0%'
  },
  '100%': {
    transform: 'scale(0.8)',
    transformOrigin: '50% 0%',
    opacity: 0
  }
});
exports.zoomUpOut = zoomUpOut;
var zoomLeftIn = new _cssinjs.Keyframes('antZoomLeftIn', {
  '0%': {
    transform: 'scale(0.8)',
    transformOrigin: '0% 50%',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    transformOrigin: '0% 50%'
  }
});
exports.zoomLeftIn = zoomLeftIn;
var zoomLeftOut = new _cssinjs.Keyframes('antZoomLeftOut', {
  '0%': {
    transform: 'scale(1)',
    transformOrigin: '0% 50%'
  },
  '100%': {
    transform: 'scale(0.8)',
    transformOrigin: '0% 50%',
    opacity: 0
  }
});
exports.zoomLeftOut = zoomLeftOut;
var zoomRightIn = new _cssinjs.Keyframes('antZoomRightIn', {
  '0%': {
    transform: 'scale(0.8)',
    transformOrigin: '100% 50%',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    transformOrigin: '100% 50%'
  }
});
exports.zoomRightIn = zoomRightIn;
var zoomRightOut = new _cssinjs.Keyframes('antZoomRightOut', {
  '0%': {
    transform: 'scale(1)',
    transformOrigin: '100% 50%'
  },
  '100%': {
    transform: 'scale(0.8)',
    transformOrigin: '100% 50%',
    opacity: 0
  }
});
exports.zoomRightOut = zoomRightOut;
var zoomDownIn = new _cssinjs.Keyframes('antZoomDownIn', {
  '0%': {
    transform: 'scale(0.8)',
    transformOrigin: '50% 100%',
    opacity: 0
  },
  '100%': {
    transform: 'scale(1)',
    transformOrigin: '50% 100%'
  }
});
exports.zoomDownIn = zoomDownIn;
var zoomDownOut = new _cssinjs.Keyframes('antZoomDownOut', {
  '0%': {
    transform: 'scale(1)',
    transformOrigin: '50% 100%'
  },
  '100%': {
    transform: 'scale(0.8)',
    transformOrigin: '50% 100%',
    opacity: 0
  }
});
exports.zoomDownOut = zoomDownOut;
var zoomMotion = {
  zoom: {
    inKeyframes: zoomIn,
    outKeyframes: zoomOut
  },
  'zoom-big': {
    inKeyframes: zoomBigIn,
    outKeyframes: zoomBigOut
  },
  'zoom-big-fast': {
    inKeyframes: zoomBigIn,
    outKeyframes: zoomBigOut
  },
  'zoom-left': {
    inKeyframes: zoomLeftIn,
    outKeyframes: zoomLeftOut
  },
  'zoom-right': {
    inKeyframes: zoomRightIn,
    outKeyframes: zoomRightOut
  },
  'zoom-up': {
    inKeyframes: zoomUpIn,
    outKeyframes: zoomUpOut
  },
  'zoom-down': {
    inKeyframes: zoomDownIn,
    outKeyframes: zoomDownOut
  }
};
var initZoomMotion = function initZoomMotion(token, motionName) {
  var _ref;
  var antCls = token.antCls;
  var motionCls = "".concat(antCls, "-").concat(motionName);
  var _zoomMotion$motionNam = zoomMotion[motionName],
    inKeyframes = _zoomMotion$motionNam.inKeyframes,
    outKeyframes = _zoomMotion$motionNam.outKeyframes;
  return [(0, _motion.initMotion)(motionCls, inKeyframes, outKeyframes, motionName === 'zoom-big-fast' ? token.motionDurationFast : token.motionDurationMid), (_ref = {}, (0, _defineProperty2.default)(_ref, "\n        ".concat(motionCls, "-enter,\n        ").concat(motionCls, "-appear\n      "), {
    transform: 'scale(0)',
    opacity: 0,
    animationTimingFunction: token.motionEaseOutCirc,
    '&-prepare': {
      transform: 'none'
    }
  }), (0, _defineProperty2.default)(_ref, "".concat(motionCls, "-leave"), {
    animationTimingFunction: token.motionEaseInOutCirc
  }), _ref)];
};
exports.initZoomMotion = initZoomMotion;