"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genPresetColor = genPresetColor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _internal = require("../theme/internal");
function genPresetColor(token, genCss) {
  return _internal.PresetColors.reduce(function (prev, colorKey) {
    var lightColor = token["".concat(colorKey, "-1")];
    var lightBorderColor = token["".concat(colorKey, "-3")];
    var darkColor = token["".concat(colorKey, "-6")];
    var textColor = token["".concat(colorKey, "-7")];
    return (0, _extends2.default)((0, _extends2.default)({}, prev), genCss(colorKey, {
      lightColor: lightColor,
      lightBorderColor: lightBorderColor,
      darkColor: darkColor,
      textColor: textColor
    }));
  }, {});
}