"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tinycolor = require("@ctrl/tinycolor");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var genSwitchSmallStyle = function genSwitchSmallStyle(token) {
  var _$concat, _$concat2, _$concat3, _not$concat, _$concat4;
  var componentCls = token.componentCls;
  var switchInnerCls = "".concat(componentCls, "-inner");
  return (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, "&".concat(componentCls, "-small"), (_$concat4 = {
    minWidth: token.switchMinWidthSM,
    height: token.switchHeightSM,
    lineHeight: "".concat(token.switchHeightSM, "px")
  }, (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-inner"), (_$concat = {
    paddingInlineStart: token.switchInnerMarginMaxSM,
    paddingInlineEnd: token.switchInnerMarginMinSM
  }, (0, _defineProperty2.default)(_$concat, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: "calc(-100% + ".concat(token.switchPinSizeSM + token.switchPadding * 2, "px - ").concat(token.switchInnerMarginMaxSM * 2, "px)"),
    marginInlineEnd: "calc(100% - ".concat(token.switchPinSizeSM + token.switchPadding * 2, "px + ").concat(token.switchInnerMarginMaxSM * 2, "px)")
  }), (0, _defineProperty2.default)(_$concat, "".concat(switchInnerCls, "-unchecked"), {
    marginTop: -token.switchHeightSM,
    marginInlineStart: 0,
    marginInlineEnd: 0
  }), _$concat)), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-handle"), {
    width: token.switchPinSizeSM,
    height: token.switchPinSizeSM
  }), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-loading-icon"), {
    top: (token.switchPinSizeSM - token.switchLoadingIconSize) / 2,
    fontSize: token.switchLoadingIconSize
  }), (0, _defineProperty2.default)(_$concat4, "&".concat(componentCls, "-checked"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-inner"), (_$concat2 = {
    paddingInlineStart: token.switchInnerMarginMinSM,
    paddingInlineEnd: token.switchInnerMarginMaxSM
  }, (0, _defineProperty2.default)(_$concat2, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: 0,
    marginInlineEnd: 0
  }), (0, _defineProperty2.default)(_$concat2, "".concat(switchInnerCls, "-unchecked"), {
    marginInlineStart: "calc(100% - ".concat(token.switchPinSizeSM + token.switchPadding * 2, "px + ").concat(token.switchInnerMarginMaxSM * 2, "px)"),
    marginInlineEnd: "calc(-100% + ".concat(token.switchPinSizeSM + token.switchPadding * 2, "px - ").concat(token.switchInnerMarginMaxSM * 2, "px)")
  }), _$concat2)), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-handle"), {
    insetInlineStart: "calc(100% - ".concat(token.switchPinSizeSM + token.switchPadding, "px)")
  }), _$concat3)), (0, _defineProperty2.default)(_$concat4, "&:not(".concat(componentCls, "-disabled):active"), (_not$concat = {}, (0, _defineProperty2.default)(_not$concat, "&:not(".concat(componentCls, "-checked) ").concat(switchInnerCls), (0, _defineProperty2.default)({}, "".concat(switchInnerCls, "-unchecked"), {
    marginInlineStart: token.marginXXS / 2,
    marginInlineEnd: -token.marginXXS / 2
  })), (0, _defineProperty2.default)(_not$concat, "&".concat(componentCls, "-checked ").concat(switchInnerCls), (0, _defineProperty2.default)({}, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: -token.marginXXS / 2,
    marginInlineEnd: token.marginXXS / 2
  })), _not$concat)), _$concat4)));
};
var genSwitchLoadingStyle = function genSwitchLoadingStyle(token) {
  var _componentCls2;
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls2 = {}, (0, _defineProperty2.default)(_componentCls2, "".concat(componentCls, "-loading-icon").concat(token.iconCls), {
    position: 'relative',
    top: (token.switchPinSize - token.fontSize) / 2,
    color: token.switchLoadingIconColor,
    verticalAlign: 'top'
  }), (0, _defineProperty2.default)(_componentCls2, "&".concat(componentCls, "-checked ").concat(componentCls, "-loading-icon"), {
    color: token.switchColor
  }), _componentCls2));
};
var genSwitchHandleStyle = function genSwitchHandleStyle(token) {
  var _not$concat2, _componentCls3;
  var componentCls = token.componentCls;
  var switchHandleCls = "".concat(componentCls, "-handle");
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls3 = {}, (0, _defineProperty2.default)(_componentCls3, switchHandleCls, {
    position: 'absolute',
    top: token.switchPadding,
    insetInlineStart: token.switchPadding,
    width: token.switchPinSize,
    height: token.switchPinSize,
    transition: "all ".concat(token.switchDuration, " ease-in-out"),
    '&::before': {
      position: 'absolute',
      top: 0,
      insetInlineEnd: 0,
      bottom: 0,
      insetInlineStart: 0,
      backgroundColor: token.colorWhite,
      borderRadius: token.switchPinSize / 2,
      boxShadow: token.switchHandleShadow,
      transition: "all ".concat(token.switchDuration, " ease-in-out"),
      content: '""'
    }
  }), (0, _defineProperty2.default)(_componentCls3, "&".concat(componentCls, "-checked ").concat(switchHandleCls), {
    insetInlineStart: "calc(100% - ".concat(token.switchPinSize + token.switchPadding, "px)")
  }), (0, _defineProperty2.default)(_componentCls3, "&:not(".concat(componentCls, "-disabled):active"), (_not$concat2 = {}, (0, _defineProperty2.default)(_not$concat2, "".concat(switchHandleCls, "::before"), {
    insetInlineEnd: token.switchHandleActiveInset,
    insetInlineStart: 0
  }), (0, _defineProperty2.default)(_not$concat2, "&".concat(componentCls, "-checked ").concat(switchHandleCls, "::before"), {
    insetInlineEnd: 0,
    insetInlineStart: token.switchHandleActiveInset
  }), _not$concat2)), _componentCls3));
};
var genSwitchInnerStyle = function genSwitchInnerStyle(token) {
  var _switchInnerCls, _$concat$concat2, _not$concat3, _componentCls4;
  var componentCls = token.componentCls;
  var switchInnerCls = "".concat(componentCls, "-inner");
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls4 = {}, (0, _defineProperty2.default)(_componentCls4, switchInnerCls, (_switchInnerCls = {
    display: 'block',
    overflow: 'hidden',
    borderRadius: 100,
    height: '100%',
    paddingInlineStart: token.switchInnerMarginMax,
    paddingInlineEnd: token.switchInnerMarginMin,
    transition: "padding-inline-start ".concat(token.switchDuration, " ease-in-out, padding-inline-end ").concat(token.switchDuration, " ease-in-out")
  }, (0, _defineProperty2.default)(_switchInnerCls, "".concat(switchInnerCls, "-checked, ").concat(switchInnerCls, "-unchecked"), {
    display: 'block',
    color: token.colorTextLightSolid,
    fontSize: token.fontSizeSM,
    transition: "margin-inline-start ".concat(token.switchDuration, " ease-in-out, margin-inline-end ").concat(token.switchDuration, " ease-in-out"),
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_switchInnerCls, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: "calc(-100% + ".concat(token.switchPinSize + token.switchPadding * 2, "px - ").concat(token.switchInnerMarginMax * 2, "px)"),
    marginInlineEnd: "calc(100% - ".concat(token.switchPinSize + token.switchPadding * 2, "px + ").concat(token.switchInnerMarginMax * 2, "px)")
  }), (0, _defineProperty2.default)(_switchInnerCls, "".concat(switchInnerCls, "-unchecked"), {
    marginTop: -token.switchHeight,
    marginInlineStart: 0,
    marginInlineEnd: 0
  }), _switchInnerCls)), (0, _defineProperty2.default)(_componentCls4, "&".concat(componentCls, "-checked ").concat(switchInnerCls), (_$concat$concat2 = {
    paddingInlineStart: token.switchInnerMarginMin,
    paddingInlineEnd: token.switchInnerMarginMax
  }, (0, _defineProperty2.default)(_$concat$concat2, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: 0,
    marginInlineEnd: 0
  }), (0, _defineProperty2.default)(_$concat$concat2, "".concat(switchInnerCls, "-unchecked"), {
    marginInlineStart: "calc(100% - ".concat(token.switchPinSize + token.switchPadding * 2, "px + ").concat(token.switchInnerMarginMax * 2, "px)"),
    marginInlineEnd: "calc(-100% + ".concat(token.switchPinSize + token.switchPadding * 2, "px - ").concat(token.switchInnerMarginMax * 2, "px)")
  }), _$concat$concat2)), (0, _defineProperty2.default)(_componentCls4, "&:not(".concat(componentCls, "-disabled):active"), (_not$concat3 = {}, (0, _defineProperty2.default)(_not$concat3, "&:not(".concat(componentCls, "-checked) ").concat(switchInnerCls), (0, _defineProperty2.default)({}, "".concat(switchInnerCls, "-unchecked"), {
    marginInlineStart: token.switchPadding * 2,
    marginInlineEnd: -token.switchPadding * 2
  })), (0, _defineProperty2.default)(_not$concat3, "&".concat(componentCls, "-checked ").concat(switchInnerCls), (0, _defineProperty2.default)({}, "".concat(switchInnerCls, "-checked"), {
    marginInlineStart: -token.switchPadding * 2,
    marginInlineEnd: token.switchPadding * 2
  })), _not$concat3)), _componentCls4));
};
var genSwitchStyle = function genSwitchStyle(token) {
  var _extends3;
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends4.default)((0, _extends4.default)((0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (0, _defineProperty2.default)({
    position: 'relative',
    display: 'inline-block',
    boxSizing: 'border-box',
    minWidth: token.switchMinWidth,
    height: token.switchHeight,
    lineHeight: "".concat(token.switchHeight, "px"),
    verticalAlign: 'middle',
    background: token.colorTextQuaternary,
    border: '0',
    borderRadius: 100,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationMid),
    userSelect: 'none'
  }, "&:hover:not(".concat(componentCls, "-disabled)"), {
    background: token.colorTextTertiary
  })), (0, _style.genFocusStyle)(token)), (_extends3 = {}, (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-checked"), (0, _defineProperty2.default)({
    background: token.switchColor
  }, "&:hover:not(".concat(componentCls, "-disabled)"), {
    background: token.colorPrimaryHover
  })), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-loading, &").concat(componentCls, "-disabled"), {
    cursor: 'not-allowed',
    opacity: token.switchDisabledOpacity,
    '*': {
      boxShadow: 'none',
      cursor: 'not-allowed'
    }
  }), (0, _defineProperty2.default)(_extends3, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), _extends3)));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Switch', function (token) {
  var switchHeight = token.fontSize * token.lineHeight;
  var switchHeightSM = token.controlHeight / 2;
  var switchPadding = 2; // This is magic
  var switchPinSize = switchHeight - switchPadding * 2;
  var switchPinSizeSM = switchHeightSM - switchPadding * 2;
  var switchToken = (0, _internal.mergeToken)(token, {
    switchMinWidth: switchPinSize * 2 + switchPadding * 4,
    switchHeight: switchHeight,
    switchDuration: token.motionDurationMid,
    switchColor: token.colorPrimary,
    switchDisabledOpacity: token.opacityLoading,
    switchInnerMarginMin: switchPinSize / 2,
    switchInnerMarginMax: switchPinSize + switchPadding + switchPadding * 2,
    switchPadding: switchPadding,
    switchPinSize: switchPinSize,
    switchBg: token.colorBgContainer,
    switchMinWidthSM: switchPinSizeSM * 2 + switchPadding * 2,
    switchHeightSM: switchHeightSM,
    switchInnerMarginMinSM: switchPinSizeSM / 2,
    switchInnerMarginMaxSM: switchPinSizeSM + switchPadding + switchPadding * 2,
    switchPinSizeSM: switchPinSizeSM,
    switchHandleShadow: "0 2px 4px 0 ".concat(new _tinycolor.TinyColor('#00230b').setAlpha(0.2).toRgbString()),
    switchLoadingIconSize: token.fontSizeIcon * 0.75,
    switchLoadingIconColor: "rgba(0, 0, 0, ".concat(token.opacityLoading, ")"),
    switchHandleActiveInset: '-30%'
  });
  return [genSwitchStyle(switchToken),
  // inner style
  genSwitchInnerStyle(switchToken),
  // handle style
  genSwitchHandleStyle(switchToken),
  // loading style
  genSwitchLoadingStyle(switchToken),
  // small style
  genSwitchSmallStyle(switchToken)];
});
exports.default = _default;