"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _tinycolor = require("@ctrl/tinycolor");
var _internal = require("../../theme/internal");
var _bordered = _interopRequireDefault(require("./bordered"));
var _ellipsis = _interopRequireDefault(require("./ellipsis"));
var _empty = _interopRequireDefault(require("./empty"));
var _expand = _interopRequireDefault(require("./expand"));
var _filter = _interopRequireDefault(require("./filter"));
var _fixed = _interopRequireDefault(require("./fixed"));
var _pagination = _interopRequireDefault(require("./pagination"));
var _radius = _interopRequireDefault(require("./radius"));
var _rtl = _interopRequireDefault(require("./rtl"));
var _selection = _interopRequireDefault(require("./selection"));
var _size = _interopRequireDefault(require("./size"));
var _sorter = _interopRequireDefault(require("./sorter"));
var _sticky = _interopRequireDefault(require("./sticky"));
var _summary = _interopRequireDefault(require("./summary"));
var _style = require("../../style");
var genTableStyle = function genTableStyle(token) {
  var _$concat, _tr2, _ref, _extends2;
  var componentCls = token.componentCls,
    fontWeightStrong = token.fontWeightStrong,
    tablePaddingVertical = token.tablePaddingVertical,
    tablePaddingHorizontal = token.tablePaddingHorizontal,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    tableBorderColor = token.tableBorderColor,
    tableFontSize = token.tableFontSize,
    tableBg = token.tableBg,
    tableRadius = token.tableRadius,
    tableHeaderTextColor = token.tableHeaderTextColor,
    motionDurationMid = token.motionDurationMid,
    tableHeaderBg = token.tableHeaderBg,
    tableHeaderCellSplitColor = token.tableHeaderCellSplitColor,
    tableRowHoverBg = token.tableRowHoverBg,
    tableSelectedRowBg = token.tableSelectedRowBg,
    tableSelectedRowHoverBg = token.tableSelectedRowHoverBg,
    tableFooterTextColor = token.tableFooterTextColor,
    tableFooterBg = token.tableFooterBg,
    paddingContentVerticalLG = token.paddingContentVerticalLG,
    wireframe = token.wireframe;
  var tableBorder = "".concat(lineWidth, "px ").concat(lineType, " ").concat(tableBorderColor);
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper"), (0, _extends3.default)((0, _extends3.default)({
    clear: 'both',
    maxWidth: '100%'
  }, (0, _style.clearFix)()), (_extends2 = {}, (0, _defineProperty2.default)(_extends2, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), {
    fontSize: tableFontSize,
    background: tableBg,
    borderRadius: "".concat(tableRadius, "px ").concat(tableRadius, "px 0 0")
  })), (0, _defineProperty2.default)(_extends2, "table", {
    width: '100%',
    textAlign: 'start',
    borderRadius: "".concat(tableRadius, "px ").concat(tableRadius, "px 0 0"),
    borderCollapse: 'separate',
    borderSpacing: 0
  }), (0, _defineProperty2.default)(_extends2, "\n          ".concat(componentCls, "-thead > tr > th,\n          ").concat(componentCls, "-tbody > tr > td,\n          tfoot > tr > th,\n          tfoot > tr > td\n        "), {
    position: 'relative',
    padding: "".concat(paddingContentVerticalLG, "px ").concat(tablePaddingHorizontal, "px"),
    overflowWrap: 'break-word'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-title"), {
    padding: "".concat(tablePaddingVertical, "px ").concat(tablePaddingHorizontal, "px")
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-thead"), (_$concat = {}, (0, _defineProperty2.default)(_$concat, "\n          > tr > th,\n          > tr > td\n        ", (0, _defineProperty2.default)({
    position: 'relative',
    color: tableHeaderTextColor,
    fontWeight: fontWeightStrong,
    textAlign: 'start',
    background: tableHeaderBg,
    borderBottom: tableBorder,
    transition: "background ".concat(motionDurationMid, " ease"),
    "&[colspan]:not([colspan='1'])": {
      textAlign: 'center'
    }
  }, "&:not(:last-child):not(".concat(componentCls, "-selection-column):not(").concat(componentCls, "-row-expand-icon-cell):not([colspan])::before"), {
    position: 'absolute',
    top: '50%',
    insetInlineEnd: 0,
    width: 1,
    height: '1.6em',
    backgroundColor: tableHeaderCellSplitColor,
    transform: 'translateY(-50%)',
    transition: "background-color ".concat(motionDurationMid),
    content: '""'
  })), (0, _defineProperty2.default)(_$concat, '> tr:not(:last-child) > th[colspan]', {
    borderBottom: 0
  }), _$concat)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, ":not(").concat(componentCls, "-bordered)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tbody"), {
    '> tr': (0, _defineProperty2.default)({
      '> td': {
        borderTop: tableBorder,
        borderBottom: 'transparent'
      },
      '&:last-child > td': {
        borderBottom: tableBorder
      }
    }, "&:first-child > td,\n              &".concat(componentCls, "-measure-row + tr > td"), {
      borderTop: 'none',
      borderTopColor: 'transparent'
    })
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls).concat(componentCls, "-bordered"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tbody"), {
    '> tr': {
      '> td': {
        borderBottom: tableBorder
      }
    }
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-tbody"), {
    '> tr': (_tr2 = {
      '> td': (0, _defineProperty2.default)({
        transition: "background ".concat(motionDurationMid, ", border-color ").concat(motionDurationMid)
      }, "\n              > ".concat(componentCls, "-wrapper:only-child,\n              > ").concat(componentCls, "-expanded-row-fixed > ").concat(componentCls, "-wrapper:only-child\n            "), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({
        marginBlock: "-".concat(tablePaddingVertical, "px"),
        marginInline: "".concat(token.tableExpandColumnWidth - tablePaddingHorizontal, "px -").concat(tablePaddingHorizontal, "px")
      }, "".concat(componentCls, "-tbody > tr:last-child > td"), {
        borderBottom: 0,
        '&:first-child, &:last-child': {
          borderRadius: 0
        }
      })))
    }, (0, _defineProperty2.default)(_tr2, "\n            &".concat(componentCls, "-row:hover > td,\n            > td").concat(componentCls, "-cell-row-hover\n          "), {
      background: tableRowHoverBg
    }), (0, _defineProperty2.default)(_tr2, "&".concat(componentCls, "-row-selected"), {
      '> td': {
        background: tableSelectedRowBg
      },
      '&:hover > td': {
        background: tableSelectedRowHoverBg
      }
    }), _tr2)
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, ":not(").concat(componentCls, "-bordered) ").concat(componentCls, "-tbody > tr"), wireframe ? undefined : (_ref = {}, (0, _defineProperty2.default)(_ref, "&".concat(componentCls, "-row:hover, &").concat(componentCls, "-row").concat(componentCls, "-row-selected"), (0, _defineProperty2.default)({}, "+ tr".concat(componentCls, "-row > td"), {
    borderTopColor: 'transparent'
  })), (0, _defineProperty2.default)(_ref, "&".concat(componentCls, "-row:last-child:hover > td,\n          &").concat(componentCls, "-row").concat(componentCls, "-row-selected:last-child > td"), {
    borderBottomColor: 'transparent'
  }), (0, _defineProperty2.default)(_ref, "\n          &".concat(componentCls, "-row:hover > td,\n          > td").concat(componentCls, "-cell-row-hover,\n          &").concat(componentCls, "-row").concat(componentCls, "-row-selected > td\n        "), {
    borderTopColor: 'transparent',
    '&:first-child': {
      borderStartStartRadius: tableRadius,
      borderEndStartRadius: tableRadius
    },
    '&:last-child': {
      borderStartEndRadius: tableRadius,
      borderEndEndRadius: tableRadius
    }
  }), _ref)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-footer"), {
    padding: "".concat(tablePaddingVertical, "px ").concat(tablePaddingHorizontal, "px"),
    color: tableFooterTextColor,
    background: tableFooterBg
  }), _extends2)));
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Table', function (token) {
  var controlItemBgActive = token.controlItemBgActive,
    controlItemBgActiveHover = token.controlItemBgActiveHover,
    colorTextPlaceholder = token.colorTextPlaceholder,
    colorTextHeading = token.colorTextHeading,
    colorSplit = token.colorSplit,
    colorBorderSecondary = token.colorBorderSecondary,
    fontSize = token.fontSize,
    padding = token.padding,
    paddingXS = token.paddingXS,
    paddingSM = token.paddingSM,
    controlHeight = token.controlHeight,
    colorFillAlter = token.colorFillAlter,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover,
    opacityLoading = token.opacityLoading,
    colorBgContainer = token.colorBgContainer,
    borderRadiusLG = token.borderRadiusLG,
    colorFillContent = token.colorFillContent,
    colorFillSecondary = token.colorFillSecondary,
    checkboxSize = token.controlInteractiveSize;
  var baseColorAction = new _tinycolor.TinyColor(colorIcon);
  var baseColorActionHover = new _tinycolor.TinyColor(colorIconHover);
  var tableSelectedRowBg = controlItemBgActive;
  var zIndexTableFixed = 2;
  var colorFillSecondarySolid = new _tinycolor.TinyColor(colorFillSecondary).onBackground(colorBgContainer).toHexString();
  var colorFillContentSolid = new _tinycolor.TinyColor(colorFillContent).onBackground(colorBgContainer).toHexString();
  var colorFillAlterSolid = new _tinycolor.TinyColor(colorFillAlter).onBackground(colorBgContainer).toHexString();
  var tableToken = (0, _internal.mergeToken)(token, {
    tableFontSize: fontSize,
    tableBg: colorBgContainer,
    tableRadius: borderRadiusLG,
    tablePaddingVertical: padding,
    tablePaddingHorizontal: padding,
    tablePaddingVerticalMiddle: paddingSM,
    tablePaddingHorizontalMiddle: paddingXS,
    tablePaddingVerticalSmall: paddingXS,
    tablePaddingHorizontalSmall: paddingXS,
    tableBorderColor: colorBorderSecondary,
    tableHeaderTextColor: colorTextHeading,
    tableHeaderBg: colorFillAlterSolid,
    tableFooterTextColor: colorTextHeading,
    tableFooterBg: colorFillAlterSolid,
    tableHeaderCellSplitColor: colorBorderSecondary,
    tableHeaderSortBg: colorFillSecondarySolid,
    tableHeaderSortHoverBg: colorFillContentSolid,
    tableHeaderIconColor: baseColorAction.clone().setAlpha(baseColorAction.getAlpha() * opacityLoading).toRgbString(),
    tableHeaderIconColorHover: baseColorActionHover.clone().setAlpha(baseColorActionHover.getAlpha() * opacityLoading).toRgbString(),
    tableBodySortBg: colorFillAlterSolid,
    tableFixedHeaderSortActiveBg: colorFillSecondarySolid,
    tableHeaderFilterActiveBg: colorFillContent,
    tableFilterDropdownBg: colorBgContainer,
    tableRowHoverBg: colorFillAlterSolid,
    tableSelectedRowBg: tableSelectedRowBg,
    tableSelectedRowHoverBg: controlItemBgActiveHover,
    zIndexTableFixed: zIndexTableFixed,
    zIndexTableSticky: zIndexTableFixed + 1,
    tableFontSizeMiddle: fontSize,
    tableFontSizeSmall: fontSize,
    tableSelectionColumnWidth: controlHeight,
    tableExpandIconBg: colorBgContainer,
    tableExpandColumnWidth: checkboxSize + 2 * token.padding,
    tableExpandedRowBg: colorFillAlter,
    // Dropdown
    tableFilterDropdownWidth: 120,
    tableFilterDropdownHeight: 264,
    tableFilterDropdownSearchWidth: 140,
    // Virtual Scroll Bar
    tableScrollThumbSize: 8,
    tableScrollThumbBg: colorTextPlaceholder,
    tableScrollThumbBgHover: colorTextHeading,
    tableScrollBg: colorSplit
  });
  return [genTableStyle(tableToken), (0, _pagination.default)(tableToken), (0, _summary.default)(tableToken), (0, _sorter.default)(tableToken), (0, _filter.default)(tableToken), (0, _bordered.default)(tableToken), (0, _radius.default)(tableToken), (0, _expand.default)(tableToken), (0, _summary.default)(tableToken), (0, _empty.default)(tableToken), (0, _selection.default)(tableToken), (0, _fixed.default)(tableToken), (0, _sticky.default)(tableToken), (0, _ellipsis.default)(tableToken), (0, _size.default)(tableToken), (0, _rtl.default)(tableToken)];
});
exports.default = _default;