"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _propsUtil = require("../_util/props-util");
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _TimelineItem = _interopRequireDefault(require("./TimelineItem"));
var _LoadingOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/LoadingOutlined"));
var _type = require("../_util/type");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
// CSSINJS

var timelineProps = function timelineProps() {
  return {
    prefixCls: String,
    /** 指定最后一个幽灵节点是否存在或内容 */
    pending: _vueTypes.default.any,
    pendingDot: _vueTypes.default.any,
    reverse: (0, _type.booleanType)(),
    mode: _vueTypes.default.oneOf((0, _type.tuple)('left', 'alternate', 'right', ''))
  };
};
exports.timelineProps = timelineProps;
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATimeline',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(timelineProps(), {
    reverse: false,
    mode: ''
  }),
  slots: ['pending', 'pendingDot'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('timeline', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getPositionCls = function getPositionCls(ele, idx) {
      var eleProps = ele.props || {};
      if (props.mode === 'alternate') {
        if (eleProps.position === 'right') return "".concat(prefixCls.value, "-item-right");
        if (eleProps.position === 'left') return "".concat(prefixCls.value, "-item-left");
        return idx % 2 === 0 ? "".concat(prefixCls.value, "-item-left") : "".concat(prefixCls.value, "-item-right");
      }
      if (props.mode === 'left') return "".concat(prefixCls.value, "-item-left");
      if (props.mode === 'right') return "".concat(prefixCls.value, "-item-right");
      if (eleProps.position === 'right') return "".concat(prefixCls.value, "-item-right");
      return '';
    };
    return function () {
      var _classNames;
      var _a, _b, _c;
      var _props$pending = props.pending,
        pending = _props$pending === void 0 ? (_a = slots.pending) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$pending,
        _props$pendingDot = props.pendingDot,
        pendingDot = _props$pendingDot === void 0 ? (_b = slots.pendingDot) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$pendingDot,
        reverse = props.reverse,
        mode = props.mode;
      var pendingNode = typeof pending === 'boolean' ? null : pending;
      var children = (0, _propsUtil.filterEmpty)((_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots));
      var pendingItem = pending ? (0, _vue.createVNode)(_TimelineItem.default, {
        "pending": !!pending,
        "dot": pendingDot || (0, _vue.createVNode)(_LoadingOutlined.default, null, null)
      }, {
        default: function _default() {
          return [pendingNode];
        }
      }) : null;
      if (pendingItem) {
        children.push(pendingItem);
      }
      var timeLineItems = reverse ? children.reverse() : children;
      var itemsCount = timeLineItems.length;
      var lastCls = "".concat(prefixCls.value, "-item-last");
      var items = timeLineItems.map(function (ele, idx) {
        var pendingClass = idx === itemsCount - 2 ? lastCls : '';
        var readyClass = idx === itemsCount - 1 ? lastCls : '';
        return (0, _vue.cloneVNode)(ele, {
          class: (0, _classNames2.default)([!reverse && !!pending ? pendingClass : readyClass, getPositionCls(ele, idx)])
        });
      });
      var hasLabelItem = timeLineItems.some(function (item) {
        var _a, _b;
        return !!(((_a = item.props) === null || _a === void 0 ? void 0 : _a.label) || ((_b = item.children) === null || _b === void 0 ? void 0 : _b.label));
      });
      var classString = (0, _classNames2.default)(prefixCls.value, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-pending"), !!pending), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-reverse"), !!reverse), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-").concat(mode), !!mode && !hasLabelItem), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-label"), hasLabelItem), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value);
      return wrapSSR((0, _vue.createVNode)("ul", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": classString
      }), [items]));
    };
  }
});
exports.default = _default2;