"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineItemProps = exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _type = require("../_util/type");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var timelineItemProps = function timelineItemProps() {
  return {
    prefixCls: String,
    color: String,
    dot: _vueTypes.default.any,
    pending: (0, _type.booleanType)(),
    position: _vueTypes.default.oneOf((0, _type.tuple)('left', 'right', '')).def(''),
    label: _vueTypes.default.any
  };
};
exports.timelineItemProps = timelineItemProps;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATimelineItem',
  props: (0, _initDefaultProps.default)(timelineItemProps(), {
    color: 'blue',
    pending: false
  }),
  slots: ['dot', 'label'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var _useConfigInject = (0, _useConfigInject2.default)('timeline', props),
      prefixCls = _useConfigInject.prefixCls;
    var itemClassName = (0, _vue.computed)(function () {
      var _ref2;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-item"), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-item-pending"), props.pending), _ref2;
    });
    var customColor = (0, _vue.computed)(function () {
      return /blue|red|green|gray/.test(props.color || '') ? undefined : props.color || 'blue';
    });
    var dotClassName = (0, _vue.computed)(function () {
      var _ref3;
      return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "".concat(prefixCls.value, "-item-head"), true), (0, _defineProperty2.default)(_ref3, "".concat(prefixCls.value, "-item-head-").concat(props.color || 'blue'), !customColor.value), _ref3;
    });
    return function () {
      var _a, _b, _c;
      var _props$label = props.label,
        label = _props$label === void 0 ? (_a = slots.label) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$label,
        _props$dot = props.dot,
        dot = _props$dot === void 0 ? (_b = slots.dot) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$dot;
      return (0, _vue.createVNode)("li", {
        "class": itemClassName.value
      }, [label && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-item-label")
      }, [label]), (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-item-tail")
      }, null), (0, _vue.createVNode)("div", {
        "class": [dotClassName.value, !!dot && "".concat(prefixCls.value, "-item-head-custom")],
        "style": {
          borderColor: customColor.value,
          color: customColor.value
        }
      }, [dot]), (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-item-content")
      }, [(_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots)])]);
    };
  }
});
exports.default = _default;