"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var _placementArrow = _interopRequireWildcard(require("../../style/placementArrow"));
require("vue");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var genTooltipStyle = function genTooltipStyle(token) {
  var _extends2;
  var componentCls = token.componentCls,
    tooltipMaxWidth = token.tooltipMaxWidth,
    tooltipColor = token.tooltipColor,
    tooltipBg = token.tooltipBg,
    tooltipBorderRadius = token.tooltipBorderRadius,
    zIndexPopup = token.zIndexPopup,
    controlHeight = token.controlHeight,
    boxShadowSecondary = token.boxShadowSecondary,
    paddingSM = token.paddingSM,
    paddingXS = token.paddingXS,
    tooltipRadiusOuter = token.tooltipRadiusOuter;
  return [(0, _defineProperty2.default)({}, componentCls, (0, _extends3.default)((0, _extends3.default)((0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'absolute',
    zIndex: zIndexPopup,
    display: 'block',
    '&': [{
      width: 'max-content'
    }, {
      width: 'intrinsic'
    }],
    maxWidth: tooltipMaxWidth,
    visibility: 'visible',
    '&-hidden': {
      display: 'none'
    },
    '--antd-arrow-background-color': tooltipBg
  }, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-inner"), {
    minWidth: controlHeight,
    minHeight: controlHeight,
    padding: "".concat(paddingSM / 2, "px ").concat(paddingXS, "px"),
    color: tooltipColor,
    textAlign: 'start',
    textDecoration: 'none',
    wordWrap: 'break-word',
    backgroundColor: tooltipBg,
    borderRadius: tooltipBorderRadius,
    boxShadow: boxShadowSecondary
  }), (0, _defineProperty2.default)(_extends2, ["&-placement-left", "&-placement-leftTop", "&-placement-leftBottom", "&-placement-right", "&-placement-rightTop", "&-placement-rightBottom"].join(','), (0, _defineProperty2.default)({}, "".concat(componentCls, "-inner"), {
    borderRadius: Math.min(tooltipBorderRadius, _placementArrow.MAX_VERTICAL_CONTENT_RADIUS)
  })), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-content"), {
    position: 'relative'
  }), _extends2)), (0, _style.genPresetColor)(token, function (colorKey, _ref) {
    var _$concat$concat;
    var darkColor = _ref.darkColor;
    return (0, _defineProperty2.default)({}, "&".concat(componentCls, "-").concat(colorKey), (_$concat$concat = {}, (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-inner"), {
      backgroundColor: darkColor
    }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-arrow"), {
      '--antd-arrow-background-color': darkColor
    }), _$concat$concat));
  })), {
    // RTL
    '&-rtl': {
      direction: 'rtl'
    }
  })),
  // Arrow Style
  (0, _placementArrow.default)((0, _internal.mergeToken)(token, {
    borderRadiusOuter: tooltipRadiusOuter
  }), {
    colorBg: 'var(--antd-arrow-background-color)',
    showArrowCls: '',
    contentRadius: tooltipBorderRadius,
    limitVerticalRadius: true
  }), // Pure Render
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-pure"), {
    position: 'relative',
    maxWidth: 'none'
  })];
};
// ============================== Export ==============================
var _default = function _default(prefixCls, injectStyle) {
  var useOriginHook = (0, _internal.genComponentStyleHook)('Tooltip', function (token) {
    // Popover use Tooltip as internal component. We do not need to handle this.
    if ((injectStyle === null || injectStyle === void 0 ? void 0 : injectStyle.value) === false) {
      return [];
    }
    var borderRadius = token.borderRadius,
      colorTextLightSolid = token.colorTextLightSolid,
      colorBgDefault = token.colorBgDefault,
      borderRadiusOuter = token.borderRadiusOuter;
    var TooltipToken = (0, _internal.mergeToken)(token, {
      // default variables
      tooltipMaxWidth: 250,
      tooltipColor: colorTextLightSolid,
      tooltipBorderRadius: borderRadius,
      tooltipBg: colorBgDefault,
      tooltipRadiusOuter: borderRadiusOuter > 4 ? 4 : borderRadiusOuter
    });
    return [genTooltipStyle(TooltipToken), (0, _motion.initZoomMotion)(token, 'zoom-big-fast')];
  }, function (_ref5) {
    var zIndexPopupBase = _ref5.zIndexPopupBase,
      colorBgSpotlight = _ref5.colorBgSpotlight;
    return {
      zIndexPopup: zIndexPopupBase + 70,
      colorBgDefault: colorBgSpotlight
    };
  });
  return useOriginHook(prefixCls);
};
exports.default = _default;