"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genPictureStyle = exports.genPictureCardStyle = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _tinycolor = require("@ctrl/tinycolor");
var _style = require("../../style");
var genPictureStyle = function genPictureStyle(token) {
  var _extends2, _itemCls, _$concat$concat, _$concat$concat$conca;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    uploadThumbnailSize = token.uploadThumbnailSize,
    uploadProgressOffset = token.uploadProgressOffset;
  var listCls = "".concat(componentCls, "-list");
  var itemCls = "".concat(listCls, "-item");
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper"), (0, _defineProperty2.default)({}, "".concat(listCls).concat(listCls, "-picture, ").concat(listCls).concat(listCls, "-picture-card"), (_$concat$concat$conca = {}, (0, _defineProperty2.default)(_$concat$concat$conca, itemCls, (_itemCls = {
    position: 'relative',
    height: uploadThumbnailSize + token.lineWidth * 2 + token.paddingXS * 2,
    padding: token.paddingXS,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    borderRadius: token.borderRadiusLG,
    '&:hover': {
      background: 'transparent'
    }
  }, (0, _defineProperty2.default)(_itemCls, "".concat(itemCls, "-thumbnail"), (0, _extends4.default)((0, _extends4.default)({}, _style.textEllipsis), (_extends2 = {
    width: uploadThumbnailSize,
    height: uploadThumbnailSize,
    lineHeight: "".concat(uploadThumbnailSize + token.paddingSM, "px"),
    textAlign: 'center',
    flex: 'none'
  }, (0, _defineProperty2.default)(_extends2, iconCls, {
    fontSize: token.fontSizeHeading2,
    color: token.colorPrimary
  }), (0, _defineProperty2.default)(_extends2, "img", {
    display: 'block',
    width: '100%',
    height: '100%',
    overflow: 'hidden'
  }), _extends2))), (0, _defineProperty2.default)(_itemCls, "".concat(itemCls, "-progress"), {
    bottom: uploadProgressOffset,
    width: "calc(100% - ".concat(token.paddingSM * 2, "px)"),
    marginTop: 0,
    paddingInlineStart: uploadThumbnailSize + token.paddingXS
  }), _itemCls)), (0, _defineProperty2.default)(_$concat$concat$conca, "".concat(itemCls, "-error"), (0, _defineProperty2.default)({
    borderColor: token.colorError
  }, "".concat(itemCls, "-thumbnail ").concat(iconCls), (_$concat$concat = {}, (0, _defineProperty2.default)(_$concat$concat, "svg path[fill='#e6f7ff']", {
    fill: token.colorErrorBg
  }), (0, _defineProperty2.default)(_$concat$concat, "svg path[fill='#1890ff']", {
    fill: token.colorError
  }), _$concat$concat))), (0, _defineProperty2.default)(_$concat$concat$conca, "".concat(itemCls, "-uploading"), (0, _defineProperty2.default)({
    borderStyle: 'dashed'
  }, "".concat(itemCls, "-name"), {
    marginBottom: uploadProgressOffset
  })), _$concat$concat$conca)));
};
exports.genPictureStyle = genPictureStyle;
var genPictureCardStyle = function genPictureCardStyle(token) {
  var _$concat$concat2, _$concat6, _$concat$concat4, _extends3;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    fontSizeLG = token.fontSizeLG,
    colorTextLightSolid = token.colorTextLightSolid;
  var listCls = "".concat(componentCls, "-list");
  var itemCls = "".concat(listCls, "-item");
  var uploadPictureCardSize = token.uploadPicCardSize;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-wrapper").concat(componentCls, "-picture-card-wrapper"), (0, _extends4.default)((0, _extends4.default)({}, (0, _style.clearFix)()), (_extends3 = {
    display: 'inline-block',
    width: '100%'
  }, (0, _defineProperty2.default)(_extends3, "".concat(componentCls).concat(componentCls, "-select"), (_$concat$concat2 = {
    width: uploadPictureCardSize,
    height: uploadPictureCardSize,
    marginInlineEnd: token.marginXS,
    marginBottom: token.marginXS,
    textAlign: 'center',
    verticalAlign: 'top',
    backgroundColor: token.colorFillAlter,
    border: "".concat(token.lineWidth, "px dashed ").concat(token.colorBorder),
    borderRadius: token.borderRadiusLG,
    cursor: 'pointer',
    transition: "border-color ".concat(token.motionDurationSlow)
  }, (0, _defineProperty2.default)(_$concat$concat2, "> ".concat(componentCls), {
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    height: '100%',
    textAlign: 'center'
  }), (0, _defineProperty2.default)(_$concat$concat2, "&:not(".concat(componentCls, "-disabled):hover"), {
    borderColor: token.colorPrimary
  }), _$concat$concat2)), (0, _defineProperty2.default)(_extends3, "".concat(listCls).concat(listCls, "-picture-card"), (_$concat$concat4 = {}, (0, _defineProperty2.default)(_$concat$concat4, "".concat(listCls, "-item-container"), {
    display: 'inline-block',
    width: uploadPictureCardSize,
    height: uploadPictureCardSize,
    marginBlock: "0 ".concat(token.marginXS, "px"),
    marginInline: "0 ".concat(token.marginXS, "px"),
    verticalAlign: 'top'
  }), (0, _defineProperty2.default)(_$concat$concat4, '&::after', {
    display: 'none'
  }), (0, _defineProperty2.default)(_$concat$concat4, itemCls, {
    height: '100%',
    margin: 0,
    '&::before': {
      position: 'absolute',
      zIndex: 1,
      width: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
      height: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
      backgroundColor: token.colorBgMask,
      opacity: 0,
      transition: "all ".concat(token.motionDurationSlow),
      content: '" "'
    }
  }), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, ":hover"), (0, _defineProperty2.default)({}, "&::before, ".concat(itemCls, "-actions"), {
    opacity: 1
  })), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-actions"), (0, _defineProperty2.default)({
    position: 'absolute',
    insetInlineStart: 0,
    zIndex: 10,
    width: '100%',
    whiteSpace: 'nowrap',
    textAlign: 'center',
    opacity: 0,
    transition: "all ".concat(token.motionDurationSlow)
  }, "".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    zIndex: 10,
    width: fontSizeLG,
    margin: "0 ".concat(token.marginXXS, "px"),
    fontSize: fontSizeLG,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationSlow)
  })), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-actions, ").concat(itemCls, "-actions:hover"), (0, _defineProperty2.default)({}, "".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    color: new _tinycolor.TinyColor(colorTextLightSolid).setAlpha(0.65).toRgbString(),
    '&:hover': {
      color: colorTextLightSolid
    }
  })), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-thumbnail, ").concat(itemCls, "-thumbnail img"), {
    position: 'static',
    display: 'block',
    width: '100%',
    height: '100%',
    objectFit: 'contain'
  }), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-name"), {
    display: 'none',
    textAlign: 'center'
  }), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-file + ").concat(itemCls, "-name"), {
    position: 'absolute',
    bottom: token.margin,
    display: 'block',
    width: "calc(100% - ".concat(token.paddingXS * 2, "px)")
  }), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-uploading"), (_$concat6 = {}, (0, _defineProperty2.default)(_$concat6, "&".concat(itemCls), {
    backgroundColor: token.colorFillAlter
  }), (0, _defineProperty2.default)(_$concat6, "&::before, ".concat(iconCls, "-eye, ").concat(iconCls, "-download, ").concat(iconCls, "-delete"), {
    display: 'none'
  }), _$concat6)), (0, _defineProperty2.default)(_$concat$concat4, "".concat(itemCls, "-progress"), {
    bottom: token.marginXL,
    width: "calc(100% - ".concat(token.paddingXS * 2, "px)"),
    paddingInlineStart: 0
  }), _$concat$concat4)), _extends3)));
};
exports.genPictureCardStyle = genPictureCardStyle;