"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classNames = _interopRequireDefault(require("../../_util/classNames"));
var _KeyCode = _interopRequireDefault(require("../../_util/KeyCode"));
var _omit = _interopRequireDefault(require("../../_util/omit"));
var _IDrawerPropTypes = require("./IDrawerPropTypes");
var _utils = require("./utils");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var currentDrawer = {};
var DrawerChild = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: (0, _IDrawerPropTypes.drawerChildProps)(),
  emits: ['close', 'handleClick', 'change'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      slots = _ref.slots;
    var contentWrapper = (0, _vue.shallowRef)();
    var dom = (0, _vue.shallowRef)();
    var maskDom = (0, _vue.shallowRef)();
    var handlerDom = (0, _vue.shallowRef)();
    var contentDom = (0, _vue.shallowRef)();
    var levelDom = [];
    var drawerId = "drawer_id_".concat(Number((Date.now() + Math.random()).toString().replace('.', Math.round(Math.random() * 9).toString())).toString(16));
    (0, _vue.onMounted)(function () {
      (0, _vue.nextTick)(function () {
        var _a;
        var open = props.open,
          getContainer = props.getContainer,
          showMask = props.showMask,
          autofocus = props.autofocus;
        var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
        getLevelDom(props);
        if (open) {
          if (container && container.parentNode === document.body) {
            currentDrawer[drawerId] = open;
          }
          (0, _vue.nextTick)(function () {
            if (autofocus) {
              domFocus();
            }
          });
          if (showMask) {
            (_a = props.scrollLocker) === null || _a === void 0 ? void 0 : _a.lock();
          }
        }
      });
    });
    (0, _vue.watch)(function () {
      return props.level;
    }, function () {
      getLevelDom(props);
    }, {
      flush: 'post'
    });
    (0, _vue.watch)(function () {
      return props.open;
    }, function () {
      var open = props.open,
        getContainer = props.getContainer,
        scrollLocker = props.scrollLocker,
        showMask = props.showMask,
        autofocus = props.autofocus;
      var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
      if (container && container.parentNode === document.body) {
        currentDrawer[drawerId] = !!open;
      }
      if (open) {
        if (autofocus) {
          domFocus();
        }
        if (showMask) {
          scrollLocker === null || scrollLocker === void 0 ? void 0 : scrollLocker.lock();
        }
      } else {
        scrollLocker === null || scrollLocker === void 0 ? void 0 : scrollLocker.unLock();
      }
    }, {
      flush: 'post'
    });
    (0, _vue.onUnmounted)(function () {
      var _a;
      var open = props.open;
      delete currentDrawer[drawerId];
      if (open) {
        document.body.style.touchAction = '';
      }
      (_a = props.scrollLocker) === null || _a === void 0 ? void 0 : _a.unLock();
    });
    (0, _vue.watch)(function () {
      return props.placement;
    }, function (val) {
      if (val) {
        // test 的 bug, 有动画过场，删除 dom
        contentDom.value = null;
      }
    });
    var domFocus = function domFocus() {
      var _a, _b;
      (_b = (_a = dom.value) === null || _a === void 0 ? void 0 : _a.focus) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var onClose = function onClose(e) {
      emit('close', e);
    };
    var onKeyDown = function onKeyDown(e) {
      if (e.keyCode === _KeyCode.default.ESC) {
        e.stopPropagation();
        onClose(e);
      }
    };
    var onAfterVisibleChange = function onAfterVisibleChange() {
      var open = props.open,
        afterVisibleChange = props.afterVisibleChange;
      if (afterVisibleChange) {
        afterVisibleChange(!!open);
      }
    };
    var getLevelDom = function getLevelDom(_ref2) {
      var level = _ref2.level,
        getContainer = _ref2.getContainer;
      if (_utils.windowIsUndefined) {
        return;
      }
      var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
      var parent = container ? container.parentNode : null;
      levelDom = [];
      if (level === 'all') {
        var children = parent ? Array.prototype.slice.call(parent.children) : [];
        children.forEach(function (child) {
          if (child.nodeName !== 'SCRIPT' && child.nodeName !== 'STYLE' && child.nodeName !== 'LINK' && child !== container) {
            levelDom.push(child);
          }
        });
      } else if (level) {
        (0, _utils.dataToArray)(level).forEach(function (key) {
          document.querySelectorAll(key).forEach(function (item) {
            levelDom.push(item);
          });
        });
      }
    };
    var onHandleClick = function onHandleClick(e) {
      emit('handleClick', e);
    };
    var canOpen = (0, _vue.shallowRef)(false);
    (0, _vue.watch)(dom, function () {
      (0, _vue.nextTick)(function () {
        canOpen.value = true;
      });
    });
    return function () {
      var _classnames;
      var _a, _b;
      var width = props.width,
        height = props.height,
        $open = props.open,
        prefixCls = props.prefixCls,
        placement = props.placement,
        level = props.level,
        levelMove = props.levelMove,
        ease = props.ease,
        duration = props.duration,
        getContainer = props.getContainer,
        onChange = props.onChange,
        afterVisibleChange = props.afterVisibleChange,
        showMask = props.showMask,
        maskClosable = props.maskClosable,
        maskStyle = props.maskStyle,
        keyboard = props.keyboard,
        getOpenCount = props.getOpenCount,
        scrollLocker = props.scrollLocker,
        contentWrapperStyle = props.contentWrapperStyle,
        style = props.style,
        className = props.class,
        rootClassName = props.rootClassName,
        rootStyle = props.rootStyle,
        maskMotion = props.maskMotion,
        motion = props.motion,
        inline = props.inline,
        otherProps = __rest(props, ["width", "height", "open", "prefixCls", "placement", "level", "levelMove", "ease", "duration", "getContainer", "onChange", "afterVisibleChange", "showMask", "maskClosable", "maskStyle", "keyboard", "getOpenCount", "scrollLocker", "contentWrapperStyle", "style", "class", "rootClassName", "rootStyle", "maskMotion", "motion", "inline"]);
      // 首次渲染都将是关闭状态。
      var open = $open && canOpen.value;
      var wrapperClassName = (0, _classNames.default)(prefixCls, (_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefixCls, "-").concat(placement), true), (0, _defineProperty2.default)(_classnames, "".concat(prefixCls, "-open"), open), (0, _defineProperty2.default)(_classnames, "".concat(prefixCls, "-inline"), inline), (0, _defineProperty2.default)(_classnames, 'no-mask', !showMask), (0, _defineProperty2.default)(_classnames, rootClassName, true), _classnames));
      var motionProps = typeof motion === 'function' ? motion(placement) : motion;
      return (0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, (0, _omit.default)(otherProps, ['switchScrollingEffect', 'autofocus'])), {}, {
        "tabindex": -1,
        "class": wrapperClassName,
        "style": rootStyle,
        "ref": dom,
        "onKeydown": open && keyboard ? onKeyDown : undefined
      }), [(0, _vue.createVNode)(_vue.Transition, maskMotion, {
        default: function _default() {
          return [showMask && (0, _vue.withDirectives)((0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-mask"),
            "onClick": maskClosable ? onClose : undefined,
            "style": maskStyle,
            "ref": maskDom
          }, null), [[_vue.vShow, open]])];
        }
      }), (0, _vue.createVNode)(_vue.Transition, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, motionProps), {}, {
        "onAfterEnter": onAfterVisibleChange,
        "onAfterLeave": onAfterVisibleChange
      }), {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-content-wrapper"),
            "style": [contentWrapperStyle],
            "ref": contentWrapper
          }, [(0, _vue.createVNode)("div", {
            "class": ["".concat(prefixCls, "-content"), className],
            "style": style,
            "ref": contentDom
          }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]), slots.handler ? (0, _vue.createVNode)("div", {
            "onClick": onHandleClick,
            "ref": handlerDom
          }, [(_b = slots.handler) === null || _b === void 0 ? void 0 : _b.call(slots)]) : null]), [[_vue.vShow, open]])];
        }
      })]);
    };
  }
});
var _default2 = DrawerChild;
exports.default = _default2;