"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _omit = _interopRequireDefault(require("../_util/omit"));
var _inputProps = require("./inputProps");
var _commonUtils = require("./utils/commonUtils");
var _antInputDirective = _interopRequireDefault(require("../_util/antInputDirective"));
var _BaseInput = _interopRequireDefault(require("./BaseInput"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var _default = (0, _vue.defineComponent)({
  name: 'VCInput',
  inheritAttrs: false,
  props: (0, _inputProps.inputProps)(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      expose = _ref.expose,
      emit = _ref.emit;
    var stateValue = (0, _vue.shallowRef)(props.value === undefined ? props.defaultValue : props.value);
    var focused = (0, _vue.shallowRef)(false);
    var inputRef = (0, _vue.shallowRef)();
    (0, _vue.watch)(function () {
      return props.value;
    }, function () {
      stateValue.value = props.value;
    });
    (0, _vue.watch)(function () {
      return props.disabled;
    }, function () {
      if (props.disabled) {
        focused.value = false;
      }
    });
    var focus = function focus(option) {
      if (inputRef.value) {
        (0, _commonUtils.triggerFocus)(inputRef.value, option);
      }
    };
    var blur = function blur() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var setSelectionRange = function setSelectionRange(start, end, direction) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.setSelectionRange(start, end, direction);
    };
    var select = function select() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.select();
    };
    expose({
      focus: focus,
      blur: blur,
      input: inputRef,
      stateValue: stateValue,
      setSelectionRange: setSelectionRange,
      select: select
    });
    var triggerChange = function triggerChange(e) {
      emit('change', e);
    };
    var instance = (0, _vue.getCurrentInstance)();
    var setValue = function setValue(value, callback) {
      if (stateValue.value === value) {
        return;
      }
      if (props.value === undefined) {
        stateValue.value = value;
      } else {
        (0, _vue.nextTick)(function () {
          if (inputRef.value.value !== stateValue.value) {
            instance.update();
          }
        });
      }
      (0, _vue.nextTick)(function () {
        callback && callback();
      });
    };
    var handleChange = function handleChange(e) {
      var _e$target = e.target,
        value = _e$target.value,
        composing = _e$target.composing;
      // https://github.com/vueComponent/ant-design-vue/issues/2203
      if ((e.isComposing || composing) && props.lazy || stateValue.value === value) return;
      var newVal = e.target.value;
      (0, _commonUtils.resolveOnChange)(inputRef.value, e, triggerChange);
      setValue(newVal);
    };
    var handleKeyDown = function handleKeyDown(e) {
      if (e.keyCode === 13) {
        emit('pressEnter', e);
      }
      emit('keydown', e);
    };
    var handleFocus = function handleFocus(e) {
      focused.value = true;
      emit('focus', e);
    };
    var handleBlur = function handleBlur(e) {
      focused.value = false;
      emit('blur', e);
    };
    var handleReset = function handleReset(e) {
      (0, _commonUtils.resolveOnChange)(inputRef.value, e, triggerChange);
      setValue('', function () {
        focus();
      });
    };
    var getInputElement = function getInputElement() {
      var _a, _b;
      var _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        disabled = props.disabled,
        _props$valueModifiers = props.valueModifiers,
        valueModifiers = _props$valueModifiers === void 0 ? {} : _props$valueModifiers,
        htmlSize = props.htmlSize,
        autocomplete = props.autocomplete,
        prefixCls = props.prefixCls,
        inputClassName = props.inputClassName,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix,
        allowClear = props.allowClear,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type;
      var otherProps = (0, _omit.default)(props, ['prefixCls', 'onPressEnter', 'addonBefore', 'addonAfter', 'prefix', 'suffix', 'allowClear',
      // Input elements must be either controlled or uncontrolled,
      // specify either the value prop, or the defaultValue prop, but not both.
      'defaultValue', 'size', 'bordered', 'htmlSize', 'lazy', 'showCount', 'valueModifiers', 'showCount', 'affixWrapperClassName', 'groupClassName', 'inputClassName', 'wrapperClassName']);
      var inputProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, otherProps), attrs), {
        autocomplete: autocomplete,
        onChange: handleChange,
        onInput: handleChange,
        onFocus: handleFocus,
        onBlur: handleBlur,
        onKeydown: handleKeyDown,
        class: (0, _classNames3.default)(prefixCls, (0, _defineProperty2.default)({}, "".concat(prefixCls, "-disabled"), disabled), inputClassName, !(0, _commonUtils.hasAddon)({
          addonAfter: addonAfter,
          addonBefore: addonBefore
        }) && !(0, _commonUtils.hasPrefixSuffix)({
          prefix: prefix,
          suffix: suffix,
          allowClear: allowClear
        }) && attrs.class),
        ref: inputRef,
        key: 'ant-input',
        size: htmlSize,
        type: type
      });
      if (valueModifiers.lazy) {
        delete inputProps.onInput;
      }
      if (!inputProps.autofocus) {
        delete inputProps.autofocus;
      }
      var inputNode = (0, _vue.createVNode)("input", (0, _omit.default)(inputProps, ['size']), null);
      return (0, _vue.withDirectives)(inputNode, [[_antInputDirective.default]]);
    };
    var getSuffix = function getSuffix() {
      var _a;
      var maxlength = props.maxlength,
        _props$suffix2 = props.suffix,
        suffix = _props$suffix2 === void 0 ? (_a = slots.suffix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$suffix2,
        showCount = props.showCount,
        prefixCls = props.prefixCls;
      // Max length value
      var hasMaxLength = Number(maxlength) > 0;
      if (suffix || showCount) {
        var valueLength = (0, _toConsumableArray2.default)((0, _commonUtils.fixControlledValue)(stateValue.value)).length;
        var dataCount = (0, _typeof2.default)(showCount) === 'object' ? showCount.formatter({
          count: valueLength,
          maxlength: maxlength
        }) : "".concat(valueLength).concat(hasMaxLength ? " / ".concat(maxlength) : '');
        return (0, _vue.createVNode)(_vue.Fragment, null, [!!showCount && (0, _vue.createVNode)("span", {
          "class": (0, _classNames3.default)("".concat(prefixCls, "-show-count-suffix"), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-show-count-has-suffix"), !!suffix))
        }, [dataCount]), suffix]);
      }
      return null;
    };
    (0, _vue.onMounted)(function () {
      if (process.env.NODE_ENV === 'test') {
        if (props.autofocus) {
          focus();
        }
      }
    });
    return function () {
      var prefixCls = props.prefixCls,
        disabled = props.disabled,
        rest = __rest(props, ["prefixCls", "disabled"]);
      return (0, _vue.createVNode)(_BaseInput.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, rest), attrs), {}, {
        "prefixCls": prefixCls,
        "inputElement": getInputElement(),
        "handleReset": handleReset,
        "value": (0, _commonUtils.fixControlledValue)(stateValue.value),
        "focused": focused.value,
        "triggerFocus": focus,
        "suffix": getSuffix(),
        "disabled": disabled
      }), slots);
    };
  }
});
exports.default = _default;