"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _default2 = (0, _vue.defineComponent)({
  name: 'PresetPanel',
  props: {
    prefixCls: String,
    presets: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    onClick: Function,
    onHover: Function
  },
  setup: function setup(props) {
    return function () {
      if (!props.presets.length) {
        return null;
      }
      return (0, _vue.createVNode)("div", {
        "class": "".concat(props.prefixCls, "-presets")
      }, [(0, _vue.createVNode)("ul", null, [props.presets.map(function (_ref, index) {
        var label = _ref.label,
          value = _ref.value;
        return (0, _vue.createVNode)("li", {
          "key": index,
          "onClick": function onClick() {
            props.onClick(value);
          },
          "onMouseenter": function onMouseenter() {
            var _a;
            (_a = props.onHover) === null || _a === void 0 ? void 0 : _a.call(props, value);
          },
          "onMouseleave": function onMouseleave() {
            var _a;
            (_a = props.onHover) === null || _a === void 0 ? void 0 : _a.call(props, null);
          }
        }, [label]);
      })])]);
    };
  }
});
exports.default = _default2;