"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = usePresets;
var _vue = require("vue");
var _warning = _interopRequireDefault(require("../../vc-util/warning"));
function usePresets(presets, legacyRanges) {
  return (0, _vue.computed)(function () {
    if (presets === null || presets === void 0 ? void 0 : presets.value) {
      return presets.value;
    }
    if (legacyRanges === null || legacyRanges === void 0 ? void 0 : legacyRanges.value) {
      (0, _warning.default)(false, '`ranges` is deprecated. Please use `presets` instead.');
      var rangeLabels = Object.keys(legacyRanges.value);
      return rangeLabels.map(function (label) {
        var range = legacyRanges.value[label];
        var newValues = typeof range === 'function' ? range() : range;
        return {
          label: label,
          value: newValues
        };
      });
    }
    return [];
  });
}