"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VcStepProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _vueTypes = _interopRequireWildcard(require("../_util/vue-types"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _warning = _interopRequireDefault(require("../_util/warning"));
var _type = require("../_util/type");
var _omit = _interopRequireDefault(require("../_util/omit"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function isString(str) {
  return typeof str === 'string';
}
function noop() {}
var VcStepProps = function VcStepProps() {
  return {
    prefixCls: String,
    itemWidth: String,
    active: {
      type: Boolean,
      default: undefined
    },
    disabled: {
      type: Boolean,
      default: undefined
    },
    status: (0, _type.stringType)(),
    iconPrefix: String,
    icon: _vueTypes.default.any,
    adjustMarginRight: String,
    stepNumber: Number,
    stepIndex: Number,
    description: _vueTypes.default.any,
    title: _vueTypes.default.any,
    subTitle: _vueTypes.default.any,
    progressDot: (0, _vueTypes.withUndefined)(_vueTypes.default.oneOfType([_vueTypes.default.looseBool, _vueTypes.default.func])),
    tailContent: _vueTypes.default.any,
    icons: _vueTypes.default.shape({
      finish: _vueTypes.default.any,
      error: _vueTypes.default.any
    }).loose,
    onClick: (0, _type.functionType)(),
    onStepClick: (0, _type.functionType)(),
    stepIcon: (0, _type.functionType)(),
    itemRender: (0, _type.functionType)(),
    __legacy: (0, _type.booleanType)()
  };
};
exports.VcStepProps = VcStepProps;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'Step',
  inheritAttrs: false,
  props: VcStepProps(),
  slots: ['title', 'subTitle', 'description', 'tailContent', 'stepIcon', 'progressDot'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var onItemClick = function onItemClick(e) {
      emit('click', e);
      emit('stepClick', props.stepIndex);
    };
    if (props.__legacy !== false) {
      (0, _warning.default)(false, 'Steps', 'Step is deprecated, and not support inline type. Please use `items` directly. ');
    }
    var renderIconNode = function renderIconNode(_ref2) {
      var _classNames;
      var icon = _ref2.icon,
        title = _ref2.title,
        description = _ref2.description;
      var prefixCls = props.prefixCls,
        stepNumber = props.stepNumber,
        status = props.status,
        iconPrefix = props.iconPrefix,
        icons = props.icons,
        _props$progressDot = props.progressDot,
        progressDot = _props$progressDot === void 0 ? slots.progressDot : _props$progressDot,
        _props$stepIcon = props.stepIcon,
        stepIcon = _props$stepIcon === void 0 ? slots.stepIcon : _props$stepIcon;
      var iconNode;
      var iconClassName = (0, _classNames3.default)("".concat(prefixCls, "-icon"), "".concat(iconPrefix, "icon"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(iconPrefix, "icon-").concat(icon), icon && isString(icon)), (0, _defineProperty2.default)(_classNames, "".concat(iconPrefix, "icon-check"), !icon && status === 'finish' && (icons && !icons.finish || !icons)), (0, _defineProperty2.default)(_classNames, "".concat(iconPrefix, "icon-cross"), !icon && status === 'error' && (icons && !icons.error || !icons)), _classNames));
      var iconDot = (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls, "-icon-dot")
      }, null);
      // `progressDot` enjoy the highest priority
      if (progressDot) {
        if (typeof progressDot === 'function') {
          iconNode = (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls, "-icon")
          }, [progressDot({
            iconDot: iconDot,
            index: stepNumber - 1,
            status: status,
            title: title,
            description: description,
            prefixCls: prefixCls
          })]);
        } else {
          iconNode = (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls, "-icon")
          }, [iconDot]);
        }
      } else if (icon && !isString(icon)) {
        iconNode = (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icon]);
      } else if (icons && icons.finish && status === 'finish') {
        iconNode = (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icons.finish]);
      } else if (icons && icons.error && status === 'error') {
        iconNode = (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icons.error]);
      } else if (icon || status === 'finish' || status === 'error') {
        iconNode = (0, _vue.createVNode)("span", {
          "class": iconClassName
        }, null);
      } else {
        iconNode = (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [stepNumber]);
      }
      if (stepIcon) {
        iconNode = stepIcon({
          index: stepNumber - 1,
          status: status,
          title: title,
          description: description,
          node: iconNode
        });
      }
      return iconNode;
    };
    return function () {
      var _classNames2;
      var _a, _b, _c, _d;
      var prefixCls = props.prefixCls,
        itemWidth = props.itemWidth,
        active = props.active,
        _props$status = props.status,
        status = _props$status === void 0 ? 'wait' : _props$status,
        tailContent = props.tailContent,
        adjustMarginRight = props.adjustMarginRight,
        disabled = props.disabled,
        _props$title = props.title,
        title = _props$title === void 0 ? (_a = slots.title) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$title,
        _props$description = props.description,
        description = _props$description === void 0 ? (_b = slots.description) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$description,
        _props$subTitle = props.subTitle,
        subTitle = _props$subTitle === void 0 ? (_c = slots.subTitle) === null || _c === void 0 ? void 0 : _c.call(slots) : _props$subTitle,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_d = slots.icon) === null || _d === void 0 ? void 0 : _d.call(slots) : _props$icon,
        onClick = props.onClick,
        onStepClick = props.onStepClick;
      var mergedStatus = status || 'wait';
      var classString = (0, _classNames3.default)("".concat(prefixCls, "-item"), "".concat(prefixCls, "-item-").concat(mergedStatus), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item-custom"), icon), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item-active"), active), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item-disabled"), disabled === true), _classNames2));
      var stepItemStyle = {};
      if (itemWidth) {
        stepItemStyle.width = itemWidth;
      }
      if (adjustMarginRight) {
        stepItemStyle.marginRight = adjustMarginRight;
      }
      var accessibilityProps = {
        onClick: onClick || noop
      };
      if (onStepClick && !disabled) {
        accessibilityProps.role = 'button';
        accessibilityProps.tabindex = 0;
        accessibilityProps.onClick = onItemClick;
      }
      var stepNode = (0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, (0, _omit.default)(attrs, ['__legacy'])), {}, {
        "class": [classString, attrs.class],
        "style": [attrs.style, stepItemStyle]
      }), [(0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, accessibilityProps), {}, {
        "class": "".concat(prefixCls, "-item-container")
      }), [(0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-item-tail")
      }, [tailContent]), (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-item-icon")
      }, [renderIconNode({
        icon: icon,
        title: title,
        description: description
      })]), (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-item-content")
      }, [(0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-item-title")
      }, [title, subTitle && (0, _vue.createVNode)("div", {
        "title": typeof subTitle === 'string' ? subTitle : undefined,
        "class": "".concat(prefixCls, "-item-subtitle")
      }, [subTitle])]), description && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-item-description")
      }, [description])])])]);
      if (props.itemRender) {
        return props.itemRender(stepNode);
      }
      return stepNode;
    };
  }
});
exports.default = _default;