import _extends from "@babel/runtime/helpers/esm/extends";
import { provide, defineComponent, unref, inject, watch, shallowRef } from 'vue';
import CacheEntity from './Cache';
import { arrayType, booleanType, objectType, someType, stringType, withInstall } from '../type';
import initDefaultProps from '../props-util/initDefaultProps';
export var ATTR_TOKEN = 'data-token-hash';
export var ATTR_MARK = 'data-css-hash';
export var ATTR_DEV_CACHE_PATH = 'data-dev-cache-path';
// Mark css-in-js instance in style element
export var CSS_IN_JS_INSTANCE = '__cssinjs_instance__';
export var CSS_IN_JS_INSTANCE_ID = Math.random().toString(12).slice(2);
export function createCache() {
  if (typeof document !== 'undefined' && document.head && document.body) {
    var styles = document.body.querySelectorAll("style[".concat(ATTR_MARK, "]")) || [];
    var firstChild = document.head.firstChild;
    Array.from(styles).forEach(function (style) {
      style[CSS_IN_JS_INSTANCE] = style[CSS_IN_JS_INSTANCE] || CSS_IN_JS_INSTANCE_ID;
      // Not force move if no head
      document.head.insertBefore(style, firstChild);
    });
    // Deduplicate of moved styles
    var styleHash = {};
    Array.from(document.querySelectorAll("style[".concat(ATTR_MARK, "]"))).forEach(function (style) {
      var _a;
      var hash = style.getAttribute(ATTR_MARK);
      if (styleHash[hash]) {
        if (style[CSS_IN_JS_INSTANCE] === CSS_IN_JS_INSTANCE_ID) {
          (_a = style.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(style);
        }
      } else {
        styleHash[hash] = true;
      }
    });
  }
  return new CacheEntity();
}
var StyleContextKey = Symbol('StyleContextKey');
var defaultStyleContext = {
  cache: createCache(),
  defaultCache: true,
  hashPriority: 'low'
};
export var useStyleInject = function useStyleInject() {
  return inject(StyleContextKey, shallowRef(_extends({}, defaultStyleContext)));
};
export var useStyleProvider = function useStyleProvider(props) {
  var parentContext = useStyleInject();
  var context = shallowRef(_extends({}, defaultStyleContext));
  watch([props, parentContext], function () {
    var mergedContext = _extends({}, parentContext.value);
    var propsValue = unref(props);
    Object.keys(propsValue).forEach(function (key) {
      var value = propsValue[key];
      if (propsValue[key] !== undefined) {
        mergedContext[key] = value;
      }
    });
    var cache = propsValue.cache;
    mergedContext.cache = mergedContext.cache || createCache();
    mergedContext.defaultCache = !cache && parentContext.value.defaultCache;
    context.value = mergedContext;
  }, {
    immediate: true
  });
  provide(StyleContextKey, context);
  return context;
};
export var styleProviderProps = function styleProviderProps() {
  return {
    autoClear: booleanType(),
    /** @private Test only. Not work in production. */
    mock: stringType(),
    /**
     * Only set when you need ssr to extract style on you own.
     * If not provided, it will auto create <style /> on the end of Provider in server side.
     */
    cache: objectType(),
    /** Tell children that this context is default generated context */
    defaultCache: booleanType(),
    /** Use `:where` selector to reduce hashId css selector priority */
    hashPriority: stringType(),
    /** Tell cssinjs where to inject style in */
    container: someType(),
    /** Component wil render inline  `<style />` for fallback in SSR. Not recommend. */
    ssrInline: booleanType(),
    /** Transform css before inject in document. Please note that `transformers` do not support dynamic update */
    transformers: arrayType(),
    /**
     * Linters to lint css before inject in document.
     * Styles will be linted after transforming.
     * Please note that `linters` do not support dynamic update.
     */
    linters: arrayType()
  };
};
export var StyleProvider = withInstall(defineComponent({
  name: 'AStyleProvider',
  inheritAttrs: false,
  props: initDefaultProps(styleProviderProps(), defaultStyleContext),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    useStyleProvider(props);
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
}));
export default {
  useStyleInject: useStyleInject,
  useStyleProvider: useStyleProvider,
  StyleProvider: StyleProvider
};