import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import hash from '@emotion/hash';
// @ts-ignore
import unitless from '@emotion/unitless';
import { compile, serialize, stringify } from 'stylis';
import { contentQuotesLinter, hashedAnimationLinter } from '../linters';
import { useStyleInject, ATTR_DEV_CACHE_PATH, ATTR_MARK, ATTR_TOKEN, CSS_IN_JS_INSTANCE, CSS_IN_JS_INSTANCE_ID } from '../StyleContext';
import { supportLayer } from '../util';
import useGlobalCache from './useGlobalCache';
import canUseDom from '../../canUseDom';
import { removeCSS, updateCSS } from '../../../vc-util/Dom/dynamicCSS';
import { computed } from 'vue';
var isClientSide = canUseDom();
var SKIP_CHECK = '_skip_check_';
// ============================================================================
// ==                                 Parser                                 ==
// ============================================================================
// Preprocessor style content to browser support one
export function normalizeStyle(styleStr) {
  var serialized = serialize(compile(styleStr), stringify);
  return serialized.replace(/\{%%%\:[^;];}/g, ';');
}
function isCompoundCSSProperty(value) {
  return _typeof(value) === 'object' && value && SKIP_CHECK in value;
}
// 注入 hash 值
function injectSelectorHash(key, hashId, hashPriority) {
  if (!hashId) {
    return key;
  }
  var hashClassName = ".".concat(hashId);
  var hashSelector = hashPriority === 'low' ? ":where(".concat(hashClassName, ")") : hashClassName;
  // 注入 hashId
  var keys = key.split(',').map(function (k) {
    var _a;
    var fullPath = k.trim().split(/\s+/);
    // 如果 Selector 第一个是 HTML Element，那我们就插到它的后面。反之，就插到最前面。
    var firstPath = fullPath[0] || '';
    var htmlElement = ((_a = firstPath.match(/^\w+/)) === null || _a === void 0 ? void 0 : _a[0]) || '';
    firstPath = "".concat(htmlElement).concat(hashSelector).concat(firstPath.slice(htmlElement.length));
    return [firstPath].concat(_toConsumableArray(fullPath.slice(1))).join(' ');
  });
  return keys.join(',');
}
// Global effect style will mount once and not removed
// The effect will not save in SSR cache (e.g. keyframes)
var globalEffectStyleKeys = new Set();
/**
 * @private Test only. Clear the global effect style keys.
 */
export var _cf = process.env.NODE_ENV !== 'production' ? function () {
  return globalEffectStyleKeys.clear();
} : undefined;
// Parse CSSObject to style content
export var parseStyle = function parseStyle(interpolation) {
  var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
      root: true,
      parentSelectors: []
    },
    root = _ref.root,
    injectHash = _ref.injectHash,
    parentSelectors = _ref.parentSelectors;
  var hashId = config.hashId,
    layer = config.layer,
    path = config.path,
    hashPriority = config.hashPriority,
    _config$transformers = config.transformers,
    transformers = _config$transformers === void 0 ? [] : _config$transformers,
    _config$linters = config.linters,
    linters = _config$linters === void 0 ? [] : _config$linters;
  var styleStr = '';
  var effectStyle = {};
  function parseKeyframes(keyframes) {
    var animationName = keyframes.getName(hashId);
    if (!effectStyle[animationName]) {
      var _parseStyle = parseStyle(keyframes.style, config, {
          root: false,
          parentSelectors: parentSelectors
        }),
        _parseStyle2 = _slicedToArray(_parseStyle, 1),
        parsedStr = _parseStyle2[0];
      effectStyle[animationName] = "@keyframes ".concat(keyframes.getName(hashId)).concat(parsedStr);
    }
  }
  function flattenList(list) {
    var fullList = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    list.forEach(function (item) {
      if (Array.isArray(item)) {
        flattenList(item, fullList);
      } else if (item) {
        fullList.push(item);
      }
    });
    return fullList;
  }
  var flattenStyleList = flattenList(Array.isArray(interpolation) ? interpolation : [interpolation]);
  flattenStyleList.forEach(function (originStyle) {
    // Only root level can use raw string
    var style = typeof originStyle === 'string' && !root ? {} : originStyle;
    if (typeof style === 'string') {
      styleStr += "".concat(style, "\n");
    } else if (style._keyframe) {
      // Keyframe
      parseKeyframes(style);
    } else {
      var mergedStyle = transformers.reduce(function (prev, trans) {
        var _a;
        return ((_a = trans === null || trans === void 0 ? void 0 : trans.visit) === null || _a === void 0 ? void 0 : _a.call(trans, prev)) || prev;
      }, style);
      // Normal CSSObject
      Object.keys(mergedStyle).forEach(function (key) {
        var _a;
        var value = mergedStyle[key];
        if (_typeof(value) === 'object' && value && (key !== 'animationName' || !value._keyframe) && !isCompoundCSSProperty(value)) {
          var subInjectHash = false;
          // 当成嵌套对象来处理
          var mergedKey = key.trim();
          // Whether treat child as root. In most case it is false.
          var nextRoot = false;
          // 拆分多个选择器
          if ((root || injectHash) && hashId) {
            if (mergedKey.startsWith('@')) {
              // 略过媒体查询，交给子节点继续插入 hashId
              subInjectHash = true;
            } else {
              // 注入 hashId
              mergedKey = injectSelectorHash(key, hashId, hashPriority);
            }
          } else if (root && !hashId && (mergedKey === '&' || mergedKey === '')) {
            // In case of `{ '&': { a: { color: 'red' } } }` or `{ '': { a: { color: 'red' } } }` without hashId,
            // we will get `&{a:{color:red;}}` or `{a:{color:red;}}` string for stylis to compile.
            // But it does not conform to stylis syntax,
            // and finally we will get `{color:red;}` as css, which is wrong.
            // So we need to remove key in root, and treat child `{ a: { color: 'red' } }` as root.
            mergedKey = '';
            nextRoot = true;
          }
          var _parseStyle3 = parseStyle(value, config, {
              root: nextRoot,
              injectHash: subInjectHash,
              parentSelectors: [].concat(_toConsumableArray(parentSelectors), [mergedKey])
            }),
            _parseStyle4 = _slicedToArray(_parseStyle3, 2),
            parsedStr = _parseStyle4[0],
            childEffectStyle = _parseStyle4[1];
          effectStyle = _extends(_extends({}, effectStyle), childEffectStyle);
          styleStr += "".concat(mergedKey).concat(parsedStr);
        } else {
          var actualValue = (_a = value === null || value === void 0 ? void 0 : value.value) !== null && _a !== void 0 ? _a : value;
          if (process.env.NODE_ENV !== 'production' && (_typeof(value) !== 'object' || !(value === null || value === void 0 ? void 0 : value[SKIP_CHECK]))) {
            [contentQuotesLinter, hashedAnimationLinter].concat(_toConsumableArray(linters)).forEach(function (linter) {
              return linter(key, actualValue, {
                path: path,
                hashId: hashId,
                parentSelectors: parentSelectors
              });
            });
          }
          // 如果是样式则直接插入
          var styleName = key.replace(/[A-Z]/g, function (match) {
            return "-".concat(match.toLowerCase());
          });
          // Auto suffix with px
          var formatValue = actualValue;
          if (!unitless[key] && typeof formatValue === 'number' && formatValue !== 0) {
            formatValue = "".concat(formatValue, "px");
          }
          // handle animationName & Keyframe value
          if (key === 'animationName' && (value === null || value === void 0 ? void 0 : value._keyframe)) {
            parseKeyframes(value);
            formatValue = value.getName(hashId);
          }
          styleStr += "".concat(styleName, ":").concat(formatValue, ";");
        }
      });
    }
  });
  if (!root) {
    styleStr = "{".concat(styleStr, "}");
  } else if (layer && supportLayer()) {
    var layerCells = layer.split(',');
    var layerName = layerCells[layerCells.length - 1].trim();
    styleStr = "@layer ".concat(layerName, " {").concat(styleStr, "}");
    // Order of layer if needed
    if (layerCells.length > 1) {
      // zombieJ: stylis do not support layer order, so we need to handle it manually.
      styleStr = "@layer ".concat(layer, "{%%%:%}").concat(styleStr);
    }
  }
  return [styleStr, effectStyle];
};
// ============================================================================
// ==                                Register                                ==
// ============================================================================
function uniqueHash(path, styleStr) {
  return hash("".concat(path.join('%')).concat(styleStr));
}
// function Empty() {
//   return null;
// }
/**
 * Register a style to the global style sheet.
 */
export default function useStyleRegister(info, styleFn) {
  var styleContext = useStyleInject();
  var tokenKey = computed(function () {
    return info.value.token._tokenKey;
  });
  var fullPath = computed(function () {
    return [tokenKey.value].concat(_toConsumableArray(info.value.path));
  });
  // Check if need insert style
  var isMergedClientSide = isClientSide;
  if (process.env.NODE_ENV !== 'production' && styleContext.value.mock !== undefined) {
    isMergedClientSide = styleContext.value.mock === 'client';
  }
  // const [cacheStyle[0], cacheStyle[1], cacheStyle[2]]
  useGlobalCache('style', fullPath,
  // Create cache if needed
  function () {
    var styleObj = styleFn();
    var _styleContext$value = styleContext.value,
      hashPriority = _styleContext$value.hashPriority,
      container = _styleContext$value.container,
      transformers = _styleContext$value.transformers,
      linters = _styleContext$value.linters;
    var _info$value = info.value,
      path = _info$value.path,
      hashId = _info$value.hashId,
      layer = _info$value.layer;
    var _parseStyle5 = parseStyle(styleObj, {
        hashId: hashId,
        hashPriority: hashPriority,
        layer: layer,
        path: path.join('-'),
        transformers: transformers,
        linters: linters
      }),
      _parseStyle6 = _slicedToArray(_parseStyle5, 2),
      parsedStyle = _parseStyle6[0],
      effectStyle = _parseStyle6[1];
    var styleStr = normalizeStyle(parsedStyle);
    var styleId = uniqueHash(fullPath.value, styleStr);
    if (isMergedClientSide) {
      var style = updateCSS(styleStr, styleId, {
        mark: ATTR_MARK,
        prepend: 'queue',
        attachTo: container
      });
      style[CSS_IN_JS_INSTANCE] = CSS_IN_JS_INSTANCE_ID;
      // Used for `useCacheToken` to remove on batch when token removed
      style.setAttribute(ATTR_TOKEN, tokenKey.value);
      // Dev usage to find which cache path made this easily
      if (process.env.NODE_ENV !== 'production') {
        style.setAttribute(ATTR_DEV_CACHE_PATH, fullPath.value.join('|'));
      }
      // Inject client side effect style
      Object.keys(effectStyle).forEach(function (effectKey) {
        if (!globalEffectStyleKeys.has(effectKey)) {
          globalEffectStyleKeys.add(effectKey);
          // Inject
          updateCSS(normalizeStyle(effectStyle[effectKey]), "_effect-".concat(effectKey), {
            mark: ATTR_MARK,
            prepend: 'queue',
            attachTo: container
          });
        }
      });
    }
    return [styleStr, tokenKey.value, styleId];
  },
  // Remove cache if no need
  function (_ref2, fromHMR) {
    var _ref3 = _slicedToArray(_ref2, 3),
      styleId = _ref3[2];
    if ((fromHMR || styleContext.value.autoClear) && isClientSide) {
      removeCSS(styleId, {
        mark: ATTR_MARK
      });
    }
  });
  return function (node) {
    return node;
    // let styleNode: VueNode;
    // if (!styleContext.ssrInline || isMergedClientSide || !styleContext.defaultCache) {
    //   styleNode = <Empty />;
    // } else {
    //   styleNode = (
    //     <style
    //       {...{
    //         [ATTR_TOKEN]: cacheStyle.value[1],
    //         [ATTR_MARK]: cacheStyle.value[2],
    //       }}
    //       innerHTML={cacheStyle.value[0]}
    //     />
    //   );
    // }
    // return (
    //   <>
    //     {styleNode}
    //     {node}
    //   </>
    // );
  };
}
// ============================================================================
// ==                                  SSR                                   ==
// ============================================================================
export function extractStyle(cache) {
  // prefix with `style` is used for `useStyleRegister` to cache style context
  var styleKeys = Array.from(cache.cache.keys()).filter(function (key) {
    return key.startsWith('style%');
  });
  // const tokenStyles: Record<string, string[]> = {};
  var styleText = '';
  styleKeys.forEach(function (key) {
    var _cache$cache$get$ = _slicedToArray(cache.cache.get(key)[1], 3),
      styleStr = _cache$cache$get$[0],
      tokenKey = _cache$cache$get$[1],
      styleId = _cache$cache$get$[2];
    styleText += "<style ".concat(ATTR_TOKEN, "=\"").concat(tokenKey, "\" ").concat(ATTR_MARK, "=\"").concat(styleId, "\">").concat(styleStr, "</style>");
  });
  return styleText;
}