import { onMounted, onUnmounted, shallowRef } from 'vue';
import useResponsiveObserve from '../../_util/responsiveObserve';
function useBreakpoint() {
  var screens = shallowRef({});
  var token = null;
  var responsiveObserve = useResponsiveObserve();
  onMounted(function () {
    token = responsiveObserve.value.subscribe(function (supportScreens) {
      screens.value = supportScreens;
    });
  });
  onUnmounted(function () {
    responsiveObserve.value.unsubscribe(token);
  });
  return screens;
}
export default useBreakpoint;