import { onBeforeUnmount, shallowRef } from 'vue';
var useDestroyed = function useDestroyed() {
  var destroyed = shallowRef(false);
  onBeforeUnmount(function () {
    destroyed.value = true;
  });
  return destroyed;
};
export default useDestroyed;